/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class CriticalPathPresentationProvider
extends TimeGraphPresentationProvider {
    private static final StateItem[] STATE_TABLE = new StateItem[State.values().length];

    static {
        int i = 0;
        while (i < STATE_TABLE.length) {
            State state = State.values()[i];
            CriticalPathPresentationProvider.STATE_TABLE[i] = new StateItem(state.rgb, state.toString());
            ++i;
        }
    }

    public String getStateTypeName() {
        return Messages.getMessage(Messages.CriticalFlowView_stateTypeName);
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public int getStateTableIndex(@Nullable ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            return ((TimeEvent)event).getValue();
        }
        return -2;
    }

    private static State getMatchingState(int status) {
        switch (status) {
            case 0: {
                return State.RUNNING;
            }
            case 1: {
                return State.INTERRUPTED;
            }
            case 2: {
                return State.PREEMPTED;
            }
            case 3: {
                return State.TIMER;
            }
            case 4: {
                return State.BLOCK_DEVICE;
            }
            case 5: {
                return State.USER_INPUT;
            }
            case 6: {
                return State.NETWORK;
            }
            case 7: {
                return State.IPI;
            }
        }
        return State.UNKNOWN;
    }

    public String getEventName(@Nullable ITimeEvent event) {
        TimeEvent ev;
        if (event instanceof TimeEvent && (ev = (TimeEvent)event).hasValue()) {
            return NonNullUtils.nullToEmptyString((Object)((Object)CriticalPathPresentationProvider.getMatchingState(ev.getValue())));
        }
        return Messages.getMessage(Messages.CriticalFlowView_multipleStates);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNullByDefault(value={})
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        ITimeGraphEntry entry;
        LinkedHashMap<String, String> eventHoverToolTipInfo = super.getEventHoverToolTipInfo(event, hoverTime);
        if (eventHoverToolTipInfo == null) {
            eventHoverToolTipInfo = new LinkedHashMap<String, String>();
        }
        if ((entry = event.getEntry()) instanceof TimeGraphEntry) {
            SelectionTimeQueryFilter filter;
            long id = ((TimeGraphEntry)entry).getModel().getId();
            ITimeGraphDataProvider provider = BaseDataProviderTimeGraphView.getProvider((TimeGraphEntry)((TimeGraphEntry)entry));
            @NonNull @NonNull @NonNull TmfModelResponse tooltipResponse = provider.fetchTooltip(filter = new SelectionTimeQueryFilter(Collections.singletonList(hoverTime), Collections.singleton(id)), null);
            @NonNull @NonNull Map tooltipModel = (Map)tooltipResponse.getModel();
            if (tooltipModel != null) {
                eventHoverToolTipInfo.putAll(tooltipModel);
            }
        }
        return eventHoverToolTipInfo;
    }

    public static enum State {
        RUNNING(new RGB(51, 153, 0)),
        INTERRUPTED(new RGB(255, 220, 0)),
        PREEMPTED(new RGB(200, 100, 0)),
        TIMER(new RGB(51, 102, 153)),
        BLOCK_DEVICE(new RGB(102, 0, 204)),
        USER_INPUT(new RGB(90, 1, 1)),
        NETWORK(new RGB(255, 155, 255)),
        IPI(new RGB(102, 102, 204)),
        UNKNOWN(new RGB(64, 59, 51));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

