/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statesystem;

import com.google.common.annotations.VisibleForTesting;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.collect.BufferedBlockingQueue;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTmfStateProvider
implements ITmfStateProvider {
    private static final int DEFAULT_EVENTS_QUEUE_SIZE = 127;
    private static final int DEFAULT_EVENTS_CHUNK_SIZE = 127;
    private final ITmfTrace fTrace;
    private final BufferedBlockingQueue<ITmfEvent> fEventsQueue;
    private final Thread fEventHandlerThread;
    private boolean fStateSystemAssigned;
    private @Nullable ITmfStateSystemBuilder fSS = null;
    private @Nullable Throwable fFailureCause = null;
    private volatile long fSafeTime;
    private Runnable fPropagateExceptions = () -> {};
    private static final EndEvent END_EVENT = new EndEvent();
    private static final EmptyQueueEvent EMPTY_QUEUE_EVENT = new EmptyQueueEvent();

    public AbstractTmfStateProvider(ITmfTrace trace, String id) {
        this(trace, id, 127, 127);
    }

    @VisibleForTesting
    protected AbstractTmfStateProvider(ITmfTrace trace, String id, int queueSize, int chunkSize) {
        if (queueSize <= 0 || chunkSize <= 0) {
            throw new IllegalArgumentException("Cannot have negative sized buffer" + AbstractTmfStateProvider.formatError("queueSize", queueSize) + AbstractTmfStateProvider.formatError("chunkSize", chunkSize));
        }
        this.fTrace = trace;
        this.fEventsQueue = new BufferedBlockingQueue(queueSize, chunkSize);
        this.fStateSystemAssigned = false;
        this.fSafeTime = trace.getStartTime().toNanos() - 1L;
        this.fEventHandlerThread = new Thread(() -> SafeRunner.run((ISafeRunnable)new EventProcessor()), String.valueOf(id) + " Event Handler");
    }

    private static String formatError(String name, int value) {
        return value <= 0 ? " " + name + " = " + value : "";
    }

    protected @Nullable ITmfStateSystemBuilder getStateSystemBuilder() {
        return this.fSS;
    }

    @Override
    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    @Override
    public long getStartTime() {
        return this.fTrace.getStartTime().toNanos();
    }

    @Override
    public long getLatestSafeTime() {
        return this.fSafeTime;
    }

    @Override
    public void assignTargetStateSystem(ITmfStateSystemBuilder ssb) {
        this.fSS = ssb;
        this.fStateSystemAssigned = true;
        this.fEventHandlerThread.start();
    }

    @Override
    public @Nullable ITmfStateSystem getAssignedStateSystem() {
        return this.fSS;
    }

    @Override
    public void dispose() {
        try {
            this.fEventsQueue.put((Object)END_EVENT);
            this.fEventsQueue.flushInputBuffer();
            this.fEventHandlerThread.join();
        }
        catch (InterruptedException e) {
            Activator.logError("Error disposing state provider", e);
        }
        this.fStateSystemAssigned = false;
        this.fSS = null;
    }

    @Override
    public void processEvent(ITmfEvent event) {
        if (!this.fStateSystemAssigned) {
            throw new IllegalStateException("Cannot process event without a target state system. ID: " + this.getClass().getSimpleName());
        }
        this.fPropagateExceptions.run();
        ITmfEvent curEvent = event;
        this.fEventsQueue.put((Object)curEvent);
    }

    @Override
    public void fail(Throwable cause) {
        this.fFailureCause = cause;
    }

    @Override
    public @Nullable Throwable getFailureCause() {
        return this.fFailureCause;
    }

    public void waitForEmptyQueue() {
        try {
            this.fEventsQueue.put((Object)EMPTY_QUEUE_EVENT);
            this.fEventsQueue.flushInputBuffer();
            while (!this.fEventsQueue.isEmpty()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected abstract void eventHandle(ITmfEvent var1);

    private static class EmptyQueueEvent
    extends TmfEvent {
        public EmptyQueueEvent() {
            super(null, -1L, null, null, null);
        }
    }

    private static class EndEvent
    extends TmfEvent {
        public EndEvent() {
            super(null, -1L, null, null, null);
        }
    }

    private class EventProcessor
    implements ISafeRunnable {
        private @Nullable ITmfEvent currentEvent;
        private boolean fDone = false;

        private EventProcessor() {
        }

        public void run() {
            if (!AbstractTmfStateProvider.this.fStateSystemAssigned) {
                Activator.logError("Cannot run event manager without assigning a target state system first!");
                return;
            }
            ITmfEvent event = (ITmfEvent)AbstractTmfStateProvider.this.fEventsQueue.take();
            while (event != END_EVENT) {
                if (event == EMPTY_QUEUE_EVENT) {
                    event = (ITmfEvent)AbstractTmfStateProvider.this.fEventsQueue.take();
                    continue;
                }
                this.currentEvent = event;
                AbstractTmfStateProvider.this.fSafeTime = event.getTimestamp().toNanos() - 1L;
                AbstractTmfStateProvider.this.eventHandle(event);
                event = (ITmfEvent)AbstractTmfStateProvider.this.fEventsQueue.take();
            }
            this.fDone = true;
            AbstractTmfStateProvider.this.done();
            this.closeStateSystem();
        }

        private void closeStateSystem() {
            long endTime;
            ITmfEvent event = this.currentEvent;
            long l = endTime = event == null ? 0L : event.getTimestamp().toNanos();
            if (AbstractTmfStateProvider.this.fSS != null) {
                AbstractTmfStateProvider.this.fSS.closeHistory(endTime);
            }
        }

        public void handleException(@Nullable Throwable exception) {
            RuntimeException rException = exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException("Error in threaded state history backend", exception);
            AbstractTmfStateProvider.this.fail(rException);
            AbstractTmfStateProvider.this.fPropagateExceptions = () -> {
                throw rException;
            };
            if (this.fDone) {
                return;
            }
            ITmfEvent event = (ITmfEvent)AbstractTmfStateProvider.this.fEventsQueue.take();
            while (event != END_EVENT) {
                event = event == EMPTY_QUEUE_EVENT ? (ITmfEvent)AbstractTmfStateProvider.this.fEventsQueue.take() : (ITmfEvent)AbstractTmfStateProvider.this.fEventsQueue.take();
            }
            this.closeStateSystem();
        }
    }
}

