/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.histogram;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.histogram.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class HistogramDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfTreeXYDataProvider<TmfTreeDataModel> {
    public static final String ID = "org.eclipse.tracecompass.internal.provisional.tmf.core.histogram.HistogramDataProvider";
    static final String TITLE = Objects.requireNonNull(Messages.HistogramDataProvider_Title);
    private static final AtomicLong TRACE_IDS = new AtomicLong();
    private final TmfStatisticsModule fModule;
    private @Nullable TmfModelResponse<List<TmfTreeDataModel>> fCached = null;
    private final long fTraceId = TRACE_IDS.getAndIncrement();
    private final long fTotalId = TRACE_IDS.getAndIncrement();
    private final long fLostId = TRACE_IDS.getAndIncrement();

    public HistogramDataProvider(ITmfTrace trace, TmfStatisticsModule module) {
        super(trace);
        this.fModule = module;
    }

    @Override
    public TmfModelResponse<List<TmfTreeDataModel>> fetchTree(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        if (this.fCached != null) {
            return this.fCached;
        }
        this.fModule.waitForInitialization();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new TmfTreeDataModel(this.fTraceId, -1L, this.getTrace().getName()));
        builder.add((Object)new TmfTreeDataModel(this.fTotalId, this.fTraceId, Objects.requireNonNull(Messages.HistogramDataProvider_Total)));
        ITmfStateSystem eventsSs = Objects.requireNonNull(this.fModule.getStateSystem("org.eclipse.linuxtools.tmf.statistics.types"));
        if (eventsSs.optQuarkAbsolute(new String[]{"lost_events"}) != -2) {
            builder.add((Object)new TmfTreeDataModel(this.fLostId, this.fTraceId, Objects.requireNonNull(Messages.HistogramDataProvider_Lost)));
        }
        if (eventsSs.waitUntilBuilt(0L)) {
            TmfModelResponse<ImmutableList> response = new TmfModelResponse<ImmutableList>(builder.build(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            this.fCached = response;
            return response;
        }
        return new TmfModelResponse<ImmutableList>(builder.build(), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }

    @Override
    public @NonNull TmfModelResponse<ITmfXyModel> fetchXY(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        long[] xValues = filter.getTimesRequested();
        if (!(filter instanceof SelectionTimeQueryFilter)) {
            return TmfXyResponseFactory.create(TITLE, xValues, Collections.emptyMap(), true);
        }
        Object selected = ((SelectionTimeQueryFilter)filter).getSelectedItems();
        int n = xValues.length;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ITmfStatistics stats = Objects.requireNonNull(this.fModule.getStatistics());
        if (selected.contains(this.fTotalId)) {
            List<Long> values = stats.histogramQuery(filter.getStart(), filter.getEnd(), n);
            double[] y = new double[n];
            Arrays.setAll(y, values::get);
            String totalName = String.valueOf(this.getTrace().getName()) + '/' + Messages.HistogramDataProvider_Total;
            builder.put((Object)totalName, (Object)new YModel(totalName, y));
        }
        ITmfStateSystem eventsSs = this.fModule.getStateSystem("org.eclipse.linuxtools.tmf.statistics.types");
        if (selected.contains(this.fLostId) && eventsSs != null) {
            try {
                YModel series = this.getLostEvents(eventsSs, xValues);
                builder.put((Object)series.getName(), (Object)series);
            }
            catch (StateSystemDisposedException e) {
                return TmfXyResponseFactory.createFailedResponse(CommonStatusMessage.STATE_SYSTEM_FAILED);
            }
        }
        return TmfXyResponseFactory.create(TITLE, xValues, (Map<String, IYModel>)builder.build(), true);
    }

    private YModel getLostEvents(ITmfStateSystem ss, long[] times) throws StateSystemDisposedException {
        int leEndQuark = ss.optQuarkAbsolute(new String[]{"lost_events"});
        int leCountQuark = ss.optQuarkAbsolute(new String[]{"event_types", "Lost event"});
        long step = (times[times.length - 1] - times[0]) / (long)times.length;
        double[] leY = new double[times.length];
        ITmfStateInterval lePrevValueInterval = null;
        ITmfStateInterval leEndInterval = null;
        ITmfStateInterval leCountInterval = null;
        long prevValue = 0L;
        int i = 0;
        while (i < times.length) {
            long t = times[i];
            if (t > ss.getCurrentEndTime()) break;
            if (ss.getStartTime() <= t) {
                if (leEndInterval == null || !leEndInterval.intersects(t)) {
                    leEndInterval = ss.querySingleState(t, leEndQuark);
                }
                if (leCountInterval == null || !leCountInterval.intersects(t)) {
                    leCountInterval = ss.querySingleState(t, leCountQuark);
                }
                Object endValue = leEndInterval.getValue();
                Object countValue = leCountInterval.getValue();
                long prevValueTime = leEndInterval.getStartTime() - 1L;
                if (prevValueTime >= ss.getStartTime()) {
                    Object prevValueObject;
                    if ((lePrevValueInterval == null || lePrevValueInterval.getEndTime() != prevValueTime) && (prevValueObject = (lePrevValueInterval = ss.querySingleState(prevValueTime, leCountQuark)).getValue()) instanceof Number) {
                        prevValue = ((Number)prevValueObject).longValue();
                    }
                } else {
                    prevValue = 0L;
                }
                if (endValue instanceof Number && countValue instanceof Number) {
                    long end = ((Number)endValue).longValue();
                    double count = ((Number)countValue).doubleValue();
                    if (end >= t) {
                        leY[i] = (double)step * (count - (double)prevValue) / (double)(end - leEndInterval.getStartTime());
                    }
                }
            }
            ++i;
        }
        String lostName = String.valueOf(this.getTrace().getName()) + '/' + Messages.HistogramDataProvider_Lost;
        return new YModel(lostName, leY);
    }

    @Override
    public String getId() {
        return ID;
    }
}

