/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.scatter;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreScatterDataProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public abstract class AbstractSegmentStoreScatterChartTreeViewer
extends AbstractSelectTreeViewer {
    private @Nullable ISegmentStoreProvider fSegmentProvider = null;
    private SegmentStoreProviderProgressListener fListener = new SegmentStoreProviderProgressListener();

    public AbstractSegmentStoreScatterChartTreeViewer(Composite parent) {
        super(parent, 1, "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.scatter.dataprovider");
        this.setLabelProvider((IBaseLabelProvider)new SegStoreScatterLabelProvider());
    }

    protected abstract @Nullable ISegmentStoreProvider getSegmentStoreProvider(ITmfTrace var1);

    protected @Nullable ITmfTreeDataProvider<@NonNull TmfTreeDataModel> getProvider(@NonNull ITmfTrace trace) {
        ISegmentStoreProvider segmentStoreProvider = this.getSegmentStoreProvider(trace);
        if (segmentStoreProvider == null) {
            return null;
        }
        this.fSegmentProvider = segmentStoreProvider;
        segmentStoreProvider.addListener((IAnalysisProgressListener)this.fListener);
        return SegmentStoreScatterDataProvider.getOrCreate((ITmfTrace)trace, (ISegmentStoreProvider)segmentStoreProvider);
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return () -> ImmutableList.of((Object)AbstractSegmentStoreScatterChartTreeViewer.createColumn((String)Messages.AbstractSegmentStoreScatterView_Type, Comparator.comparing(TmfTreeViewerEntry::getName)), (Object)new TmfTreeColumnData(Messages.AbstractSegmentStoreScatterView_Legend));
    }

    private final class SegStoreScatterLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        private SegStoreScatterLabelProvider() {
        }

        public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
            TmfGenericTreeEntry entry;
            if (columnIndex == 1 && element instanceof TmfGenericTreeEntry && AbstractSegmentStoreScatterChartTreeViewer.this.isChecked(element) && !(entry = (TmfGenericTreeEntry)element).hasChildren()) {
                return AbstractSegmentStoreScatterChartTreeViewer.this.getLegendImage(AbstractSegmentStoreScatterChartTreeViewer.getFullPath((TmfGenericTreeEntry)entry));
            }
            return null;
        }
    }

    private final class SegmentStoreProviderProgressListener
    implements IAnalysisProgressListener {
        private SegmentStoreProviderProgressListener() {
        }

        public void onComplete(ISegmentStoreProvider activeProvider, ISegmentStore<ISegment> data) {
            if (activeProvider.equals(AbstractSegmentStoreScatterChartTreeViewer.this.fSegmentProvider)) {
                AbstractSegmentStoreScatterChartTreeViewer.this.updateContent(AbstractSegmentStoreScatterChartTreeViewer.this.getWindowStartTime(), AbstractSegmentStoreScatterChartTreeViewer.this.getWindowEndTime(), false);
            }
        }
    }
}

