/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.breakpoints.provisional.OtherBreakpointCategory;
import org.eclipse.debug.ui.IBreakpointOrganizerDelegate;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class AbstractBreakpointOrganizerDelegate
implements IBreakpointOrganizerDelegate {
    private ListenerList<IPropertyChangeListener> fListeners = new ListenerList();

    @Override
    public void addBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public boolean canAdd(IBreakpoint breakpoint, IAdaptable category) {
        return category instanceof OtherBreakpointCategory;
    }

    @Override
    public boolean canRemove(IBreakpoint breakpoint, IAdaptable category) {
        return category instanceof OtherBreakpointCategory;
    }

    @Override
    public void dispose() {
        this.fListeners = new ListenerList();
    }

    @Override
    public void removeBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    protected void fireCategoryChanged(IAdaptable category) {
        if (this.fListeners.isEmpty()) {
            return;
        }
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, P_CATEGORY_CHANGED, (Object)category, null);
        Iterator iterator = this.fListeners.iterator();
        while (iterator.hasNext()) {
            IPropertyChangeListener iPropertyChangeListener;
            final IPropertyChangeListener listener = iPropertyChangeListener = (IPropertyChangeListener)iterator.next();
            ISafeRunnable runnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }

                public void run() throws Exception {
                    listener.propertyChange(event);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    @Override
    public IAdaptable[] getCategories() {
        return null;
    }
}

