/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.InputStream;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DiffImageDescriptor;
import org.eclipse.compare.internal.core.patch.FileDiffResult;
import org.eclipse.compare.internal.core.patch.HunkResult;
import org.eclipse.compare.internal.patch.PatchCompareEditorInput;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Image;

public class HunkTypedElement
implements ITypedElement,
IEncodedStreamContentAccessor,
IAdaptable {
    private final HunkResult fHunkResult;
    private final boolean fIsAfterState;
    private final boolean fFullContext;

    public HunkTypedElement(HunkResult result, boolean isAfterState, boolean fullContext) {
        this.fHunkResult = result;
        this.fIsAfterState = isAfterState;
        this.fFullContext = fullContext;
    }

    @Override
    public Image getImage() {
        LocalResourceManager imageCache = PatchCompareEditorInput.getImageCache(this.fHunkResult.getDiffResult().getConfiguration());
        ImageDescriptor imageDesc = CompareUIPlugin.getImageDescriptor("obj16/hunk_obj.gif");
        Image image = imageCache.createImage(imageDesc);
        if (!this.fHunkResult.isOK()) {
            return HunkTypedElement.getHunkErrorImage(image, imageCache, true);
        }
        if (this.fHunkResult.getFuzz() > 0) {
            return HunkTypedElement.getHunkOverlayImage(image, imageCache, "ovr16/warning_ov.gif", true);
        }
        return image;
    }

    public static Image getHunkErrorImage(Image baseImage, LocalResourceManager imageCache, boolean onLeft) {
        return HunkTypedElement.getHunkOverlayImage(baseImage, imageCache, "ovr16/error_ov.gif", onLeft);
    }

    private static Image getHunkOverlayImage(Image baseImage, LocalResourceManager imageCache, String path, boolean onLeft) {
        DiffImageDescriptor desc = new DiffImageDescriptor(baseImage, CompareUIPlugin.getImageDescriptor(path), 22, onLeft);
        Image image = imageCache.createImage((ImageDescriptor)desc);
        return image;
    }

    public boolean isManuallyMerged() {
        return this.getPatcher().isManuallyMerged(this.getHunkResult().getHunk());
    }

    private Patcher getPatcher() {
        return Patcher.getPatcher(this.fHunkResult.getDiffResult().getConfiguration());
    }

    @Override
    public String getName() {
        return this.fHunkResult.getHunk().getLabel();
    }

    @Override
    public String getType() {
        return this.fHunkResult.getDiffResult().getDiff().getTargetPath(this.fHunkResult.getDiffResult().getConfiguration()).getFileExtension();
    }

    @Override
    public InputStream getContents() throws CoreException {
        String contents = this.fHunkResult.getContents(this.fIsAfterState, this.fFullContext);
        return FileDiffResult.asInputStream((String)contents, (String)this.fHunkResult.getCharset());
    }

    @Override
    public String getCharset() throws CoreException {
        return this.fHunkResult.getCharset();
    }

    public HunkResult getHunkResult() {
        return this.fHunkResult;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IHunk.class) {
            return this.fHunkResult;
        }
        if (adapter == HunkResult.class) {
            return this.fHunkResult;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

