/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.kernel;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.LinuxTestCase;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.kernel.KernelAnalysisTestFactory;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.analysis.os.linux.core.tid.TidAnalysisModule;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.KernelPidAspect;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KernelPidAspectTest {
    private static final @NonNull LinuxTestCase KERNEL_TEST_CASE = KernelAnalysisTestFactory.KERNEL_SCHED;
    private ITmfTrace fTrace;

    private static void deleteSuppFiles(@NonNull ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    @Before
    public void setUp() {
        IAnalysisModule mod;
        TmfXmlKernelTraceStub trace = KERNEL_TEST_CASE.getKernelTrace();
        KernelPidAspectTest.deleteSuppFiles((ITmfTrace)trace);
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        IAnalysisModule module = null;
        Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, KernelAnalysisModule.class).iterator();
        while (iterator.hasNext()) {
            module = mod = (IAnalysisModule)iterator.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        module.waitForCompletion();
        iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, TidAnalysisModule.class).iterator();
        while (iterator.hasNext()) {
            module = mod = (IAnalysisModule)iterator.next();
        }
        Assert.assertNotNull((Object)module);
        module.schedule();
        module.waitForCompletion();
        this.fTrace = trace;
    }

    @After
    public void tearDown() {
        this.fTrace.dispose();
    }

    private Integer resolveNextEvent(ITmfContext context) {
        ITmfTrace trace = this.fTrace;
        ITmfEvent event = trace.getNext(context);
        Assert.assertNotNull((Object)event);
        return (Integer)TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)trace, KernelPidAspect.class, (ITmfEvent)event);
    }

    @Test
    public void testResolvePidAspect() {
        ITmfContext context = this.fTrace.seekEvent(0L);
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(10);
        expected.add(20);
        expected.add(20);
        expected.add(null);
        expected.add(20);
        expected.add(30);
        expected.add(20);
        ArrayList<Integer> pids = new ArrayList<Integer>();
        int i = 0;
        while (i < expected.size()) {
            pids.add(this.resolveNextEvent(context));
            ++i;
        }
        Assert.assertEquals(expected, pids);
    }
}

