/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.registry.LinuxStyle;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class ControlFlowPresentationProvider
extends TimeGraphPresentationProvider {
    private static final Map<Integer, StateItem> STATE_MAP;
    private static final List<StateItem> STATE_LIST;
    private static final StateItem[] STATE_TABLE;
    private Integer fAverageCharacterWidth = null;

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)ProcessStatus.UNKNOWN.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.UNKNOWN));
        builder.put((Object)ProcessStatus.RUN.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.USERMODE));
        builder.put((Object)ProcessStatus.RUN_SYTEMCALL.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.SYSCALL));
        builder.put((Object)ProcessStatus.INTERRUPTED.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.INTERRUPTED));
        builder.put((Object)ProcessStatus.WAIT_BLOCKED.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.WAIT_BLOCKED));
        builder.put((Object)ProcessStatus.WAIT_CPU.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.WAIT_FOR_CPU));
        builder.put((Object)ProcessStatus.WAIT_UNKNOWN.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.WAIT_UNKNOWN));
        STATE_MAP = builder.build();
        STATE_LIST = ImmutableList.copyOf(STATE_MAP.values());
        STATE_TABLE = STATE_LIST.toArray(new StateItem[STATE_LIST.size()]);
    }

    private static StateItem createState(LinuxStyle style) {
        return new StateItem(style.toMap());
    }

    public ControlFlowPresentationProvider() {
        super(Messages.ControlFlowView_stateTypeName);
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            int status = ((TimeEvent)event).getValue();
            return STATE_LIST.indexOf(ControlFlowPresentationProvider.getMatchingState(status));
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public String getEventName(ITimeEvent event) {
        TimeEvent ev;
        if (event instanceof TimeEvent && (ev = (TimeEvent)event).hasValue()) {
            return ControlFlowPresentationProvider.getMatchingState(ev.getValue()).getStateString();
        }
        return Messages.ControlFlowView_multipleStates;
    }

    private static StateItem getMatchingState(int status) {
        return STATE_MAP.getOrDefault(status, STATE_MAP.get(ProcessStatus.WAIT_UNKNOWN.getStateValue().unboxInt()));
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>(1);
        if (event instanceof NamedTimeEvent) {
            retMap.put(Messages.ControlFlowView_attributeSyscallName, ((NamedTimeEvent)event).getLabel());
        }
        return retMap;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        String cpu;
        LinkedHashMap<String, String> retMap = super.getEventHoverToolTipInfo(event, hoverTime);
        if (retMap == null) {
            retMap = new LinkedHashMap<String, String>(1);
        }
        if (!(event instanceof TimeEvent && ((TimeEvent)event).hasValue() && event.getEntry() instanceof ControlFlowEntry)) {
            return retMap;
        }
        ControlFlowEntry entry = (ControlFlowEntry)event.getEntry();
        ITimeGraphDataProvider dataProvider = BaseDataProviderTimeGraphView.getProvider((TimeGraphEntry)entry);
        @NonNull @NonNull @NonNull TmfModelResponse response = dataProvider.fetchTooltip(new SelectionTimeQueryFilter(hoverTime, hoverTime, 1, Collections.singletonList(entry.getModel().getId())), null);
        @NonNull @NonNull Map map = (Map)response.getModel();
        if (map != null && (cpu = (String)map.get("cpu")) != null) {
            retMap.put(Messages.ControlFlowView_attributeCpuName, cpu);
        }
        return retMap;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (this.fAverageCharacterWidth == null) {
            this.fAverageCharacterWidth = gc.getFontMetrics().getAverageCharWidth();
        }
        if (bounds.width <= this.fAverageCharacterWidth || !(event instanceof NamedTimeEvent)) {
            return;
        }
        NamedTimeEvent controlFlowEvent = (NamedTimeEvent)event;
        gc.setForeground(gc.getDevice().getSystemColor(1));
        Utils.drawText((GC)gc, (String)controlFlowEvent.getLabel(), (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
    }
}

