/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.callgraph;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ThreadNode;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.junit.Assert;
import org.junit.Test;

public class CallGraphAnalysisTest {
    private static final @NonNull String PROCESS_PATH = "Processes";
    private static final @NonNull String THREAD_PATH = "Thread";
    private static final @NonNull String CALLSTACK_PATH = "CallStack";
    private static final String QUARK_0 = "0";
    private static final String QUARK_1 = "1";
    private static final String QUARK_2 = "2";
    private static final Integer SMALL_AMOUNT_OF_SEGMENT = 3;
    private static final int LARGE_AMOUNT_OF_SEGMENTS = 1000;
    private static final String @NonNull [] CSP = new String[]{"CallStack"};
    private static final String @NonNull [] PP = new String[]{"Processes"};
    private static final String @NonNull [] TP = new String[]{"Thread"};

    private static @NonNull ITmfStateSystemBuilder createFixture() {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)"Test", (long)0L);
        return StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void CascadeTest() {
        ITmfStateSystemBuilder fixture = CallGraphAnalysisTest.createFixture();
        long start = 1L;
        long end = 1001L;
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int i = 1;
        while (i <= SMALL_AMOUNT_OF_SEGMENT) {
            int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{Integer.toString(i)});
            TmfStateValue statev = TmfStateValue.newValueLong((long)i);
            fixture.modifyAttribute(start, (ITmfStateValue)TmfStateValue.nullValue(), quark);
            fixture.modifyAttribute(start + (long)i, (ITmfStateValue)statev, quark);
            fixture.modifyAttribute(end - (long)i, (ITmfStateValue)TmfStateValue.nullValue(), quark);
            ++i;
        }
        fixture.closeHistory(1002L);
        CGAnalysis cga = new CGAnalysis();
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        @NonNull ISegmentStore segmentStore = cga.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        Object[] segments = segmentStore.toArray();
        Assert.assertEquals((String)"Number of segments Found", (long)3L, (long)segments.length);
        ICalledFunction f1 = (ICalledFunction)segments[0];
        ICalledFunction f2 = (ICalledFunction)segments[1];
        ICalledFunction f3 = (ICalledFunction)segments[2];
        Assert.assertEquals((String)"Test the parenthood", (Object)((ICalledFunction)NonNullUtils.checkNotNull((Object)f2.getParent())).getSymbol(), (Object)f1.getSymbol());
        Assert.assertEquals((String)"Children number:First parent", (long)1L, (long)f1.getChildren().size());
        Assert.assertEquals((String)"Children number:Second parent", (long)1L, (long)f2.getChildren().size());
        Assert.assertTrue((String)"Children number:Second parent", (boolean)f3.getChildren().isEmpty());
        Assert.assertTrue((String)"Children number:Child(leaf)", (boolean)((ICalledFunction)segments[2]).getChildren().isEmpty());
        Assert.assertEquals((String)"Parent's self time", (long)2L, (long)f1.getSelfTime());
        Assert.assertEquals((String)"Child's self time", (long)2L, (long)f2.getSelfTime());
        Assert.assertEquals((String)"The leaf's self time", (long)994L, (long)f3.getSelfTime());
        Assert.assertEquals((String)"Test first function's duration", (long)998L, (long)f1.getLength());
        Assert.assertEquals((String)"Test second function's duration", (long)996L, (long)f2.getLength());
        Assert.assertEquals((String)"Test third function's duration", (long)994L, (long)f3.getLength());
        Assert.assertEquals((String)"Depth:First parent", (long)0L, (long)f1.getDepth());
        Assert.assertEquals((String)"Depth:Second parent", (long)1L, (long)f2.getDepth());
        Assert.assertEquals((String)"Depth:Last child", (long)2L, (long)f3.getDepth());
        cga.dispose();
    }

    private static void buildPyramidCallStack(ITmfStateSystemBuilder fixture) {
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)0L);
        fixture.modifyAttribute(0L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(10L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(20L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(0L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(5L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(25L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(30L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(31L);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void PyramidTest() {
        ITmfStateSystemBuilder fixture = CallGraphAnalysisTest.createFixture();
        CallGraphAnalysisTest.buildPyramidCallStack(fixture);
        CGAnalysis cga = new CGAnalysis();
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        @NonNull ISegmentStore segmentStore = cga.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        Object[] segments = segmentStore.toArray();
        ICalledFunction f1 = (ICalledFunction)segments[0];
        Assert.assertEquals((String)"Number of segments Found", (long)1L, (long)segments.length);
        Assert.assertEquals((String)"Callees number", (long)0L, (long)f1.getChildren().size());
        Assert.assertEquals((String)"Function's self time", (long)10L, (long)f1.getSelfTime());
        Assert.assertEquals((String)"Compare the function's self time and total time", (long)f1.getLength(), (long)f1.getSelfTime());
        Assert.assertEquals((String)"Function's depth", (long)0L, (long)f1.getDepth());
        cga.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void multiFunctionRootsTest() {
        ITmfStateSystemBuilder fixture = CallGraphAnalysisTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)0L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(20L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(30L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(50L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(10L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)3L);
        fixture.modifyAttribute(30L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(40L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(51L);
        CGAnalysis cga = new CGAnalysis();
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        @NonNull ISegmentStore segmentStore = cga.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        Object[] segments = segmentStore.toArray();
        @NonNull List threads = cga.getRootFunctions();
        Assert.assertEquals((String)"Number of root functions", (long)2L, (long)threads.size());
        Assert.assertEquals((String)"Number of children: first root function", (long)1L, (long)((ICalledFunction)threads.get(0)).getChildren().size());
        Assert.assertEquals((String)"Number of children: first root function", (long)1L, (long)((ICalledFunction)threads.get(1)).getChildren().size());
        ICalledFunction firstChild = (ICalledFunction)((ICalledFunction)threads.get(0)).getChildren().get(0);
        ICalledFunction secondChild = (ICalledFunction)((ICalledFunction)threads.get(1)).getChildren().get(0);
        Assert.assertEquals((String)"Number of segments found", (long)4L, (long)segments.length);
        Assert.assertNotNull((Object)firstChild.getParent());
        Assert.assertNotNull((Object)secondChild.getParent());
        Assert.assertEquals((String)"Test of parenthood", (Object)((ICalledFunction)NonNullUtils.checkNotNull((Object)firstChild.getParent())).getSymbol(), (Object)((ICalledFunction)threads.get(0)).getSymbol());
        Assert.assertEquals((String)"Test of parenthood", (Object)((ICalledFunction)NonNullUtils.checkNotNull((Object)secondChild.getParent())).getSymbol(), (Object)((ICalledFunction)threads.get(1)).getSymbol());
        cga.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void LargeTest() {
        int quark;
        ITmfStateSystemBuilder fixture = CallGraphAnalysisTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int i = 0;
        while (i < 1000) {
            quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{Integer.toString(i)});
            TmfStateValue statev = TmfStateValue.newValueLong((long)i);
            fixture.pushAttribute(0L, (ITmfStateValue)statev, quark);
            ++i;
        }
        i = 0;
        while (i < 1000) {
            quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{Integer.toString(i)});
            fixture.popAttribute(10L, quark);
            ++i;
        }
        fixture.closeHistory(11L);
        CGAnalysis cga = new CGAnalysis();
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        @NonNull ISegmentStore segmentStore = cga.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        Object[] segments = segmentStore.toArray();
        Assert.assertEquals((String)"Number of segments found", (long)1000L, (long)segments.length);
        int i2 = 1;
        while (i2 < 1000) {
            Assert.assertEquals((String)"Test parenthood", (Object)((ICalledFunction)segments[i2 - 1]).getSymbol(), (Object)((ICalledFunction)NonNullUtils.checkNotNull((Object)((ICalledFunction)segments[i2]).getParent())).getSymbol());
            ++i2;
        }
        cga.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void EmptyStateSystemTest() {
        ITmfStateSystemBuilder fixture = CallGraphAnalysisTest.createFixture();
        fixture.closeHistory(1002L);
        CGAnalysis cga = new CGAnalysis();
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        @NonNull ISegmentStore segmentStore = cga.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        Object[] segments = segmentStore.toArray();
        Assert.assertEquals((String)"Number of root functions", (long)0L, (long)segments.length);
        cga.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void treeTest() {
        ITmfStateSystemBuilder fixture = CallGraphAnalysisTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)0L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(100L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(0L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(10L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(40L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(50L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(70L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(80L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(100L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        statev = TmfStateValue.newValueLong((long)3L);
        fixture.modifyAttribute(0L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(15L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(20L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(102L);
        CGAnalysis cga = new CGAnalysis();
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        @NonNull ISegmentStore segmentStore = cga.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        Object[] segments = segmentStore.toArray();
        Assert.assertEquals((String)"Number of segments found", (long)5L, (long)segments.length);
        @NonNull List rootFunctions = cga.getRootFunctions();
        Assert.assertEquals((String)"Test the number of root functions found", (long)1L, (long)rootFunctions.size());
        ICalledFunction rootFunction = (ICalledFunction)rootFunctions.get(0);
        Assert.assertEquals((String)"Children number:First parent", (long)3L, (long)rootFunction.getChildren().size());
        @NonNull List firstDepthFunctions = ((ICalledFunction)rootFunctions.get(0)).getChildren();
        ICalledFunction firstChild = (ICalledFunction)firstDepthFunctions.get(0);
        ICalledFunction secondChild = (ICalledFunction)firstDepthFunctions.get(1);
        ICalledFunction thirdChild = (ICalledFunction)firstDepthFunctions.get(2);
        Assert.assertEquals((String)"Test parenthood: First child", (Object)rootFunction.getSymbol(), (Object)((ICalledFunction)NonNullUtils.checkNotNull((Object)firstChild.getParent())).getSymbol());
        Assert.assertEquals((String)"Test parenthood: Second parent", (Object)rootFunction.getSymbol(), (Object)((ICalledFunction)NonNullUtils.checkNotNull((Object)secondChild.getParent())).getSymbol());
        Assert.assertEquals((String)"Test parenthood: Third parent", (Object)rootFunction.getSymbol(), (Object)((ICalledFunction)NonNullUtils.checkNotNull((Object)thirdChild.getParent())).getSymbol());
        Assert.assertEquals((String)"Children number: First child", (long)1L, (long)firstChild.getChildren().size());
        ICalledFunction leaf = (ICalledFunction)firstChild.getChildren().get(0);
        Assert.assertEquals((String)"Test parenthood: Third parent", (Object)firstChild.getSymbol(), (Object)((ICalledFunction)NonNullUtils.checkNotNull((Object)leaf.getParent())).getSymbol());
        Assert.assertTrue((String)"Children number:leaf", (boolean)leaf.getChildren().isEmpty());
        Assert.assertEquals((String)"Parent's self time", (long)30L, (long)rootFunction.getSelfTime());
        Assert.assertEquals((String)"First child's self time", (long)25L, (long)firstChild.getSelfTime());
        Assert.assertEquals((String)"Second child's self time", (long)20L, (long)secondChild.getSelfTime());
        Assert.assertEquals((String)"Third child's self time", (long)20L, (long)thirdChild.getSelfTime());
        Assert.assertEquals((String)"Leaf's self time", (long)5L, (long)leaf.getSelfTime());
        Assert.assertEquals((String)"Test first function's duration", (long)100L, (long)rootFunction.getLength());
        Assert.assertEquals((String)"Test first child's duration", (long)30L, (long)firstChild.getLength());
        Assert.assertEquals((String)"Test second child's duration", (long)20L, (long)secondChild.getLength());
        Assert.assertEquals((String)"Test third child's duration", (long)20L, (long)thirdChild.getLength());
        Assert.assertEquals((String)"Test leaf's duration", (long)5L, (long)leaf.getLength());
        Assert.assertEquals((String)"Depth: Parent", (long)0L, (long)rootFunction.getDepth());
        Assert.assertEquals((String)"Depth: First child", (long)1L, (long)firstChild.getDepth());
        Assert.assertEquals((String)"Depth: Second child", (long)1L, (long)secondChild.getDepth());
        Assert.assertEquals((String)"Depth: Third child", (long)1L, (long)thirdChild.getDepth());
        Assert.assertEquals((String)"Depth: Leaf", (long)2L, (long)leaf.getDepth());
        Assert.assertEquals((String)"Test the address of two functions", (Object)firstChild.getSymbol(), (Object)thirdChild.getSymbol());
        @NonNull Collection flameGraph = cga.getFlameGraph();
        Assert.assertNotNull((String)"Test Flamegraph", (Object)flameGraph);
        Assert.assertFalse((boolean)flameGraph.isEmpty());
        ThreadNode flamegraphRoot = (ThreadNode)flameGraph.iterator().next();
        Assert.assertNotNull((String)"Test Flamegraph root", (Object)flamegraphRoot);
        @NonNull List threadGraph = cga.getThreadNodes();
        Assert.assertNotNull((String)"Test ThreadNodes", (Object)threadGraph);
        Assert.assertFalse((boolean)threadGraph.isEmpty());
        ThreadNode threadgraphRoot = (ThreadNode)threadGraph.iterator().next();
        this.localAssertEquals("Test Flamegraph root", (AggregatedCalledFunction)threadgraphRoot, (AggregatedCalledFunction)flamegraphRoot);
        cga.dispose();
    }

    private void localAssertEquals(String message, AggregatedCalledFunction aggregatedCalledFunction, AggregatedCalledFunction actualElem) {
        if (Objects.equals(aggregatedCalledFunction, actualElem)) {
            return;
        }
        Assert.assertNotNull((String)message, (Object)aggregatedCalledFunction);
        Assert.assertNotNull((String)message, (Object)actualElem);
        Assert.assertEquals((String)message, (long)aggregatedCalledFunction.getDepth(), (long)actualElem.getDepth());
        Assert.assertEquals((String)message, (long)aggregatedCalledFunction.getDuration(), (long)actualElem.getDuration());
        Assert.assertEquals((String)message, (long)aggregatedCalledFunction.getMaxDepth(), (long)actualElem.getMaxDepth());
        Assert.assertEquals((String)message, (long)aggregatedCalledFunction.getMaxDepth(), (long)actualElem.getMaxDepth());
        Assert.assertEquals((String)message, (long)aggregatedCalledFunction.getSelfTime(), (long)actualElem.getSelfTime());
        this.localAssertEquals(message, aggregatedCalledFunction.getChildren(), actualElem.getChildren());
    }

    private void localAssertEquals(String message, @NonNull Collection<@NonNull AggregatedCalledFunction> expected, @NonNull Collection<@NonNull AggregatedCalledFunction> actual) {
        Iterator<@NonNull AggregatedCalledFunction> expectedIter = expected.iterator();
        for (AggregatedCalledFunction actualElem : actual) {
            this.localAssertEquals(message, expectedIter.next(), actualElem);
        }
    }

    private class CGAnalysis
    extends CallGraphAnalysis {
        private CGAnalysis() {
        }

        protected boolean iterateOverStateSystem(ITmfStateSystem ss, String[] threadsPattern, String[] processesPattern, String[] callStackPath, IProgressMonitor monitor) {
            return super.iterateOverStateSystem(ss, threadsPattern, processesPattern, callStackPath, monitor);
        }

        public @NonNull Iterable<@NonNull ISegmentAspect> getSegmentAspects() {
            return Collections.EMPTY_LIST;
        }
    }
}

