/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.flamegraph;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ThreadNode;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.junit.Assert;
import org.junit.Test;

public class AggregationTreeTest {
    private static final @NonNull String PROCESS_PATH = "Processes";
    private static final @NonNull String THREAD_PATH = "Thread";
    private static final @NonNull String CALLSTACK_PATH = "CallStack";
    private static final String QUARK_0 = "0";
    private static final String QUARK_1 = "1";
    private static final String QUARK_2 = "2";
    private static final String QUARK_3 = "3";
    private static final Integer SMALL_AMOUNT_OF_SEGMENT = 3;
    private static final int LARGE_AMOUNT_OF_SEGMENTS = 1000;
    private static final String @NonNull [] CSP = new String[]{"CallStack"};
    private static final String @NonNull [] PP = new String[]{"Processes"};
    private static final String @NonNull [] TP = new String[]{"Thread"};
    private CGAnalysis fCga;

    private static @NonNull ITmfStateSystemBuilder createFixture() {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)"Test", (long)0L);
        return StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
    }

    @Test
    public void emptyStateSystemTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        fixture.closeHistory(1002L);
        CGAnalysis cga = new CGAnalysis();
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Assert.assertEquals((String)"Number of threads found", (long)0L, (long)threads.size());
        cga.dispose();
    }

    @Test
    public void cascadeTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        long start = 1L;
        long end = 1001L;
        int threadQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH});
        int parentQuark = fixture.getQuarkRelativeAndAdd(threadQuark, new String[]{CALLSTACK_PATH});
        fixture.updateOngoingState((ITmfStateValue)TmfStateValue.newValueLong((long)100L), threadQuark);
        int i = 1;
        while (i <= SMALL_AMOUNT_OF_SEGMENT) {
            int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{Integer.toString(i)});
            TmfStateValue statev = TmfStateValue.newValueLong((long)i);
            fixture.modifyAttribute(start, (ITmfStateValue)TmfStateValue.nullValue(), quark);
            fixture.modifyAttribute(start + (long)i, (ITmfStateValue)statev, quark);
            fixture.modifyAttribute(end - (long)i, (ITmfStateValue)TmfStateValue.nullValue(), quark);
            ++i;
        }
        fixture.closeHistory(1002L);
        CGAnalysis cga = new CGAnalysis();
        this.setCga(cga);
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        @NonNull List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Assert.assertEquals((String)"Number of thread nodes Found", (long)1L, (long)threads.size());
        Assert.assertEquals((String)"Number of root functions ", (long)1L, (long)((ThreadNode)threads.get(0)).getChildren().size());
        Assert.assertEquals((String)"Thread id", (long)100L, (long)((ThreadNode)threads.get(0)).getId());
        Assert.assertEquals((String)"Thread name", (Object)THREAD_PATH, (Object)((ThreadNode)threads.get(0)).getSymbol());
        Object[] children = ((ThreadNode)threads.get(0)).getChildren().toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Assert.assertEquals((String)"Children number: First function", (long)1L, (long)firstFunction.getChildren().size());
        Object @NonNull [] firstFunctionChildren = firstFunction.getChildren().toArray();
        AggregatedCalledFunction secondFunction = (AggregatedCalledFunction)firstFunctionChildren[0];
        Assert.assertEquals((String)"Children number: Second function", (long)1L, (long)secondFunction.getChildren().size());
        Object @NonNull [] secondFunctionChildren = secondFunction.getChildren().toArray();
        AggregatedCalledFunction thirdFunction = (AggregatedCalledFunction)secondFunctionChildren[0];
        Assert.assertEquals((String)"Children number: Third function", (long)0L, (long)thirdFunction.getChildren().size());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)secondFunction.getParent())).getSymbol(), (Object)firstFunction.getSymbol());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)thirdFunction.getParent())).getSymbol(), (Object)secondFunction.getSymbol());
        Assert.assertEquals((String)"Test first function's duration", (long)998L, (long)firstFunction.getDuration());
        Assert.assertEquals((String)"Test second function's duration", (long)996L, (long)secondFunction.getDuration());
        Assert.assertEquals((String)"Test third function's duration", (long)994L, (long)thirdFunction.getDuration());
        Assert.assertEquals((String)"Test first function's self time", (long)2L, (long)firstFunction.getSelfTime());
        Assert.assertEquals((String)"Test second function's self time", (long)2L, (long)secondFunction.getSelfTime());
        Assert.assertEquals((String)"Test third function's self time", (long)994L, (long)thirdFunction.getSelfTime());
        Assert.assertEquals((String)"Test first function's depth", (long)0L, (long)firstFunction.getDepth());
        Assert.assertEquals((String)"Test second function's depth", (long)1L, (long)secondFunction.getDepth());
        Assert.assertEquals((String)"Test third function's depth", (long)2L, (long)thirdFunction.getDepth());
        Assert.assertEquals((String)"Test first function's nombre of calls", (long)1L, (long)firstFunction.getNbCalls());
        Assert.assertEquals((String)"Test second function's nombre of calls", (long)1L, (long)secondFunction.getNbCalls());
        Assert.assertEquals((String)"Test third function's nombre of calls", (long)1L, (long)thirdFunction.getNbCalls());
        cga.dispose();
    }

    @Test
    public void treeTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        int threadQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH});
        int parentQuark = fixture.getQuarkRelativeAndAdd(threadQuark, new String[]{CALLSTACK_PATH});
        fixture.updateOngoingState((ITmfStateValue)TmfStateValue.newValueDouble((double)0.001), threadQuark);
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)0L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(100L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(50L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(90L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(30L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(102L);
        CGAnalysis cga = new CGAnalysis();
        this.setCga(cga);
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Assert.assertEquals((String)"Number of thread nodes Found", (long)1L, (long)threads.size());
        Assert.assertEquals((String)"Thread id", (long)-1L, (long)((ThreadNode)threads.get(0)).getId());
        Assert.assertEquals((String)"Thread name", (Object)THREAD_PATH, (Object)((ThreadNode)threads.get(0)).getSymbol());
        Object[] children = ((ThreadNode)threads.get(0)).getChildren().toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Assert.assertEquals((String)"Children number: First function", (long)1L, (long)firstFunction.getChildren().size());
        Object[] firstFunctionChildren = firstFunction.getChildren().toArray();
        AggregatedCalledFunction secondFunction = (AggregatedCalledFunction)firstFunctionChildren[0];
        Assert.assertEquals((String)"Children number: Second function", (long)1L, (long)secondFunction.getChildren().size());
        Object[] secondFunctionChildren = secondFunction.getChildren().toArray();
        AggregatedCalledFunction thirdFunction = (AggregatedCalledFunction)secondFunctionChildren[0];
        Assert.assertEquals((String)"Children number: Third function", (long)0L, (long)thirdFunction.getChildren().size());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)secondFunction.getParent())).getSymbol(), (Object)firstFunction.getSymbol());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)thirdFunction.getParent())).getSymbol(), (Object)secondFunction.getSymbol());
        Assert.assertEquals((String)"Test first function's duration", (long)100L, (long)firstFunction.getDuration());
        Assert.assertEquals((String)"Test second function's duration", (long)80L, (long)secondFunction.getDuration());
        Assert.assertEquals((String)"Test third function's duration", (long)30L, (long)thirdFunction.getDuration());
        Assert.assertEquals((String)"Test first function's self time", (long)20L, (long)firstFunction.getSelfTime());
        Assert.assertEquals((String)"Test second function's self time", (long)50L, (long)secondFunction.getSelfTime());
        Assert.assertEquals((String)"Test third function's self time", (long)30L, (long)thirdFunction.getSelfTime());
        Assert.assertEquals((String)"Test first function's depth", (long)0L, (long)firstFunction.getDepth());
        Assert.assertEquals((String)"Test second function's depth", (long)1L, (long)secondFunction.getDepth());
        Assert.assertEquals((String)"Test third function's depth", (long)2L, (long)thirdFunction.getDepth());
        Assert.assertEquals((String)"Test first function's number of calls", (long)1L, (long)firstFunction.getNbCalls());
        Assert.assertEquals((String)"Test second function's number of calls", (long)2L, (long)secondFunction.getNbCalls());
        Assert.assertEquals((String)"Test third function's number of calls", (long)1L, (long)thirdFunction.getNbCalls());
        cga.dispose();
    }

    @Test
    public void mergeFirstLevelCalleesTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        int threadQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, "123"});
        int parentQuark = fixture.getQuarkRelativeAndAdd(threadQuark, new String[]{CALLSTACK_PATH});
        fixture.updateOngoingState((ITmfStateValue)TmfStateValue.newValueDouble((double)0.001), threadQuark);
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)0L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(100L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(50L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(90L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(30L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)3L);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(80L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(102L);
        CGAnalysis cga = new CGAnalysis();
        String[] tp = new String[]{"123"};
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, tp, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        this.setCga(cga);
        List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Assert.assertEquals((String)"Number of thread nodes Found", (long)1L, (long)threads.size());
        Assert.assertEquals((String)"Thread id", (long)123L, (long)((ThreadNode)threads.get(0)).getId());
        Assert.assertEquals((String)"Thread name", (Object)"123", (Object)((ThreadNode)threads.get(0)).getSymbol());
        Assert.assertEquals((String)"Number of root functions ", (long)1L, (long)((ThreadNode)threads.get(0)).getChildren().size());
        Object[] children = ((ThreadNode)threads.get(0)).getChildren().toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Assert.assertEquals((String)"Children number: First function", (long)1L, (long)firstFunction.getChildren().size());
        Object[] firstFunctionChildren = firstFunction.getChildren().toArray();
        AggregatedCalledFunction secondFunction = (AggregatedCalledFunction)firstFunctionChildren[0];
        Assert.assertEquals((String)"Children number: Second function", (long)2L, (long)secondFunction.getChildren().size());
        Object[] secondFunctionChildren = secondFunction.getChildren().toArray();
        AggregatedCalledFunction leaf1 = (AggregatedCalledFunction)secondFunctionChildren[0];
        AggregatedCalledFunction leaf2 = (AggregatedCalledFunction)secondFunctionChildren[1];
        Assert.assertEquals((String)"Children number: First leaf function", (long)0L, (long)leaf1.getChildren().size());
        Assert.assertEquals((String)"Children number: Second leaf function", (long)0L, (long)leaf2.getChildren().size());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)secondFunction.getParent())).getSymbol(), (Object)firstFunction.getSymbol());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)leaf1.getParent())).getSymbol(), (Object)secondFunction.getSymbol());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)leaf2.getParent())).getSymbol(), (Object)secondFunction.getSymbol());
        Assert.assertEquals((String)"Test first function's duration", (long)100L, (long)firstFunction.getDuration());
        Assert.assertEquals((String)"Test second function's duration", (long)80L, (long)secondFunction.getDuration());
        Assert.assertEquals((String)"Test first leaf's duration", (long)30L, (long)leaf1.getDuration());
        Assert.assertEquals((String)"Test second leaf's duration", (long)20L, (long)leaf2.getDuration());
        Assert.assertEquals((String)"Test first function's self time", (long)20L, (long)firstFunction.getSelfTime());
        Assert.assertEquals((String)"Test second function's self time", (long)30L, (long)secondFunction.getSelfTime());
        Assert.assertEquals((String)"Test first leaf's self time", (long)30L, (long)leaf1.getSelfTime());
        Assert.assertEquals((String)"Test second leaf's self time", (long)20L, (long)leaf2.getSelfTime());
        Assert.assertEquals((String)"Test first function's depth", (long)0L, (long)firstFunction.getDepth());
        Assert.assertEquals((String)"Test second function's depth", (long)1L, (long)secondFunction.getDepth());
        Assert.assertEquals((String)"Test first leaf's depth", (long)2L, (long)leaf1.getDepth());
        Assert.assertEquals((String)"Test second leaf's depth", (long)2L, (long)leaf2.getDepth());
        Assert.assertEquals((String)"Test first function's number of calls", (long)1L, (long)firstFunction.getNbCalls());
        Assert.assertEquals((String)"Test second function's number of calls", (long)2L, (long)secondFunction.getNbCalls());
        Assert.assertEquals((String)"Test first leaf's number of calls", (long)1L, (long)leaf1.getNbCalls());
        Assert.assertEquals((String)"Test second leaf's number of calls", (long)1L, (long)leaf2.getNbCalls());
        cga.dispose();
    }

    private static void buildCallStack(ITmfStateSystemBuilder fixture) {
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)0L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(100L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(50L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(100L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(10L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)3L);
        fixture.modifyAttribute(20L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(30L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(90L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_3});
        statev = TmfStateValue.newValueLong((long)4L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(10L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(60L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(80L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(102L);
    }

    @Test
    public void mergeSecondLevelCalleesTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        AggregationTreeTest.buildCallStack(fixture);
        CGAnalysis cga = new CGAnalysis();
        this.setCga(cga);
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Assert.assertEquals((String)"Number of thread nodes Found", (long)1L, (long)threads.size());
        Assert.assertEquals((String)"Thread id", (long)-1L, (long)((ThreadNode)threads.get(0)).getId());
        Assert.assertEquals((String)"Thread name", (Object)THREAD_PATH, (Object)((ThreadNode)threads.get(0)).getSymbol());
        Assert.assertEquals((String)"Number of root functions ", (long)1L, (long)((ThreadNode)threads.get(0)).getChildren().size());
        Object[] children = ((ThreadNode)threads.get(0)).getChildren().toArray();
        AggregatedCalledFunction main = (AggregatedCalledFunction)children[0];
        Assert.assertEquals((String)"Children number: main", (long)1L, (long)main.getChildren().size());
        Object[] mainChildren = main.getChildren().toArray();
        AggregatedCalledFunction function1 = (AggregatedCalledFunction)mainChildren[0];
        Assert.assertEquals((String)"Children number: first function", (long)2L, (long)function1.getChildren().size());
        Object[] firstFunctionChildren = function1.getChildren().toArray();
        AggregatedCalledFunction function2 = (AggregatedCalledFunction)firstFunctionChildren[0];
        AggregatedCalledFunction function3 = (AggregatedCalledFunction)firstFunctionChildren[1];
        Assert.assertEquals((String)"Children number: First child", (long)1L, (long)function2.getChildren().size());
        Assert.assertEquals((String)"Children number: Second child", (long)0L, (long)function3.getChildren().size());
        Object[] firstChildCallee = function2.getChildren().toArray();
        AggregatedCalledFunction function4 = (AggregatedCalledFunction)firstChildCallee[0];
        Assert.assertEquals((String)"Children number: leaf function", (long)0L, (long)function4.getChildren().size());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)function1.getParent())).getSymbol(), (Object)main.getSymbol());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)function2.getParent())).getSymbol(), (Object)function1.getSymbol());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)function3.getParent())).getSymbol(), (Object)function1.getSymbol());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)function4.getParent())).getSymbol(), (Object)function2.getSymbol());
        Assert.assertEquals((String)"Test main's duration", (long)100L, (long)main.getDuration());
        Assert.assertEquals((String)"Test first function's duration", (long)90L, (long)function1.getDuration());
        Assert.assertEquals((String)"Test first child's duration", (long)40L, (long)function2.getDuration());
        Assert.assertEquals((String)"Test second child's duration", (long)10L, (long)function3.getDuration());
        Assert.assertEquals((String)"Test leaf's duration", (long)30L, (long)function4.getDuration());
        Assert.assertEquals((String)"Test main's self time", (long)10L, (long)main.getSelfTime());
        Assert.assertEquals((String)"Test first function's self time", (long)40L, (long)function1.getSelfTime());
        Assert.assertEquals((String)"Test first child's self time", (long)10L, (long)function2.getSelfTime());
        Assert.assertEquals((String)"Test second child's self time", (long)10L, (long)function3.getSelfTime());
        Assert.assertEquals((String)"Test leaf's self time", (long)30L, (long)function4.getSelfTime());
        Assert.assertEquals((String)"Test main function's depth", (long)0L, (long)main.getDepth());
        Assert.assertEquals((String)"Test first function's depth", (long)1L, (long)function1.getDepth());
        Assert.assertEquals((String)"Test first child's depth", (long)2L, (long)function2.getDepth());
        Assert.assertEquals((String)"Test second child's depth", (long)2L, (long)function3.getDepth());
        Assert.assertEquals((String)"Test leaf's depth", (long)3L, (long)function4.getDepth());
        Assert.assertEquals((String)"Test main's number of calls", (long)1L, (long)main.getNbCalls());
        Assert.assertEquals((String)"Test first function's number of calls", (long)2L, (long)function1.getNbCalls());
        Assert.assertEquals((String)"Test first child's number of calls", (long)2L, (long)function2.getNbCalls());
        Assert.assertEquals((String)"Test second child's number of calls", (long)1L, (long)function3.getNbCalls());
        Assert.assertEquals((String)"Test leaf's number of calls", (long)2L, (long)function4.getNbCalls());
        cga.dispose();
    }

    @Test
    public void largeTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int i = 0;
        while (i < 1000) {
            TmfStateValue statev = TmfStateValue.newValueLong((long)i);
            fixture.pushAttribute(0L, (ITmfStateValue)statev, parentQuark);
            ++i;
        }
        i = 0;
        while (i < 1000) {
            fixture.popAttribute(10L, parentQuark);
            ++i;
        }
        fixture.closeHistory(11L);
        CGAnalysis cga = new CGAnalysis();
        this.setCga(cga);
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Assert.assertEquals((String)"Thread id", (long)-1L, (long)((ThreadNode)threads.get(0)).getId());
        Assert.assertEquals((String)"Thread name", (Object)THREAD_PATH, (Object)((ThreadNode)threads.get(0)).getSymbol());
        Object[] children = ((ThreadNode)threads.get(0)).getChildren().toArray();
        AggregatedCalledFunction parent = (AggregatedCalledFunction)children[0];
        int i2 = 1;
        while (i2 < 1000) {
            children = parent.getChildren().toArray();
            AggregatedCalledFunction child = (AggregatedCalledFunction)children[0];
            Assert.assertEquals((String)"Test parenthood", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)child.getParent())).getSymbol(), (Object)NonNullUtils.checkNotNull((Object)parent.getSymbol()));
            parent = child;
            ++i2;
        }
        cga.dispose();
    }

    @Test
    public void multiFunctionRootsTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(20L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(30L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(50L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(10L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)3L);
        fixture.modifyAttribute(30L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(40L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(51L);
        CGAnalysis cga = new CGAnalysis();
        this.setCga(cga);
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Assert.assertEquals((String)"Number of thread nodes Found", (long)1L, (long)threads.size());
        Assert.assertEquals((String)"Thread id", (long)-1L, (long)((ThreadNode)threads.get(0)).getId());
        Assert.assertEquals((String)"Thread name", (Object)THREAD_PATH, (Object)((ThreadNode)threads.get(0)).getSymbol());
        Assert.assertEquals((String)"Number of root functions ", (long)1L, (long)((ThreadNode)threads.get(0)).getChildren().size());
        Object[] children = ((ThreadNode)threads.get(0)).getChildren().toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Assert.assertEquals((String)"Children number: First function", (long)2L, (long)firstFunction.getChildren().size());
        Object[] firstFunctionChildren = firstFunction.getChildren().toArray();
        AggregatedCalledFunction function2 = (AggregatedCalledFunction)firstFunctionChildren[0];
        AggregatedCalledFunction function3 = (AggregatedCalledFunction)firstFunctionChildren[1];
        Assert.assertEquals((String)"Children number: Second function", (long)0L, (long)function2.getChildren().size());
        Assert.assertEquals((String)"Children number: Third function", (long)0L, (long)function3.getChildren().size());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)function2.getParent())).getSymbol(), (Object)firstFunction.getSymbol());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)function3.getParent())).getSymbol(), (Object)firstFunction.getSymbol());
        Assert.assertEquals((String)"Test first function's duration", (long)40L, (long)firstFunction.getDuration());
        Assert.assertEquals((String)"Test second function's duration", (long)10L, (long)function2.getDuration());
        Assert.assertEquals((String)"Test third function's duration", (long)10L, (long)function3.getDuration());
        Assert.assertEquals((String)"Test first function's self time", (long)20L, (long)firstFunction.getSelfTime());
        Assert.assertEquals((String)"Test second function's self time", (long)10L, (long)function2.getSelfTime());
        Assert.assertEquals((String)"Test third function's self time", (long)10L, (long)function2.getSelfTime());
        Assert.assertEquals((String)"Test first function's depth", (long)0L, (long)firstFunction.getDepth());
        Assert.assertEquals((String)"Test second function's depth", (long)1L, (long)function2.getDepth());
        Assert.assertEquals((String)"Test third function's depth", (long)1L, (long)function3.getDepth());
        Assert.assertEquals((String)"Test first function's number of calls", (long)2L, (long)firstFunction.getNbCalls());
        Assert.assertEquals((String)"Test second function's number of calls", (long)1L, (long)function2.getNbCalls());
        Assert.assertEquals((String)"Test third function's number of calls", (long)1L, (long)function3.getNbCalls());
        cga.dispose();
    }

    @Test
    public void multiFunctionRootsSecondTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{PROCESS_PATH, THREAD_PATH, CALLSTACK_PATH});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        TmfStateValue statev = TmfStateValue.newValueLong((long)0L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(20L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        statev = TmfStateValue.newValueLong((long)1L);
        fixture.modifyAttribute(30L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(50L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = TmfStateValue.newValueLong((long)2L);
        fixture.modifyAttribute(0L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(10L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.modifyAttribute(30L, (ITmfStateValue)statev, quark);
        fixture.modifyAttribute(40L, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        fixture.closeHistory(51L);
        CGAnalysis cga = new CGAnalysis();
        this.setCga(cga);
        Assert.assertTrue((boolean)cga.iterateOverStateSystem((ITmfStateSystem)fixture, TP, PP, CSP, (IProgressMonitor)new NullProgressMonitor()));
        List threads = cga.getThreadNodes();
        Assert.assertNotNull((Object)threads);
        Assert.assertEquals((String)"Number of thread nodes Found", (long)1L, (long)threads.size());
        Assert.assertEquals((String)"Thread id", (long)-1L, (long)((ThreadNode)threads.get(0)).getId());
        Assert.assertEquals((String)"Thread name", (Object)THREAD_PATH, (Object)((ThreadNode)threads.get(0)).getSymbol());
        Assert.assertEquals((String)"Number of root functions ", (long)2L, (long)((ThreadNode)threads.get(0)).getChildren().size());
        Object[] children = ((ThreadNode)threads.get(0)).getChildren().toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        AggregatedCalledFunction secondFunction = (AggregatedCalledFunction)children[1];
        Assert.assertEquals((String)"Children number: First function", (long)1L, (long)firstFunction.getChildren().size());
        Assert.assertEquals((String)"Children number: Second function", (long)1L, (long)secondFunction.getChildren().size());
        Object[] firstFunctionChildren = firstFunction.getChildren().toArray();
        Object[] secondFunctionChildren = secondFunction.getChildren().toArray();
        AggregatedCalledFunction function3 = (AggregatedCalledFunction)firstFunctionChildren[0];
        AggregatedCalledFunction function4 = (AggregatedCalledFunction)secondFunctionChildren[0];
        Assert.assertEquals((String)"Children number: third function", (long)0L, (long)function3.getChildren().size());
        Assert.assertEquals((String)"Children number: fourth function", (long)0L, (long)function4.getChildren().size());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)function3.getParent())).getSymbol(), (Object)firstFunction.getSymbol());
        Assert.assertEquals((String)"Test parenthood ", (Object)((AggregatedCalledFunction)NonNullUtils.checkNotNull((Object)function4.getParent())).getSymbol(), (Object)secondFunction.getSymbol());
        Assert.assertEquals((String)"Test second function's duration", (long)20L, (long)firstFunction.getDuration());
        Assert.assertEquals((String)"Test second function's duration", (long)20L, (long)secondFunction.getDuration());
        Assert.assertEquals((String)"Test first leaf's duration", (long)10L, (long)function3.getDuration());
        Assert.assertEquals((String)"Test second leaf's duration", (long)10L, (long)function4.getDuration());
        Assert.assertEquals((String)"Test first function's self time", (long)10L, (long)firstFunction.getSelfTime());
        Assert.assertEquals((String)"Test second function's duration", (long)10L, (long)secondFunction.getSelfTime());
        Assert.assertEquals((String)"Test second function's self time", (long)10L, (long)function3.getSelfTime());
        Assert.assertEquals((String)"Test second function's self time", (long)10L, (long)function4.getSelfTime());
        Assert.assertEquals((String)"Test first function's depth", (long)0L, (long)firstFunction.getDepth());
        Assert.assertEquals((String)"Test first function's depth", (long)0L, (long)secondFunction.getDepth());
        Assert.assertEquals((String)"Test third function's depth", (long)1L, (long)function3.getDepth());
        Assert.assertEquals((String)"Test third function's depth", (long)1L, (long)function4.getDepth());
        Assert.assertEquals((String)"Test first function's number of calls", (long)1L, (long)firstFunction.getNbCalls());
        Assert.assertEquals((String)"Test first function's number of calls", (long)1L, (long)secondFunction.getNbCalls());
        Assert.assertEquals((String)"Test third function's number of calls", (long)1L, (long)function3.getNbCalls());
        Assert.assertEquals((String)"Test third function's number of calls", (long)1L, (long)function4.getNbCalls());
        cga.dispose();
    }

    protected CGAnalysis getCga() {
        return this.fCga;
    }

    protected void setCga(CGAnalysis cga) {
        this.fCga = cga;
    }

    private class CGAnalysis
    extends CallGraphAnalysis {
        private CGAnalysis() {
        }

        protected boolean iterateOverStateSystem(ITmfStateSystem ss, String[] threadsPattern, String[] processesPattern, String[] callStackPath, IProgressMonitor monitor) {
            return super.iterateOverStateSystem(ss, threadsPattern, processesPattern, callStackPath, monitor);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Iterable<@NonNull ISegmentAspect> getSegmentAspects() {
            @NonNull ImmutableList aspectList = ImmutableList.of((Object)new HelloAspect());
            Assert.assertNotNull((Object)aspectList);
            return aspectList;
        }

        private final class HelloAspect
        implements ISegmentAspect {
            private HelloAspect() {
            }

            public @NonNull String getName() {
                return "aspect name";
            }

            public @NonNull String getHelpText() {
                return "aspect help";
            }

            public @Nullable Comparator<?> getComparator() {
                return null;
            }

            public @Nullable Object resolve(@NonNull ISegment segment) {
                return "Hello";
            }
        }
    }
}

