/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.swtbot.tests.callgraph;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.tests.flamegraph.AggregationTreeTest;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.ISegmentStoreDensityViewerDataListener;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.internal.analysis.timing.ui.callgraph.CallGraphDensityView;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.swtchart.ISeries;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class CallGraphDensityViewTest
extends AggregationTreeTest {
    private static final String CALLGRAPHDENSITY_ID = CallGraphDensityView.ID;
    private final @NonNull ISegmentStoreDensityViewerDataListener fSyncListener = new ISegmentStoreDensityViewerDataListener(){

        public void chartUpdated() {
            CallGraphDensityViewTest.this.fLatch.countDown();
        }
    };
    private SWTWorkbenchBot fBot;
    private SWTBotView fView;
    private CallGraphDensityView fFuncDensityView;
    private SWTBotTable fTableBot;
    private AbstractSegmentStoreDensityViewer fDensityViewer;
    private AbstractSegmentStoreTableViewer fTableViewer;
    private CountDownLatch fLatch;
    private static final Logger fLogger = Logger.getRootLogger();

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)bot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void afterClass() {
        fLogger.removeAllAppenders();
    }

    @Before
    public void before() {
        this.fBot = new SWTWorkbenchBot();
        SWTBotUtils.openView((String)CALLGRAPHDENSITY_ID);
        SWTBotView view = this.fBot.viewById(CALLGRAPHDENSITY_ID);
        Assert.assertNotNull((Object)view);
        this.fView = view;
        CallGraphDensityView funcDensityView = (CallGraphDensityView)UIThreadRunnable.syncExec(() -> {
            IViewPart viewRef = this.fView.getViewReference().getView(true);
            return viewRef instanceof CallGraphDensityView ? (CallGraphDensityView)viewRef : null;
        });
        Assert.assertNotNull((Object)funcDensityView);
        this.fTableBot = this.fView.bot().table();
        Assert.assertNotNull((Object)this.fTableBot);
        this.fDensityViewer = funcDensityView.getDensityViewer();
        Assert.assertNotNull((Object)this.fDensityViewer);
        this.fLatch = new CountDownLatch(1);
        this.fDensityViewer.removeDataListener(this.fSyncListener);
        this.fDensityViewer.addDataListener(this.fSyncListener);
        this.fTableViewer = funcDensityView.getTableViewer();
        Assert.assertNotNull((Object)this.fTableViewer);
        SWTBotUtils.maximize((IWorkbenchPart)funcDensityView);
        this.fFuncDensityView = funcDensityView;
        this.fDensityViewer.setNbPoints(100);
    }

    @After
    public void after() {
        CallGraphDensityView funcDensityView = this.fFuncDensityView;
        Assert.assertNotNull((Object)funcDensityView);
        SWTBotUtils.maximize((IWorkbenchPart)funcDensityView);
        this.setCga(null);
    }

    public void emptyStateSystemTest() {
        super.emptyStateSystemTest();
        this.loadData();
        Assert.assertEquals((long)0L, (long)this.fTableBot.rowCount());
        ISeries series = this.getSeries();
        Assert.assertNotNull((Object)series);
    }

    public void cascadeTest() {
        super.cascadeTest();
        this.loadData();
        this.waitForTable(3);
        Assert.assertEquals((long)3L, (long)this.fTableBot.rowCount());
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 4.0};
        this.waitForSeries(expected);
        Assert.assertArrayEquals((double[])expected, (double[])this.getSeries().getYSeries(), (double)0.1);
    }

    public void mergeFirstLevelCalleesTest() {
        super.mergeFirstLevelCalleesTest();
        this.loadData();
        this.waitForTable(5);
        Assert.assertEquals((long)5L, (long)this.fTableBot.rowCount());
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0};
        this.waitForSeries(expected);
        Assert.assertArrayEquals((double[])expected, (double[])this.getSeries().getYSeries(), (double)0.1);
    }

    public void multiFunctionRootsSecondTest() {
        super.multiFunctionRootsSecondTest();
        this.loadData();
        this.waitForTable(4);
        Assert.assertEquals((long)4L, (long)this.fTableBot.rowCount());
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 1.0, 1.0, 1.0, 1.0};
        this.waitForSeries(expected);
        Assert.assertArrayEquals((double[])expected, (double[])this.getSeries().getYSeries(), (double)0.1);
    }

    public void mergeSecondLevelCalleesTest() {
        super.mergeSecondLevelCalleesTest();
        this.loadData();
        this.waitForTable(8);
        Assert.assertEquals((long)8L, (long)this.fTableBot.rowCount());
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 4.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0};
        this.waitForSeries(expected);
        Assert.assertArrayEquals((double[])expected, (double[])this.getSeries().getYSeries(), (double)0.1);
    }

    public void multiFunctionRootsTest() {
        super.multiFunctionRootsTest();
        this.loadData();
        this.waitForTable(4);
        Assert.assertEquals((long)4L, (long)this.fTableBot.rowCount());
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 1.0, 1.0, 1.0, 1.0};
        this.waitForSeries(expected);
        Assert.assertArrayEquals((double[])expected, (double[])this.getSeries().getYSeries(), (double)0.1);
    }

    public void treeTest() {
        super.treeTest();
        this.loadData();
        this.waitForTable(4);
        Assert.assertEquals((long)4L, (long)this.fTableBot.rowCount());
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0};
        this.waitForSeries(expected);
        Assert.assertArrayEquals((double[])expected, (double[])this.getSeries().getYSeries(), (double)0.1);
    }

    public void largeTest() {
        super.largeTest();
        this.loadData();
        this.waitForTable(1000);
        Assert.assertEquals((long)1000L, (long)this.fTableBot.rowCount());
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1001.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.waitForSeries(expected);
        Assert.assertArrayEquals((double[])expected, (double[])this.getSeries().getYSeries(), (double)0.1);
    }

    private ISeries getSeries() {
        AbstractSegmentStoreDensityViewer densityViewer = this.fDensityViewer;
        Assert.assertNotNull((Object)densityViewer);
        ISeries[] serieses = densityViewer.getControl().getSeriesSet().getSeries();
        Assert.assertNotNull((Object)serieses);
        Assert.assertTrue((serieses.length > 0 ? 1 : 0) != 0);
        ISeries series = serieses[0];
        Assert.assertNotNull((Object)series);
        return series;
    }

    private void loadData() {
        AggregationTreeTest.CGAnalysis cga = this.getCga();
        UIThreadRunnable.syncExec(() -> this.lambda$1((ISegmentStoreProvider)cga));
        if (cga != null) {
            try {
                Assert.assertTrue((boolean)this.fLatch.await(20L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private void waitForSeries(double[] expected) {
        SWTBotUtils.waitUntil(arg -> {
            UIThreadRunnable.syncExec(() -> {
                this.fDensityViewer.refresh();
                this.fTableViewer.refresh();
            });
            double[] ySeries = this.getSeries().getYSeries();
            return Arrays.equals(expected, ySeries);
        }, null, (String)"Unable to refresh viewer series");
    }

    private void waitForTable(int nbOfRows) {
        SWTBotUtils.waitUntil(tableBot -> {
            UIThreadRunnable.syncExec(() -> this.fTableViewer.refresh());
            return tableBot.rowCount() == nbOfRows;
        }, (Object)this.fTableBot, (String)"Unable to refresh the table");
    }

    private /* synthetic */ void lambda$1(ISegmentStoreProvider iSegmentStoreProvider) {
        this.fTableViewer.setData(iSegmentStoreProvider);
        this.fDensityViewer.setSegmentProvider(iSegmentStoreProvider);
        this.fDensityViewer.updateWithRange(TmfTimeRange.ETERNITY);
        this.fDensityViewer.refresh();
        this.fTableViewer.refresh();
    }
}

