/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateSystemBuilderUtilsTest {
    private static final long START_TIME = 1000L;
    private static final long TIME_INCREMENT = 10L;
    private static final @NonNull String DUMMY_STRING = "test";
    private ITmfStateSystemBuilder fStateSystem;

    @Before
    public void setupStateSystem() {
        try {
            IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)DUMMY_STRING, (long)1000L);
            this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIncrementLong() {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        int quark = ss.getQuarkAbsoluteAndAdd(new String[]{DUMMY_STRING});
        try {
            ITmfStateValue value = ss.queryOngoingState(quark);
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)value);
            long increment = 3L;
            StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ss, (long)1010L, (int)quark, (long)increment);
            value = ss.queryOngoingState(quark);
            Assert.assertEquals((Object)TmfStateValue.newValueLong((long)increment), (Object)value);
            Long increment2 = 1000L;
            StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ss, (long)1010L, (int)quark, (long)increment2);
            value = ss.queryOngoingState(quark);
            Assert.assertEquals((Object)TmfStateValue.newValueLong((long)(increment + increment2)), (Object)value);
            Long increment3 = -500L;
            StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ss, (long)1010L, (int)quark, (long)increment3);
            value = ss.queryOngoingState(quark);
            Assert.assertEquals((Object)TmfStateValue.newValueLong((long)(increment + increment2 + increment3)), (Object)value);
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIncrementInt() {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        int quark = ss.getQuarkAbsoluteAndAdd(new String[]{DUMMY_STRING});
        try {
            ITmfStateValue value = ss.queryOngoingState(quark);
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)value);
            int increment = 3;
            StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ss, (long)1010L, (int)quark, (int)increment);
            value = ss.queryOngoingState(quark);
            Assert.assertEquals((Object)TmfStateValue.newValueInt((int)increment), (Object)value);
            int increment2 = 1000;
            StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ss, (long)1010L, (int)quark, (int)increment2);
            value = ss.queryOngoingState(quark);
            Assert.assertEquals((Object)TmfStateValue.newValueInt((int)(increment + increment2)), (Object)value);
            int increment3 = -500;
            StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ss, (long)1010L, (int)quark, (int)increment3);
            value = ss.queryOngoingState(quark);
            Assert.assertEquals((Object)TmfStateValue.newValueInt((int)(increment + increment2 + increment3)), (Object)value);
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

