/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateSystemUtilsTest {
    private static final long START_TIME = 1000L;
    private static final @NonNull String DUMMY_STRING = "test";
    private ITmfStateSystemBuilder fStateSystem;

    @Before
    public void setupStateSystem() {
        try {
            IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)DUMMY_STRING, (long)1000L);
            this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
            int quark = this.fStateSystem.getQuarkAbsoluteAndAdd(new String[]{DUMMY_STRING});
            this.fStateSystem.modifyAttribute(1200L, (Object)10, quark);
            this.fStateSystem.modifyAttribute(1500L, (Object)20, quark);
            this.fStateSystem.closeHistory(2000L);
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.fStateSystem.dispose();
    }

    @Test
    public void testQueryUntilNonNullValue() {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        try {
            int quark = ss.getQuarkAbsolute(new String[]{DUMMY_STRING});
            Assert.assertNull((Object)StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)0L, (long)999L));
            Assert.assertNull((Object)StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)2001L, (long)5000L));
            Assert.assertNull((Object)StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)1000L, (long)1199L));
            ITmfStateInterval interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)1000L, (long)1300L);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)ITmfStateValue.Type.INTEGER, (Object)interval.getStateValue().getType());
            Assert.assertEquals((long)10L, (long)interval.getStateValue().unboxInt());
            interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)800L, (long)2500L);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)ITmfStateValue.Type.INTEGER, (Object)interval.getStateValue().getType());
            Assert.assertEquals((long)10L, (long)interval.getStateValue().unboxInt());
            interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)1300L, (long)1800L);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)ITmfStateValue.Type.INTEGER, (Object)interval.getStateValue().getType());
            Assert.assertEquals((long)10L, (long)interval.getStateValue().unboxInt());
            interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)1500L, (long)1800L);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)ITmfStateValue.Type.INTEGER, (Object)interval.getStateValue().getType());
            Assert.assertEquals((long)20L, (long)interval.getStateValue().unboxInt());
            interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)1800L, (long)2500L);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)ITmfStateValue.Type.INTEGER, (Object)interval.getStateValue().getType());
            Assert.assertEquals((long)20L, (long)interval.getStateValue().unboxInt());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIteratorOverQuark() {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        int quark = 0;
        while (quark < ss.getNbAttributes()) {
            StateSystemUtils.QuarkIterator iterator = new StateSystemUtils.QuarkIterator((ITmfStateSystem)ss, quark, Long.MIN_VALUE);
            ITmfStateInterval prevInterval = null;
            ITmfStateInterval currInterval = null;
            while (iterator.hasNext()) {
                currInterval = iterator.next();
                Assert.assertEquals((long)quark, (long)currInterval.getAttribute());
                if (prevInterval == null) {
                    Assert.assertEquals((long)currInterval.getStartTime(), (long)ss.getStartTime());
                } else {
                    Assert.assertEquals((long)(prevInterval.getEndTime() + 1L), (long)currInterval.getStartTime());
                }
                prevInterval = currInterval;
            }
            Assert.assertNotNull((String)"Iterator should have returned at least one interval", currInterval);
            Assert.assertEquals((long)ss.getCurrentEndTime(), (long)currInterval.getEndTime());
            ++quark;
        }
    }

    @Test
    public void testIteratorOverQuarkSubrange() {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        try {
            int quark = ss.getQuarkAbsolute(new String[]{DUMMY_STRING});
            StateSystemUtils.QuarkIterator iterator = new StateSystemUtils.QuarkIterator((ITmfStateSystem)ss, quark, 1800L);
            Assert.assertTrue((boolean)iterator.hasNext());
            ITmfStateInterval interval = iterator.next();
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((long)1500L, (long)interval.getStartTime());
            Assert.assertEquals((long)2000L, (long)interval.getEndTime());
            Assert.assertFalse((boolean)iterator.hasNext());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIteratorOverQuarkEndTime() {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        try {
            int quark = ss.getQuarkAbsolute(new String[]{DUMMY_STRING});
            StateSystemUtils.QuarkIterator iterator = new StateSystemUtils.QuarkIterator((ITmfStateSystem)ss, quark, Long.MIN_VALUE, 1199L);
            Assert.assertTrue((boolean)iterator.hasNext());
            ITmfStateInterval interval = iterator.next();
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((long)1000L, (long)interval.getStartTime());
            Assert.assertEquals((long)1199L, (long)interval.getEndTime());
            Assert.assertFalse((boolean)iterator.hasNext());
            iterator = new StateSystemUtils.QuarkIterator((ITmfStateSystem)ss, quark, Long.MIN_VALUE, 1200L);
            Assert.assertTrue((boolean)iterator.hasNext());
            interval = iterator.next();
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((long)1000L, (long)interval.getStartTime());
            Assert.assertEquals((long)1199L, (long)interval.getEndTime());
            Assert.assertTrue((boolean)iterator.hasNext());
            interval = iterator.next();
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((long)1200L, (long)interval.getStartTime());
            Assert.assertEquals((long)1499L, (long)interval.getEndTime());
            Assert.assertFalse((boolean)iterator.hasNext());
            iterator = new StateSystemUtils.QuarkIterator((ITmfStateSystem)ss, quark, 1800L, 5000L);
            Assert.assertTrue((boolean)iterator.hasNext());
            interval = iterator.next();
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((long)1500L, (long)interval.getStartTime());
            Assert.assertEquals((long)2000L, (long)interval.getEndTime());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIteratorOverQuarkResolution() {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)DUMMY_STRING, (long)1L);
        ITmfStateSystemBuilder ss = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
        try {
            try {
                int quark = ss.getQuarkAbsoluteAndAdd(new String[]{DUMMY_STRING});
                ss.modifyAttribute(1L, (Object)1, quark);
                ss.modifyAttribute(7L, (Object)2, quark);
                ss.modifyAttribute(8L, (Object)1, quark);
                ss.modifyAttribute(9L, (Object)2, quark);
                ss.closeHistory(12L);
                StateSystemUtils.QuarkIterator iterator = new StateSystemUtils.QuarkIterator((ITmfStateSystem)ss, quark, 2L, 14L, 4L);
                Assert.assertTrue((boolean)iterator.hasNext());
                ITmfStateInterval interval = iterator.next();
                Assert.assertNotNull((Object)interval);
                Assert.assertEquals((long)1L, (long)interval.getStartTime());
                Assert.assertEquals((long)6L, (long)interval.getEndTime());
                Assert.assertTrue((boolean)iterator.hasNext());
                interval = iterator.next();
                Assert.assertNotNull((Object)interval);
                Assert.assertEquals((long)9L, (long)interval.getStartTime());
                Assert.assertEquals((long)12L, (long)interval.getEndTime());
                Assert.assertFalse((boolean)iterator.hasNext());
                Assert.assertTrue((boolean)iterator.hasPrevious());
                interval = iterator.previous();
                Assert.assertNotNull((Object)interval);
                Assert.assertEquals((long)1L, (long)interval.getStartTime());
                Assert.assertEquals((long)6L, (long)interval.getEndTime());
                Assert.assertFalse((boolean)iterator.hasPrevious());
                iterator = new StateSystemUtils.QuarkIterator((ITmfStateSystem)ss, quark, 2L, 14L, 3L);
                Assert.assertTrue((boolean)iterator.hasNext());
                interval = iterator.next();
                Assert.assertNotNull((Object)interval);
                Assert.assertEquals((long)1L, (long)interval.getStartTime());
                Assert.assertEquals((long)6L, (long)interval.getEndTime());
                Assert.assertTrue((boolean)iterator.hasNext());
                interval = iterator.next();
                Assert.assertNotNull((Object)interval);
                Assert.assertEquals((long)8L, (long)interval.getStartTime());
                Assert.assertEquals((long)8L, (long)interval.getEndTime());
                Assert.assertTrue((boolean)iterator.hasNext());
                interval = iterator.next();
                Assert.assertNotNull((Object)interval);
                Assert.assertEquals((long)9L, (long)interval.getStartTime());
                Assert.assertEquals((long)12L, (long)interval.getEndTime());
                Assert.assertFalse((boolean)iterator.hasNext());
                Assert.assertTrue((boolean)iterator.hasPrevious());
                interval = iterator.previous();
                Assert.assertNotNull((Object)interval);
                Assert.assertEquals((long)8L, (long)interval.getStartTime());
                Assert.assertEquals((long)8L, (long)interval.getEndTime());
                Assert.assertTrue((boolean)iterator.hasPrevious());
                interval = iterator.previous();
                Assert.assertNotNull((Object)interval);
                Assert.assertEquals((long)1L, (long)interval.getStartTime());
                Assert.assertEquals((long)6L, (long)interval.getEndTime());
                Assert.assertFalse((boolean)iterator.hasPrevious());
            }
            catch (StateValueTypeException e) {
                Assert.fail((String)e.getMessage());
                ss.dispose();
            }
        }
        finally {
            ss.dispose();
        }
    }

    @Test
    public void testIteratorOverQuarkAddMoreIntervals() {
        try {
            IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)DUMMY_STRING, (long)1000L);
            ITmfStateSystemBuilder ss = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
            int quark = ss.getQuarkAbsoluteAndAdd(new String[]{DUMMY_STRING});
            ss.modifyAttribute(1200L, (Object)10, quark);
            ss.modifyAttribute(1500L, (Object)20, quark);
            StateSystemUtils.QuarkIterator iterator = new StateSystemUtils.QuarkIterator((ITmfStateSystem)ss, quark, 0L);
            Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)iterator));
            iterator = new StateSystemUtils.QuarkIterator((ITmfStateSystem)ss, quark, 0L);
            ss.closeHistory(2000L);
            Assert.assertEquals((long)3L, (long)Iterators.size((Iterator)iterator));
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIteratorOverQuarkReversed() {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        int quark = 0;
        while (quark < ss.getNbAttributes()) {
            StateSystemUtils.QuarkIterator iterator = new StateSystemUtils.QuarkIterator((ITmfStateSystem)ss, quark, Long.MAX_VALUE);
            ITmfStateInterval prevInterval = null;
            ITmfStateInterval currInterval = null;
            while (iterator.hasPrevious()) {
                currInterval = iterator.previous();
                Assert.assertEquals((long)quark, (long)currInterval.getAttribute());
                if (prevInterval == null) {
                    Assert.assertEquals((long)currInterval.getEndTime(), (long)ss.getCurrentEndTime());
                } else {
                    Assert.assertEquals((long)(prevInterval.getStartTime() - 1L), (long)currInterval.getEndTime());
                }
                prevInterval = currInterval;
            }
            Assert.assertNotNull((String)"Iterator should have returned at least one interval", currInterval);
            Assert.assertEquals((long)ss.getStartTime(), (long)currInterval.getStartTime());
            ++quark;
        }
    }
}

