/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.junit.Assert;
import org.junit.Test;

public class TmfEventFieldTest {
    private final @NonNull String fFieldName1 = "Field-1";
    private final @NonNull String fFieldName2 = "Field-2";
    private final Object fValue1 = "Value";
    private final Object fValue2 = 10;
    private final TmfEventField fField1 = new TmfEventField("Field-1", this.fValue1, null);
    private final TmfEventField fField2 = new TmfEventField("Field-2", this.fValue2, null);
    private final TmfEventField fField3 = new TmfEventField("Field-1", this.fValue2, null);
    private final @NonNull String fStructRootFieldName = "Root-S";
    private final String[] fStructFieldNames = new String[]{"Field-1", "Field-2"};
    private final TmfEventField fStructTerminalField1 = new TmfEventField("Field-1", null, null);
    private final TmfEventField fStructTerminalField2 = new TmfEventField("Field-2", null, null);
    private final TmfEventField fStructTerminalField3 = new TmfEventField("Field-1", null, null);
    private final TmfEventField fStructRootField = new TmfEventField("Root-S", null, new ITmfEventField[]{this.fStructTerminalField1, this.fStructTerminalField2});
    private final @NonNull String fRootFieldName = "Root";
    private final String[] fFieldNames = new String[]{"Field-1", "Field-2"};
    private final TmfEventField fRootField = new TmfEventField("Root", null, new ITmfEventField[]{this.fField1, this.fField2});

    @Test
    public void testTerminalStructConstructor() {
        Assert.assertSame((String)"getName", (Object)"Field-1", (Object)this.fStructTerminalField1.getName());
        Assert.assertNull((String)"getValue", (Object)this.fStructTerminalField1.getValue());
        Assert.assertEquals((String)"getFields", (long)0L, (long)this.fStructTerminalField1.getFields().size());
        Assert.assertNull((String)"getField(name)", (Object)this.fStructTerminalField1.getField(new String[]{"Field-1"}));
        Assert.assertEquals((String)"getFieldNames", (long)0L, (long)this.fStructTerminalField1.getFieldNames().size());
    }

    @Test
    public void testNonTerminalStructConstructor() {
        Assert.assertSame((String)"getName", (Object)"Root-S", (Object)this.fStructRootField.getName());
        Assert.assertNull((String)"getValue", (Object)this.fStructRootField.getValue());
        Assert.assertEquals((String)"getFields", (long)2L, (long)this.fStructRootField.getFields().size());
        Assert.assertSame((String)"getField(name)", (Object)this.fStructTerminalField1, (Object)this.fStructRootField.getField(new String[]{"Field-1"}));
        Assert.assertSame((String)"getField(name)", (Object)this.fStructTerminalField2, (Object)this.fStructRootField.getField(new String[]{"Field-2"}));
        Collection names = this.fStructRootField.getFieldNames();
        Assert.assertEquals((String)"getFieldNames length", (long)2L, (long)names.size());
        Assert.assertArrayEquals((Object[])this.fStructFieldNames, (Object[])names.toArray(new String[names.size()]));
    }

    @Test
    public void testTerminalConstructor() {
        Assert.assertSame((String)"getName", (Object)"Field-1", (Object)this.fField1.getName());
        Assert.assertSame((String)"getValue", (Object)this.fValue1, (Object)this.fField1.getValue());
        Assert.assertEquals((String)"getFields", (long)0L, (long)this.fField1.getFields().size());
        Assert.assertNull((String)"getField(name)", (Object)this.fField1.getField(new String[]{"Field-1"}));
        Assert.assertEquals((String)"getFieldNames", (long)0L, (long)this.fField1.getFieldNames().size());
        Assert.assertSame((String)"getName", (Object)"Field-2", (Object)this.fField2.getName());
        Assert.assertSame((String)"getValue", (Object)this.fValue2, (Object)this.fField2.getValue());
        Assert.assertEquals((String)"getFields", (long)0L, (long)this.fField2.getFields().size());
        Assert.assertNull((String)"getField(name)", (Object)this.fField2.getField(new String[]{"Field-2"}));
    }

    @Test
    public void testNonTerminalConstructor() {
        Assert.assertSame((String)"getName", (Object)"Root", (Object)this.fRootField.getName());
        Assert.assertNull((String)"getValue", (Object)this.fRootField.getValue());
        Assert.assertEquals((String)"getFields", (long)2L, (long)this.fRootField.getFields().size());
        Assert.assertSame((String)"getField(name)", (Object)this.fField1, (Object)this.fRootField.getField(new String[]{"Field-1"}));
        Assert.assertSame((String)"getField(name)", (Object)this.fField2, (Object)this.fRootField.getField(new String[]{"Field-2"}));
        Collection names = this.fRootField.getFieldNames();
        Assert.assertEquals((String)"getFieldNames length", (long)2L, (long)names.size());
        Assert.assertArrayEquals((Object[])this.fFieldNames, (Object[])names.toArray(new String[names.size()]));
    }

    @Test
    public void testTerminalCopyConstructor() {
        TmfEventField copy = new TmfEventField(this.fField1);
        Assert.assertSame((String)"getName", (Object)"Field-1", (Object)copy.getName());
        Assert.assertSame((String)"getValue", (Object)this.fValue1, (Object)copy.getValue());
        Assert.assertEquals((String)"getFields", (long)0L, (long)copy.getFields().size());
        Assert.assertNull((String)"getField(name)", (Object)copy.getField(new String[]{"Field-1"}));
        Assert.assertEquals((String)"getFieldNames", (long)0L, (long)copy.getFieldNames().size());
    }

    @Test
    public void testNonTerminalCopyConstructor() {
        Assert.assertSame((String)"getName", (Object)"Root", (Object)this.fRootField.getName());
        Assert.assertNull((String)"getValue", (Object)this.fRootField.getValue());
        Assert.assertEquals((String)"getFields", (long)2L, (long)this.fRootField.getFields().size());
        Assert.assertSame((String)"getField(name)", (Object)this.fField1, (Object)this.fRootField.getField(new String[]{"Field-1"}));
        Assert.assertSame((String)"getField(name)", (Object)this.fField2, (Object)this.fRootField.getField(new String[]{"Field-2"}));
        Collection names = this.fRootField.getFieldNames();
        Assert.assertEquals((String)"getFieldNames length", (long)2L, (long)names.size());
        Assert.assertArrayEquals((Object[])this.fFieldNames, (Object[])names.toArray(new String[names.size()]));
    }

    @Test
    public void testCopyConstructorBadArg() {
        try {
            new TmfEventField(null);
            Assert.fail((String)"TmfEventField: null arguemnt");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDuplicateFieldNames() {
        ITmfEventField[] fields = new ITmfEventField[]{new TmfEventField("samename", null, null), new TmfEventField("samename", null, null)};
        try {
            new TmfEventField("field", null, fields);
            Assert.fail((String)"TmfEventField: Duplicate field names");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHashCode() {
        TmfEventField copy = new TmfEventField(this.fField1);
        Assert.assertTrue((String)"hashCode", (this.fField1.hashCode() == copy.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fField1.hashCode() != this.fField2.hashCode() ? 1 : 0) != 0);
        copy = new TmfEventField(this.fStructTerminalField1);
        Assert.assertTrue((String)"hashCode", (this.fStructTerminalField1.hashCode() == copy.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fStructTerminalField1.hashCode() != this.fStructTerminalField2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fField1.equals((Object)this.fField1));
        Assert.assertTrue((String)"equals", (boolean)this.fField2.equals((Object)this.fField2));
        Assert.assertFalse((String)"equals", (boolean)this.fField1.equals((Object)this.fField2));
        Assert.assertFalse((String)"equals", (boolean)this.fField2.equals((Object)this.fField1));
        Assert.assertTrue((String)"equals", (boolean)this.fStructTerminalField1.equals((Object)this.fStructTerminalField1));
        Assert.assertTrue((String)"equals", (boolean)this.fStructTerminalField2.equals((Object)this.fStructTerminalField2));
        Assert.assertFalse((String)"equals", (boolean)this.fStructTerminalField1.equals((Object)this.fStructTerminalField2));
        Assert.assertFalse((String)"equals", (boolean)this.fStructTerminalField2.equals((Object)this.fStructTerminalField1));
    }

    @Test
    public void testEqualsSymmetry() {
        TmfEventField copy0 = new TmfEventField(this.fField1);
        Assert.assertTrue((String)"equals", (boolean)this.fField1.equals((Object)copy0));
        Assert.assertTrue((String)"equals", (boolean)copy0.equals((Object)this.fField1));
        TmfEventField copy3 = new TmfEventField(this.fField2);
        Assert.assertTrue((String)"equals", (boolean)this.fField2.equals((Object)copy3));
        Assert.assertTrue((String)"equals", (boolean)copy3.equals((Object)this.fField2));
    }

    @Test
    public void testEqualsTransivity() {
        TmfEventField copy1 = new TmfEventField(this.fField1);
        TmfEventField copy2 = new TmfEventField(copy1);
        Assert.assertTrue((String)"equals", (boolean)this.fField1.equals((Object)copy1));
        Assert.assertTrue((String)"equals", (boolean)copy1.equals((Object)copy2));
        Assert.assertTrue((String)"equals", (boolean)this.fField1.equals((Object)copy2));
        copy1 = new TmfEventField(this.fField2);
        copy2 = new TmfEventField(copy1);
        Assert.assertTrue((String)"equals", (boolean)this.fField2.equals((Object)copy1));
        Assert.assertTrue((String)"equals", (boolean)copy1.equals((Object)copy2));
        Assert.assertTrue((String)"equals", (boolean)this.fField2.equals((Object)copy2));
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((String)"equals", (boolean)this.fStructTerminalField1.equals((Object)this.fStructTerminalField3));
        Assert.assertTrue((String)"equals", (boolean)this.fStructTerminalField3.equals((Object)this.fStructTerminalField1));
        Assert.assertFalse((String)"equals", (boolean)this.fStructTerminalField1.equals((Object)this.fField3));
        Assert.assertFalse((String)"equals", (boolean)this.fField3.equals((Object)this.fStructTerminalField1));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertFalse((String)"equals", (boolean)this.fField1.equals(null));
        Assert.assertFalse((String)"equals", (boolean)this.fField2.equals(null));
    }

    @Test
    public void testNonEqualClasses() {
        Assert.assertFalse((String)"equals", (boolean)this.fField1.equals((Object)this.fStructTerminalField1));
        Assert.assertFalse((String)"equals", (boolean)this.fField1.equals(this.fValue1));
    }

    @Test
    public void testNonEqualValues() {
        TmfEventField copy1 = new TmfEventField("Field-1", this.fValue1, null);
        TmfEventField copy2 = new TmfEventField("Field-1", this.fValue1, null);
        Assert.assertTrue((String)"equals", (boolean)copy1.equals((Object)copy2));
        Assert.assertTrue((String)"equals", (boolean)copy2.equals((Object)copy1));
        copy2 = new TmfEventField("Field-1", this.fValue2, null);
        Assert.assertFalse((String)"equals", (boolean)copy1.equals((Object)copy2));
        Assert.assertFalse((String)"equals", (boolean)copy2.equals((Object)copy1));
        copy2 = new TmfEventField("Field-1", null, null);
        Assert.assertFalse((String)"equals", (boolean)copy1.equals((Object)copy2));
        Assert.assertFalse((String)"equals", (boolean)copy2.equals((Object)copy1));
    }

    @Test
    public void testNonEquals() {
        Assert.assertFalse((String)"equals", (boolean)this.fField1.equals((Object)this.fField2));
        Assert.assertFalse((String)"equals", (boolean)this.fField2.equals((Object)this.fField1));
        Assert.assertFalse((String)"equals", (boolean)this.fField1.equals((Object)this.fStructTerminalField1));
    }

    @Test
    public void testNonEqualsValue() {
        String fieldName = "myfield";
        String value1 = new String("test-string");
        TmfEvent value2 = new TmfEvent(null, -1L, null, null, null);
        TmfEventField[] fields = new TmfEventField[]{this.fField1, this.fField2};
        TmfEventField field1 = new TmfEventField("myfield", (Object)value1, (ITmfEventField[])fields);
        TmfEventField field2 = new TmfEventField("myfield", (Object)value2, (ITmfEventField[])fields);
        Assert.assertNotEquals((Object)field1, (Object)field2);
        Assert.assertNotEquals((Object)field2, (Object)field1);
    }

    @Test
    public void testNonEqualsFields() {
        String fieldName = "myfield";
        String value = new String("test-string");
        TmfEventField[] fields1 = new TmfEventField[]{this.fField1, this.fField2};
        TmfEventField[] fields2 = new TmfEventField[]{this.fField2, this.fField3};
        TmfEventField field1 = new TmfEventField("myfield", (Object)value, (ITmfEventField[])fields1);
        TmfEventField field2 = new TmfEventField("myfield", (Object)value, (ITmfEventField[])fields2);
        Assert.assertNotEquals((Object)field1, (Object)field2);
        Assert.assertNotEquals((Object)field2, (Object)field1);
    }

    @Test
    public void testEqualsEverything() {
        String fieldName = "myfield";
        String value = new String("test-string");
        TmfEventField[] fields = new TmfEventField[]{this.fField1, this.fField2};
        TmfEventField field1 = new TmfEventField("myfield", (Object)value, (ITmfEventField[])fields);
        TmfEventField field2 = new TmfEventField("myfield", (Object)value, (ITmfEventField[])fields);
        Assert.assertEquals((Object)field1, (Object)field2);
        Assert.assertEquals((Object)field2, (Object)field1);
    }

    @Test
    public void testToString() {
        String expected1 = "Field-1=" + this.fValue1.toString();
        TmfEventField field = new TmfEventField("Field-1", this.fValue1, null);
        Assert.assertEquals((String)"toString", (Object)expected1, (Object)field.toString());
        String expected2 = "Field-1=" + this.fValue2.toString();
        field = new TmfEventField("Field-1", this.fValue2, null);
        Assert.assertEquals((String)"toString", (Object)expected2, (Object)field.toString());
    }

    @Test
    public void testMakeRoot() {
        ITmfEventField root = TmfEventField.makeRoot((String[])this.fStructFieldNames);
        Collection names = root.getFieldNames();
        Assert.assertEquals((String)"getFieldNames length", (long)2L, (long)names.size());
        Assert.assertArrayEquals((Object[])this.fStructFieldNames, (Object[])names.toArray(new String[names.size()]));
        root = TmfEventField.makeRoot((String[])this.fFieldNames);
        names = root.getFieldNames();
        Assert.assertEquals((String)"getFieldNames length", (long)2L, (long)names.size());
        Assert.assertArrayEquals((Object[])this.fFieldNames, (Object[])names.toArray(new String[names.size()]));
    }

    @Test
    public void testGetFieldValueExists() {
        String value = (String)this.fRootField.getFieldValue(String.class, new String[]{"Field-1"});
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)this.fValue1, (Object)value);
    }

    @Test
    public void testGetFieldValueExistsButWrongType() {
        Integer value = (Integer)this.fRootField.getFieldValue(Integer.class, new String[]{"Field-1"});
        Assert.assertNull((Object)value);
    }

    @Test
    public void testGetFieldValueDoesntExist() {
        String value = (String)this.fRootField.getFieldValue(String.class, new String[]{"no-field"});
        Assert.assertNull((Object)value);
    }

    @Test
    public void testGetFieldValueNullValue() {
        TmfEventField subField = new TmfEventField("subField", null, null);
        TmfEventField rootField = new TmfEventField("rootField", null, new ITmfEventField[]{subField});
        String value = (String)rootField.getFieldValue(String.class, new String[]{"subField"});
        Assert.assertNull((Object)value);
    }

    @Test
    public void testGetFieldValueAssignableValue() {
        Number value = (Number)this.fRootField.getFieldValue(Number.class, new String[]{"Field-2"});
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)this.fValue2, (Object)value);
    }
}

