/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.analysis;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TestExperimentAnalysis
extends TmfStateSystemAnalysisModule {
    public static final String TRACE_QUARK_NAME = "Traces";

    protected ITmfStateProvider createStateProvider() {
        return new TestExpStateSystemProvider((ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace()));
    }

    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.INMEM;
    }

    private class TestExpStateSystemProvider
    extends AbstractTmfStateProvider {
        private static final int VERSION = 1;
        private final Set<ITmfTrace> fTraces;
        private int fCount;

        public TestExpStateSystemProvider(ITmfTrace trace) {
            super(trace, "Stub State System for Experiment");
            this.fTraces = new HashSet<ITmfTrace>();
            this.fCount = 0;
        }

        public int getVersion() {
            return 1;
        }

        public ITmfStateProvider getNewInstance() {
            return new TestExpStateSystemProvider(this.getTrace());
        }

        protected void eventHandle(ITmfEvent event) {
            ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
            if (!this.fTraces.contains(event.getTrace())) {
                try {
                    int quarkId = ss.getQuarkAbsoluteAndAdd(new String[]{TestExperimentAnalysis.TRACE_QUARK_NAME});
                    ss.modifyAttribute(event.getTimestamp().getValue(), (ITmfStateValue)TmfStateValue.newValueInt((int)(++this.fCount)), quarkId);
                    this.fTraces.add(event.getTrace());
                }
                catch (StateValueTypeException | TimeRangeException throwable) {
                    // empty catch block
                }
            }
        }
    }
}

