/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.parsers.custom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class AbstractCustomParserWizard {
    private static final Logger fLogger = Logger.getRootLogger();
    protected static SWTWorkbenchBot fBot;

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void terminate() {
        fLogger.removeAllAppenders();
    }

    protected static String extractTestXml(File xmlFile, String category, String definitionName) throws IOException, FileNotFoundException {
        StringBuilder xmlPart = new StringBuilder();
        boolean started = false;
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedRandomAccessFile raf = new BufferedRandomAccessFile(xmlFile, "r");){
            String s = raf.readLine();
            while (s != null) {
                if (s.equals("<Definition category=\"" + category + "\" name=\"" + definitionName + "\">")) {
                    started = true;
                }
                if (started) {
                    if (s.equals("</Definition>")) {
                        break;
                    }
                    xmlPart.append(s);
                    xmlPart.append('\n');
                }
                s = raf.readLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return xmlPart.toString();
    }

    protected static class CustomDefinitionHasContent
    extends DefaultCondition {
        private final File fDefinitionFile;
        private final String fCategoryName;
        private final String fTypeName;
        private final String fExpectedContent;

        protected CustomDefinitionHasContent(File definitionFile, String categoryName, String typeName, String expectedContent) {
            this.fDefinitionFile = definitionFile;
            this.fCategoryName = categoryName;
            this.fTypeName = typeName;
            this.fExpectedContent = expectedContent;
        }

        public boolean test() throws Exception {
            return AbstractCustomParserWizard.extractTestXml(this.fDefinitionFile, this.fCategoryName, this.fTypeName).equals(this.fExpectedContent);
        }

        public String getFailureMessage() {
            return "The file " + this.fDefinitionFile + " did not contain expected content for " + this.fCategoryName + ":" + this.fTypeName + ", Expected:" + this.fExpectedContent;
        }
    }
}

