/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards;

import java.net.URL;
import java.util.Calendar;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards.AbstractStandardImportWizardTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards.SWTBotImportWizardUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class StandardImportWizardTest
extends AbstractStandardImportWizardTest {
    private static final String TEST_FOLDER_NAME = "testfiles";
    private static final int YEAR = Calendar.getInstance().get(1);
    private static final String START_TIME = String.valueOf(YEAR) + "-01-01 02:00:00";
    private static final String END_TIME = String.valueOf(YEAR) + "-01-01 05:05:00";

    @Before
    public void setup() {
        this.createProject();
        SWTBotPreferences.TIMEOUT = 20000L;
    }

    @After
    public void tearDown() {
        SWTBotUtils.deleteProject("Tracing", StandardImportWizardTest.getSWTBot());
    }

    @Test
    public void testImportTimerange() throws Exception {
        this.openImportWizard();
        StandardImportWizardTest.selectSyslog();
        SWTBotImportWizardUtils.setOptions((SWTBot)StandardImportWizardTest.getSWTBot(), 128, null);
        StandardImportWizardTest.setTimeRange(START_TIME, END_TIME);
        this.importFinish();
        StandardImportWizardTest.verifyImport(4);
    }

    @Test
    public void testImportTimerangeInvalidFormat() throws Exception {
        SWTWorkbenchBot bot = StandardImportWizardTest.getSWTBot();
        this.openImportWizard();
        StandardImportWizardTest.selectSyslog();
        SWTBotImportWizardUtils.setOptions((SWTBot)bot, 128, null);
        StandardImportWizardTest.setTimeRange("invalid timestamp", END_TIME);
        SWTBotImportWizardUtils.checkFinishButton((SWTBot)bot, false);
        StandardImportWizardTest.setTimeRange("02:00:00", END_TIME);
        SWTBotImportWizardUtils.checkFinishButton((SWTBot)bot, false);
    }

    @Test
    public void testImportTimerangeInverseTime() throws Exception {
        this.openImportWizard();
        StandardImportWizardTest.selectSyslog();
        SWTBotImportWizardUtils.setOptions((SWTBot)StandardImportWizardTest.getSWTBot(), 128, null);
        StandardImportWizardTest.setTimeRange(END_TIME, START_TIME);
        this.importFinish();
        StandardImportWizardTest.verifyImport(4);
    }

    private static void setTimeRange(String start, String end) {
        SWTWorkbenchBot bot = StandardImportWizardTest.getSWTBot();
        bot.textWithLabel(Messages.ImportTraceWizard_StartTime).setText(start);
        bot.textWithLabel(Messages.ImportTraceWizard_EndTime).setText(end);
    }

    private static void verifyImport(int expectedLength) {
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder(StandardImportWizardTest.getSWTBot(), "Tracing");
        tracesFolder.expand();
        SWTBotTreeItem[] traceItems = tracesFolder.getItems();
        Assert.assertEquals((long)expectedLength, (long)traceItems.length);
    }

    private static void selectSyslog() throws Exception {
        SWTWorkbenchBot bot = StandardImportWizardTest.getSWTBot();
        URL resource = TmfCoreTestPlugin.getDefault().getBundle().getResource(TEST_FOLDER_NAME);
        String path = FileLocator.toFileURL((URL)resource).toURI().getPath();
        SWTBotImportWizardUtils.selectImportFromDirectory((SWTBot)bot, path);
        int i = 1;
        while (i <= 6) {
            SWTBotImportWizardUtils.selectFile((SWTBot)bot, "syslog" + i, TEST_FOLDER_NAME);
            ++i;
        }
    }
}

