/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.project.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfExperimentStub;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.tests.experiment.type.TmfEventsEditorStub;
import org.eclipse.tracecompass.tmf.ui.tests.shared.ProjectModelTestData;
import org.eclipse.tracecompass.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TraceAndExperimentTypeTest {
    public static final String TEST_EXPERIMENT_TYPE = "org.eclipse.linuxtools.tmf.core.tests.experimenttype";
    private TmfProjectElement fixture;
    private TmfExperimentElement fExperiment;
    private final String EXPERIMENT_NAME = "exp_test";

    @Before
    public void setUp() {
        try {
            this.fixture = ProjectModelTestData.getFilledProject();
            this.fExperiment = ProjectModelTestData.addExperiment(this.fixture, "exp_test");
            Assert.assertNotNull((Object)this.fExperiment);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void cleanUp() {
        ProjectModelTestData.deleteProject(this.fixture);
    }

    @Test
    public void testDefaultExperimentType() {
        TmfExperimentElement experimentElement = ProjectModelTestData.addExperiment(this.fixture, "testDefaultExpType");
        Assert.assertNotNull((Object)experimentElement);
        TmfExperiment experiment = experimentElement.instantiateTrace();
        Assert.assertNotNull((Object)experiment);
        Assert.assertEquals((Object)"org.eclipse.linuxtools.tmf.core.experiment.generic", (Object)experimentElement.getTraceType());
        experiment.dispose();
    }

    @Test
    public void testExperimentType() {
        IFolder resource = this.fExperiment.getResource();
        try {
            resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, TEST_EXPERIMENT_TYPE);
            this.fExperiment.refreshTraceType();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        TmfOpenTraceHelper.openTraceFromElement((TmfCommonProjectElement)this.fExperiment);
        ProjectModelTestData.delayUntilTraceOpened((ITmfProjectModelElement)this.fExperiment);
        ITmfTrace trace = this.fExperiment.getTrace();
        Assert.assertTrue((boolean)(trace instanceof TmfExperimentStub));
    }

    @Test
    public void testNoExperimentTypeChildren() {
        TmfOpenTraceHelper.openTraceFromElement((TmfCommonProjectElement)this.fExperiment);
        ProjectModelTestData.delayUntilTraceOpened((ITmfProjectModelElement)this.fExperiment);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = activePage.getActiveEditor();
        Assert.assertNotNull((Object)editor);
        Assert.assertTrue((boolean)editor.getClass().equals(TmfEventsEditor.class));
    }

    @Test
    public void testExperimentTypeChildren() {
        IFolder resource = this.fExperiment.getResource();
        try {
            resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, TEST_EXPERIMENT_TYPE);
            this.fExperiment.refreshTraceType();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        TmfOpenTraceHelper.openTraceFromElement((TmfCommonProjectElement)this.fExperiment);
        ProjectModelTestData.delayThread(500L);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = activePage.getActiveEditor();
        Assert.assertNotNull((Object)editor);
        Assert.assertTrue((boolean)editor.getClass().equals(TmfEventsEditorStub.class));
        TmfEventsEditorStub editorStub = (TmfEventsEditorStub)editor;
        TmfEventsTable table = editorStub.getNewEventsTable();
        Assert.assertNotNull((Object)table);
        Assert.assertTrue((boolean)table.getClass().equals(TmfEventsTable.class));
    }

    @Test
    public void testExperimentTypeAnalysis() {
        IFolder resource = this.fExperiment.getResource();
        try {
            resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, TEST_EXPERIMENT_TYPE);
            this.fExperiment.refreshTraceType();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        this.fExperiment.getParent().refresh();
        Assert.assertFalse((boolean)this.fExperiment.getAvailableAnalysis().isEmpty());
    }
}

