/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.preferences;

import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IFont;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.impl.ColorImpl;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.impl.FontImpl;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.preferences.ISDPreferences;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.Messages;

public class SDViewPref
implements ISDPreferences,
IPropertyChangeListener {
    private static final RGB DEFAULT_TIME_COMP_RGB = new RGB(218, 232, 238);
    private static final RGB DEFAULT_RGB = new RGB(134, 176, 212);
    private static final RGB DEFAULT_LIFELINE_HEADER_RGB = new RGB(129, 127, 137);
    private static final RGB DEFAULT_FRAME_RGB = new RGB(0, 0, 0);
    private static final RGB DEFAULT_LIFELINE_RGB = new RGB(129, 129, 129);
    private static final RGB FOREGROUND_LIFELINE_RGB = new RGB(129, 129, 129);
    private static final RGB FOREGROUND_FRAME_RGB = new RGB(81, 153, 200);
    private static final RGB FOREGROUND_LIFELINE_HEADER_RGB = new RGB(129, 127, 137);
    private static final RGB FOREGROUND_RGB = new RGB(134, 176, 212);
    private static final RGB BACKGROUND_DEFAULT_RGB = new RGB(255, 255, 255);
    private static final RGB BACKGROUND_LIFELINE_HEADER_RGB = new RGB(245, 244, 244);
    private static final RGB BACKGROUND_LIFELINE_RGB = new RGB(220, 220, 220);
    private static final RGB BACKGROUND_FRAME_RGB = new RGB(201, 222, 233);
    public static final String BACK_COLOR_POSTFIX = "_BACK_COLOR";
    public static final String FORE_COLOR_POSTFIX = "_FORE_COLOR";
    public static final String TEXT_COLOR_POSTFIX = "_TEXT_COLOR";
    private static final String[] FONT_LIST = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_SYNC_MESS", "PREF_SYNC_MESS_RET", "PREF_ASYNC_MESS", "PREF_ASYNC_MESS_RET", "PREF_FRAME", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    private static final String[] FONT_LIST2 = new String[]{Messages.SequenceDiagram_Lifeline, Messages.SequenceDiagram_ExecutionOccurrence, Messages.SequenceDiagram_SyncMessage, Messages.SequenceDiagram_SyncMessageReturn, Messages.SequenceDiagram_AsyncMessage, Messages.SequenceDiagram_AsyncMessageReturn, Messages.SequenceDiagram_Frame, Messages.SequenceDiagram_LifelineHeader, Messages.SequenceDiagram_FrameTitle};
    private static final String[] PREF_BACK_COLOR_LIST = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_FRAME", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    private static final String[] PREF_FORE_COLOR_LIST = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_SYNC_MESS", "PREF_SYNC_MESS_RET", "PREF_ASYNC_MESS", "PREF_ASYNC_MESS_RET", "PREF_FRAME", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    private static final String[] PREF_TEXT_COLOR_LIST = new String[]{"PREF_LIFELINE", "PREF_SYNC_MESS", "PREF_SYNC_MESS_RET", "PREF_ASYNC_MESS", "PREF_ASYNC_MESS_RET", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    public static final String TEMP_TAG = "_TEMP";
    private static SDViewPref fHandle = null;
    private Map<String, IFont> fFontPref;
    private Map<String, IColor> fForeColorPref;
    private Map<String, IColor> fBackColorPref;
    private Map<String, IColor> fTextColorPref;
    private IPreferenceStore fPrefStore = Activator.getDefault().getPreferenceStore();
    private IColor fTimeCompressionSelectionColor = null;
    private boolean fNoFocusSelection = false;

    protected SDViewPref() {
        ColorImpl color;
        this.fPrefStore.setDefault("PREF_LINK_FONT", true);
        this.fPrefStore.setDefault("PREF_EXCLUDE_EXTERNAL_TIME", true);
        this.fPrefStore.setDefault("PREF_LIFELINE_WIDTH", 200);
        this.fPrefStore.setDefault("PREF_USE_GRADIENT", true);
        this.fPrefStore.setDefault("PREF_TOOLTIP", true);
        this.fFontPref = new Hashtable<String, IFont>();
        this.fForeColorPref = new Hashtable<String, IColor>();
        this.fBackColorPref = new Hashtable<String, IColor>();
        this.fTextColorPref = new Hashtable<String, IColor>();
        int i = 0;
        while (i < FONT_LIST.length) {
            if (FONT_LIST[i].equals("PREF_FRAME_NAME")) {
                FontData[] data = Display.getDefault().getSystemFont().getFontData();
                data[0].setStyle(1);
                PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)FONT_LIST[i], (FontData)data[0]);
                PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(FONT_LIST[i]) + TEMP_TAG), (FontData)data[0]);
            } else {
                PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)FONT_LIST[i], (FontData[])Display.getDefault().getSystemFont().getFontData());
                PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(FONT_LIST[i]) + TEMP_TAG), (FontData[])Display.getDefault().getSystemFont().getFontData());
            }
            ++i;
        }
        i = 0;
        while (i < PREF_BACK_COLOR_LIST.length) {
            color = PREF_BACK_COLOR_LIST[i].equals("PREF_EXEC") || PREF_BACK_COLOR_LIST[i].equals("PREF_FRAME_NAME") ? new ColorImpl(Display.getDefault(), BACKGROUND_FRAME_RGB) : (PREF_BACK_COLOR_LIST[i].equals("PREF_LIFELINE") ? new ColorImpl(Display.getDefault(), BACKGROUND_LIFELINE_RGB) : (PREF_BACK_COLOR_LIST[i].equals("PREF_LIFELINE_HEADER") ? new ColorImpl(Display.getDefault(), BACKGROUND_LIFELINE_HEADER_RGB) : new ColorImpl(Display.getDefault(), BACKGROUND_DEFAULT_RGB)));
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_BACK_COLOR_LIST[i]) + BACK_COLOR_POSTFIX), (RGB)((Color)color.getColor()).getRGB());
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_BACK_COLOR_LIST[i]) + BACK_COLOR_POSTFIX + TEMP_TAG), (RGB)((Color)color.getColor()).getRGB());
            color.dispose();
            ++i;
        }
        i = 0;
        while (i < PREF_FORE_COLOR_LIST.length) {
            color = PREF_FORE_COLOR_LIST[i].equals("PREF_LIFELINE") ? new ColorImpl(Display.getDefault(), FOREGROUND_LIFELINE_RGB) : (PREF_FORE_COLOR_LIST[i].equals("PREF_FRAME_NAME") ? new ColorImpl(Display.getDefault(), FOREGROUND_FRAME_RGB) : (PREF_FORE_COLOR_LIST[i].equals("PREF_LIFELINE_HEADER") ? new ColorImpl(Display.getDefault(), FOREGROUND_LIFELINE_HEADER_RGB) : new ColorImpl(Display.getDefault(), FOREGROUND_RGB)));
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_FORE_COLOR_LIST[i]) + FORE_COLOR_POSTFIX), (RGB)((Color)color.getColor()).getRGB());
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_FORE_COLOR_LIST[i]) + FORE_COLOR_POSTFIX + TEMP_TAG), (RGB)((Color)color.getColor()).getRGB());
            color.dispose();
            ++i;
        }
        i = 0;
        while (i < PREF_TEXT_COLOR_LIST.length) {
            color = PREF_TEXT_COLOR_LIST[i].equals("PREF_LIFELINE") ? new ColorImpl(Display.getDefault(), DEFAULT_LIFELINE_RGB) : (PREF_TEXT_COLOR_LIST[i].equals("PREF_FRAME_NAME") ? new ColorImpl(Display.getDefault(), DEFAULT_FRAME_RGB) : (PREF_TEXT_COLOR_LIST[i].equals("PREF_LIFELINE_HEADER") ? new ColorImpl(Display.getDefault(), DEFAULT_LIFELINE_HEADER_RGB) : new ColorImpl(Display.getDefault(), DEFAULT_RGB)));
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_TEXT_COLOR_LIST[i]) + TEXT_COLOR_POSTFIX), (RGB)((Color)color.getColor()).getRGB());
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_TEXT_COLOR_LIST[i]) + TEXT_COLOR_POSTFIX + TEMP_TAG), (RGB)((Color)color.getColor()).getRGB());
            color.dispose();
            ++i;
        }
        ColorImpl color2 = new ColorImpl(Display.getDefault(), DEFAULT_TIME_COMP_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)"PREF_TIME_COMP", (RGB)((Color)color2.getColor()).getRGB());
        color2.dispose();
        this.buildFontsAndColors();
        this.fPrefStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fPrefStore;
    }

    public void apply() {
        this.buildFontsAndColors();
        this.fPrefStore.firePropertyChangeEvent("PREFOK", null, null);
    }

    public static synchronized SDViewPref getInstance() {
        if (fHandle == null) {
            fHandle = new SDViewPref();
        }
        return fHandle;
    }

    @Override
    public IColor getForeGroundColor(String prefName) {
        if (this.fForeColorPref.get(String.valueOf(prefName) + FORE_COLOR_POSTFIX) != null && this.fForeColorPref.get(String.valueOf(prefName) + FORE_COLOR_POSTFIX) instanceof ColorImpl) {
            return this.fForeColorPref.get(String.valueOf(prefName) + FORE_COLOR_POSTFIX);
        }
        return ColorImpl.getSystemColor(2);
    }

    @Override
    public IColor getBackGroundColor(String prefName) {
        if (this.fBackColorPref.get(String.valueOf(prefName) + BACK_COLOR_POSTFIX) != null && this.fBackColorPref.get(String.valueOf(prefName) + BACK_COLOR_POSTFIX) instanceof ColorImpl) {
            return this.fBackColorPref.get(String.valueOf(prefName) + BACK_COLOR_POSTFIX);
        }
        return ColorImpl.getSystemColor(1);
    }

    @Override
    public IColor getFontColor(String prefName) {
        if (this.fTextColorPref.get(String.valueOf(prefName) + TEXT_COLOR_POSTFIX) != null && this.fTextColorPref.get(String.valueOf(prefName) + TEXT_COLOR_POSTFIX) instanceof ColorImpl) {
            return this.fTextColorPref.get(String.valueOf(prefName) + TEXT_COLOR_POSTFIX);
        }
        return ColorImpl.getSystemColor(2);
    }

    @Override
    public IColor getForeGroundColorSelection() {
        if (this.fNoFocusSelection) {
            return ColorImpl.getSystemColor(33);
        }
        return ColorImpl.getSystemColor(27);
    }

    @Override
    public IColor getBackGroundColorSelection() {
        if (this.fNoFocusSelection) {
            return ColorImpl.getSystemColor(22);
        }
        return ColorImpl.getSystemColor(26);
    }

    @Override
    public IFont getFont(String prefName) {
        if (this.fFontPref.get(prefName) != null) {
            return this.fFontPref.get(prefName);
        }
        return FontImpl.getSystemFont();
    }

    public int getLifelineWidth() {
        return this.fPrefStore.getInt("PREF_LIFELINE_WIDTH");
    }

    public boolean fontLinked() {
        return this.fPrefStore.getBoolean("PREF_LINK_FONT");
    }

    public boolean tooltipEnabled() {
        return this.fPrefStore.getBoolean("PREF_TOOLTIP");
    }

    public boolean excludeExternalTime() {
        return this.fPrefStore.getBoolean("PREF_EXCLUDE_EXTERNAL_TIME");
    }

    @Override
    public boolean useGradienColor() {
        return this.fPrefStore.getBoolean("PREF_USE_GRADIENT");
    }

    @Override
    public IColor getTimeCompressionSelectionColor() {
        return this.fTimeCompressionSelectionColor;
    }

    private void buildFontsAndColors() {
        IColor color;
        RGB rgb;
        Display display = Display.getDefault();
        int i = 0;
        while (i < FONT_LIST.length) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)this.fPrefStore, (String)FONT_LIST[i]);
            IFont font = this.fFontPref.get(FONT_LIST[i]);
            if (font != null) {
                font.dispose();
            }
            this.fFontPref.put(FONT_LIST[i], new FontImpl(display, fontData));
            ++i;
        }
        i = 0;
        while (i < PREF_BACK_COLOR_LIST.length) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_BACK_COLOR_LIST[i]) + BACK_COLOR_POSTFIX));
            color = this.fBackColorPref.get(String.valueOf(PREF_BACK_COLOR_LIST[i]) + BACK_COLOR_POSTFIX);
            if (color != null) {
                color.dispose();
            }
            this.fBackColorPref.put(String.valueOf(PREF_BACK_COLOR_LIST[i]) + BACK_COLOR_POSTFIX, new ColorImpl(display, rgb.red, rgb.green, rgb.blue));
            ++i;
        }
        i = 0;
        while (i < PREF_FORE_COLOR_LIST.length) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_FORE_COLOR_LIST[i]) + FORE_COLOR_POSTFIX));
            color = this.fForeColorPref.get(String.valueOf(PREF_FORE_COLOR_LIST[i]) + FORE_COLOR_POSTFIX);
            if (color != null) {
                color.dispose();
            }
            this.fForeColorPref.put(String.valueOf(PREF_FORE_COLOR_LIST[i]) + FORE_COLOR_POSTFIX, new ColorImpl(display, rgb.red, rgb.green, rgb.blue));
            ++i;
        }
        i = 0;
        while (i < PREF_TEXT_COLOR_LIST.length) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_TEXT_COLOR_LIST[i]) + TEXT_COLOR_POSTFIX));
            color = this.fTextColorPref.get(String.valueOf(PREF_TEXT_COLOR_LIST[i]) + TEXT_COLOR_POSTFIX);
            if (color != null) {
                color.dispose();
            }
            this.fTextColorPref.put(String.valueOf(PREF_TEXT_COLOR_LIST[i]) + TEXT_COLOR_POSTFIX, new ColorImpl(display, rgb.red, rgb.green, rgb.blue));
            ++i;
        }
        RGB rgb2 = PreferenceConverter.getColor((IPreferenceStore)this.fPrefStore, (String)"PREF_TIME_COMP");
        if (this.fTimeCompressionSelectionColor != null) {
            this.fTimeCompressionSelectionColor.dispose();
        }
        this.fTimeCompressionSelectionColor = new ColorImpl(display, rgb2.red, rgb2.green, rgb2.blue);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fPrefStore.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fPrefStore.removePropertyChangeListener(listener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!event.getProperty().equals("PREFOK")) {
            this.buildFontsAndColors();
            this.fPrefStore.firePropertyChangeEvent("PREFOK", null, null);
        }
    }

    public void setNoFocusSelection(boolean v) {
        this.fNoFocusSelection = v;
    }

    protected Map<String, IFont> getFontPref() {
        return Collections.unmodifiableMap(this.fFontPref);
    }

    public Map<String, IColor> getForeColorPref() {
        return Collections.unmodifiableMap(this.fForeColorPref);
    }

    public Map<String, IColor> getBackColorPref() {
        return Collections.unmodifiableMap(this.fBackColorPref);
    }

    public Map<String, IColor> getTextColorPref() {
        return Collections.unmodifiableMap(this.fTextColorPref);
    }

    public IPreferenceStore getPrefStore() {
        return this.fPrefStore;
    }

    public boolean isNoFocusSelection() {
        return this.fNoFocusSelection;
    }

    public static String[] getFontList() {
        return Arrays.copyOf(FONT_LIST, FONT_LIST.length);
    }

    public static String[] getFontList2() {
        return Arrays.copyOf(FONT_LIST2, FONT_LIST2.length);
    }

    public static String[] getPrefBackColorList() {
        return Arrays.copyOf(PREF_BACK_COLOR_LIST, PREF_BACK_COLOR_LIST.length);
    }

    public static String[] getPrefForeColorList() {
        return Arrays.copyOf(PREF_FORE_COLOR_LIST, PREF_FORE_COLOR_LIST.length);
    }

    public static String[] getPrefTextColorList() {
        return Arrays.copyOf(PREF_TEXT_COLOR_LIST, PREF_TEXT_COLOR_LIST.length);
    }
}

