/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.core.runtime.CoreException;

public final class CompositeValue
implements IValue {
    private final ICPPEvaluation evaluation;
    private final ICPPEvaluation[] values;
    private static final ThreadLocal<Set<ICPPClassType>> fCreateInProgress = new ThreadLocal<Set<ICPPClassType>>(){

        @Override
        protected Set<ICPPClassType> initialValue() {
            return new HashSet<ICPPClassType>();
        }
    };

    public CompositeValue(ICPPEvaluation evaluation, ICPPEvaluation[] values) {
        this.evaluation = evaluation;
        int i = 0;
        while (i < values.length) {
            if (values[i] == null) {
                values[i] = EvalFixed.INCOMPLETE;
            }
            ++i;
        }
        this.values = values;
    }

    @Override
    public Long numericalValue() {
        return null;
    }

    @Override
    public Number numberValue() {
        return null;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        return this.evaluation;
    }

    @Override
    public char[] getSignature() {
        if (this.evaluation != null) {
            return this.evaluation.getSignature();
        }
        return new char[0];
    }

    @Override
    @Deprecated
    public char[] getInternalExpression() {
        return CharArrayUtils.EMPTY_CHAR_ARRAY;
    }

    @Override
    @Deprecated
    public IBinding[] getUnknownBindings() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public int numberOfSubValues() {
        return this.values.length;
    }

    @Override
    public ICPPEvaluation getSubValue(int index) {
        return this.rangeIsValid(index) ? this.values[index] : EvalFixed.INCOMPLETE;
    }

    private boolean rangeIsValid(int index) {
        return index >= 0 && index < this.values.length;
    }

    public static IValue create(EvalInitList initList) {
        ICPPEvaluation[] clauses = initList.getClauses();
        ICPPEvaluation[] values = new ICPPEvaluation[clauses.length];
        int i = 0;
        while (i < clauses.length) {
            ICPPEvaluation eval = clauses[i];
            values[i] = new EvalFixed(eval.getType(null), eval.getValueCategory(null), eval.getValue(null));
            ++i;
        }
        return new CompositeValue(initList, values);
    }

    public static IValue create(EvalInitList initList, IArrayType type, IASTNode point) {
        Number arraySize = type.getSize().numberValue();
        if (arraySize == null) {
            return IntegralValue.UNKNOWN;
        }
        if (arraySize.intValue() < initList.getClauses().length) {
            return IntegralValue.ERROR;
        }
        IType elementType = type.getType();
        ICPPEvaluation[] values = new ICPPEvaluation[arraySize.intValue()];
        int i = 0;
        while (i < initList.getClauses().length) {
            ICPPEvaluation eval = initList.getClauses()[i];
            IValue value = CompositeValue.getValue(elementType, eval, point);
            values[i] = new EvalFixed(elementType, eval.getValueCategory(point), value);
            ++i;
        }
        return new CompositeValue(initList, values);
    }

    private static IValue getValue(IType type, ICPPEvaluation eval, IASTNode point) {
        IValue value = type instanceof IArrayType && eval instanceof EvalInitList ? CompositeValue.create((EvalInitList)eval, (IArrayType)type, point) : (type instanceof ICompositeType && eval instanceof EvalInitList ? CompositeValue.create((EvalInitList)eval, (ICompositeType)type, point) : (eval instanceof EvalInitList ? IntegralValue.UNKNOWN : eval.getValue(null)));
        return value;
    }

    public static IValue create(EvalInitList initList, ICompositeType type, IASTNode point) {
        IField[] fields = type instanceof ICPPClassType ? ClassTypeHelper.getFields((ICPPClassType)type, point) : type.getFields();
        ICPPEvaluation[] values = new ICPPEvaluation[fields.length];
        ICPPEvaluation[] clauses = initList.getClauses();
        int i = 0;
        while (i < fields.length) {
            if (i == clauses.length) break;
            IField field = fields[i];
            ICPPEvaluation eval = clauses[i];
            IType fieldType = field.getType();
            IValue value = CompositeValue.getValue(fieldType, eval, point);
            values[i] = new EvalFixed(fieldType, eval.getValueCategory(null), value);
            ++i;
        }
        return new CompositeValue(initList, values);
    }

    public static CompositeValue create(ICPPClassType classType) {
        Set<ICPPClassType> recursionProtectionSet = fCreateInProgress.get();
        if (!recursionProtectionSet.add(classType)) {
            return new CompositeValue(null, ICPPEvaluation.EMPTY_ARRAY);
        }
        try {
            ICPPField[] fields;
            ICPPBase[] bases;
            ActivationRecord record = new ActivationRecord();
            ICPPEvaluation[] values = new ICPPEvaluation[ClassTypeHelper.getFields(classType, null).length];
            ICPPBase[] iCPPBaseArray = bases = ClassTypeHelper.getBases(classType, null);
            int n = bases.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase base = iCPPBaseArray[n2];
                IBinding baseClass = base.getBaseClass();
                if (baseClass instanceof ICPPClassType) {
                    ICPPClassType baseClassType = (ICPPClassType)baseClass;
                    ICPPField[] baseFields = ClassTypeHelper.getDeclaredFields(baseClassType, null);
                    CompositeValue compValue = CompositeValue.create(baseClassType);
                    ICPPField[] iCPPFieldArray = baseFields;
                    int n3 = baseFields.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICPPField baseField = iCPPFieldArray[n4];
                        int fieldPos = CPPASTFieldReference.getFieldPosition(baseField);
                        if (fieldPos != -1) {
                            record.update(baseField, compValue.getSubValue(fieldPos));
                            values[fieldPos] = compValue.getSubValue(fieldPos);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            ICPPField[] iCPPFieldArray = fields = ClassTypeHelper.getDeclaredFields(classType, null);
            int n5 = fields.length;
            n = 0;
            while (n < n5) {
                ICPPField field = iCPPFieldArray[n];
                if (!field.isStatic()) {
                    ICPPEvaluation value = EvalUtil.getVariableValue(field, record);
                    int fieldPos = CPPASTFieldReference.getFieldPosition(field);
                    if (fieldPos != -1) {
                        record.update(field, value);
                        values[fieldPos] = value;
                    }
                }
                ++n;
            }
            CompositeValue compositeValue = new CompositeValue(null, values);
            return compositeValue;
        }
        finally {
            recursionProtectionSet.remove(classType);
        }
    }

    @Override
    public ICPPEvaluation[] getAllSubValues() {
        return this.values;
    }

    @Override
    public void setSubValue(int position, ICPPEvaluation newValue) {
        if (position >= 0 && position < this.values.length) {
            this.values[position] = newValue == null ? EvalFixed.INCOMPLETE : newValue;
        } else {
            CCorePlugin.log(2, "Out-of-bounds access to composite value: " + position + " (length is " + this.values.length + ")");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        int i = 0;
        while (i < this.values.length) {
            if (i != 0) {
                builder.append(',').append(' ');
            }
            builder.append(this.values[i].toString());
            ++i;
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public IValue clone() {
        ICPPEvaluation[] newValues = new ICPPEvaluation[this.values.length];
        int i = 0;
        while (i < newValues.length) {
            ICPPEvaluation eval = this.values[i];
            if (eval == EvalFixed.INCOMPLETE) {
                newValues[i] = eval;
            } else {
                IValue newValue = eval.getValue(null).clone();
                newValues[i] = new EvalFixed(eval.getType(null), eval.getValueCategory(null), newValue);
            }
            ++i;
        }
        return new CompositeValue(this.evaluation, newValues);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buf) throws CoreException {
        buf.putShort((short)4);
        buf.marshalEvaluation(this.evaluation, true);
        buf.putInt(this.values.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation value = iCPPEvaluationArray[n2];
            buf.marshalEvaluation(value, true);
            ++n2;
        }
    }

    public static IValue unmarshal(short firstBytes, ITypeMarshalBuffer buf) throws CoreException {
        ICPPEvaluation evaluation = (ICPPEvaluation)buf.unmarshalEvaluation();
        int len = buf.getInt();
        ICPPEvaluation[] values = new ICPPEvaluation[len];
        int i = 0;
        while (i < len) {
            values[i] = (ICPPEvaluation)buf.unmarshalEvaluation();
            ++i;
        }
        return new CompositeValue(evaluation, values);
    }
}

