/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.registry.LinuxStyle;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class ResourcesPresentationProvider
extends TimeGraphPresentationProvider {
    private Color fColorWhite;
    private Color fColorGray;
    private Integer fAverageCharWidth;
    private static final int NUM_COLORS = 25;
    private static final float BRIGHTNESS = 0.8f;
    private static final float SATURATION = 0.8f;
    private static final int COLOR_DIFFERENCIATION_FACTOR = 14;
    private static final int IDLE_THREAD = 0;
    private static final Map<Integer, StateItem> STATE_MAP;
    private static final List<StateItem> STATE_LIST;
    private static final StateItem[] STATE_TABLE;
    private final List<RGB> fColors = new ArrayList<RGB>();

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)0, (Object)new StateItem(LinuxStyle.IDLE.toMap()));
        builder.put((Object)2, (Object)new StateItem(LinuxStyle.USERMODE.toMap()));
        builder.put((Object)4, (Object)new StateItem(LinuxStyle.SYSCALL.toMap()));
        builder.put((Object)16, (Object)ResourcesPresentationProvider.createState(LinuxStyle.INTERRUPTED));
        builder.put((Object)8, (Object)ResourcesPresentationProvider.createState(LinuxStyle.SOFT_IRQ));
        builder.put((Object)1, (Object)ResourcesPresentationProvider.createState(LinuxStyle.SOFT_IRQ_RAISED));
        STATE_MAP = builder.build();
        STATE_LIST = ImmutableList.copyOf(STATE_MAP.values());
        STATE_TABLE = STATE_LIST.toArray(new StateItem[STATE_LIST.size()]);
    }

    private static StateItem createState(LinuxStyle style) {
        return new StateItem(style.toMap());
    }

    public ResourcesPresentationProvider() {
        int i = 0;
        while (i < 25) {
            this.fColors.add(new RGB((float)((int)(14.4 * (double)i)), 0.8f, 0.8f));
            ++i;
        }
    }

    private static StateItem getEventState(TimeEvent event) {
        if (event instanceof NullTimeEvent) {
            return null;
        }
        ITimeGraphEntry entry = event.getEntry();
        if (entry instanceof TimeGraphEntry && ((TimeGraphEntry)entry).getModel() instanceof ResourcesEntryModel) {
            int value = event.getValue();
            ResourcesEntryModel resourcesModel = (ResourcesEntryModel)((TimeGraphEntry)entry).getModel();
            ResourcesEntryModel.Type type = resourcesModel.getType();
            switch (type) {
                case CPU: {
                    return STATE_MAP.get(value);
                }
                case IRQ: {
                    return STATE_MAP.get(16);
                }
                case SOFT_IRQ: {
                    if (value == 1) {
                        return STATE_MAP.get(1);
                    }
                    return STATE_MAP.get(8);
                }
                case CURRENT_THREAD: {
                    if (!event.hasValue()) {
                        return null;
                    }
                    return STATE_MAP.get(2);
                }
                case TRACE: {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public int getStateTableIndex(ITimeEvent event) {
        StateItem state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return STATE_LIST.indexOf(state);
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public String getEventName(ITimeEvent event) {
        StateItem state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.getStateString();
        }
        if (event instanceof NullTimeEvent || ResourcesPresentationProvider.isType(event.getEntry(), ResourcesEntryModel.Type.CURRENT_THREAD)) {
            return null;
        }
        return Messages.ResourcesView_multipleStates;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        ITimeGraphEntry entry = event.getEntry();
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue() && entry instanceof TimeGraphEntry) {
            ITimeGraphEntryModel model = ((TimeGraphEntry)entry).getModel();
            TimeEvent tcEvent = (TimeEvent)event;
            if (tcEvent.hasValue() && model instanceof ResourcesEntryModel) {
                ResourcesEntryModel resourcesModel = (ResourcesEntryModel)model;
                if (resourcesModel.getType().equals((Object)ResourcesEntryModel.Type.IRQ) || resourcesModel.getType().equals((Object)ResourcesEntryModel.Type.SOFT_IRQ)) {
                    int cpu = tcEvent.getValue();
                    if (cpu >= 0) {
                        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>(1);
                        retMap.put(Messages.ResourcesView_attributeCpuName, String.valueOf(cpu));
                        return retMap;
                    }
                } else if (resourcesModel.getType().equals((Object)ResourcesEntryModel.Type.CPU) || resourcesModel.getType().equals((Object)ResourcesEntryModel.Type.CURRENT_THREAD)) {
                    int status = tcEvent.getValue();
                    ITimeGraphDataProvider provider = BaseDataProviderTimeGraphView.getProvider((TimeGraphEntry)((TimeGraphEntry)entry));
                    if (provider != null) {
                        return ResourcesPresentationProvider.getTooltipForCpu((ITimeGraphDataProvider<? extends TimeGraphEntryModel>)provider, model.getId(), hoverTime, status);
                    }
                }
            }
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> getTooltipForCpu(ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider, long id, long hoverTime, int status) {
        SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(Collections.singletonList(hoverTime), Collections.singleton(id));
        TmfModelResponse response = provider.fetchTooltip(filter, null);
        Map tooltip = (Map)response.getModel();
        if (tooltip == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (status == 16) {
            String irq = (String)tooltip.get("IRQs");
            if (irq != null) {
                retMap.put(Messages.ResourcesView_attributeIrqName, irq);
            }
        } else if (status == 8) {
            String irq = (String)tooltip.get("Soft_IRQs");
            if (irq != null) {
                retMap.put(Messages.ResourcesView_attributeSoftIrqName, irq);
            }
        } else if (status == 2 || status == 4 || status > 16) {
            String syscallName;
            String execName;
            retMap.put(Messages.ResourcesView_attributeHoverTime, FormatTimeUtils.formatTime((long)hoverTime, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.CALENDAR, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC));
            String tidName = (String)tooltip.get("Current_thread");
            if (tidName != null) {
                retMap.put(Messages.ResourcesView_attributeTidName, tidName);
            }
            if ((execName = (String)tooltip.get("Exec_name")) != null) {
                retMap.put(Messages.ResourcesView_attributeProcessName, execName);
            }
            if ((syscallName = (String)tooltip.get("System_call")) != null) {
                retMap.put(Messages.ResourcesView_attributeSyscallName, syscallName);
            }
        }
        return retMap;
    }

    @Deprecated
    private static int getAverageCharWidth(GC gc) {
        return gc.getFontMetrics().getAverageCharWidth();
    }

    public Map<String, Object> getSpecificEventStyle(ITimeEvent event) {
        if (ResourcesPresentationProvider.isType(event.getEntry(), ResourcesEntryModel.Type.CURRENT_THREAD) && event instanceof TimeEvent) {
            int threadEventValue = ((TimeEvent)event).getValue();
            if (threadEventValue == 0) {
                return ImmutableMap.of((Object)ITimeEventStyleStrings.fillColor(), (Object)0);
            }
            RGB color = this.fColors.get(((threadEventValue + 14) % 25 + 25) % 25);
            return ImmutableMap.of((Object)ITimeEventStyleStrings.fillColor(), (Object)(color.red << 24 | color.green << 16 | color.blue << 8 | 0xFF), (Object)ITimeEventStyleStrings.label(), (Object)String.valueOf(threadEventValue));
        }
        return super.getSpecificEventStyle(event);
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (this.fColorGray == null) {
            this.fColorGray = gc.getDevice().getSystemColor(15);
        }
        if (this.fColorWhite == null) {
            this.fColorWhite = gc.getDevice().getSystemColor(1);
        }
        if (this.fAverageCharWidth == null) {
            this.fAverageCharWidth = ResourcesPresentationProvider.getAverageCharWidth(gc);
        }
        if (bounds.width <= this.fAverageCharWidth || !(event instanceof NamedTimeEvent)) {
            return;
        }
        NamedTimeEvent tcEvent = (NamedTimeEvent)event;
        gc.setForeground(this.fColorWhite);
        String label = tcEvent.getLabel();
        Utils.drawText((GC)gc, (String)label, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
        gc.setForeground(this.fColorGray);
    }

    private static boolean isType(ITimeGraphEntry entry, ResourcesEntryModel.Type type) {
        ITimeGraphEntryModel model;
        if (entry instanceof TimeGraphEntry && (model = ((TimeGraphEntry)entry).getModel()) instanceof ResourcesEntryModel) {
            return ((ResourcesEntryModel)model).getType().equals((Object)type);
        }
        return false;
    }
}

