/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class CriticalPathPresentationProvider
extends TimeGraphPresentationProvider {
    public static final int NETWORK_ARROW_INDEX;
    public static final int UNKNOWN_ARROW_INDEX;
    private static final StateItem[] STATE_TABLE;

    static {
        int networkArrowIndex = -1;
        int unknownNetworkIndex = -1;
        STATE_TABLE = new StateItem[State.values().length];
        int i = 0;
        while (i < STATE_TABLE.length) {
            State state = State.values()[i];
            float heightFactor = 1.0f;
            if (state.equals((Object)State.NETWORK_ARROW)) {
                networkArrowIndex = i;
                heightFactor = 0.1f;
            } else if (state.equals((Object)State.UNKNOWN_ARROW)) {
                unknownNetworkIndex = i;
                heightFactor = 0.1f;
            }
            RGB stateColor = state.rgb;
            String stateType = state.equals((Object)State.NETWORK_ARROW) || state.equals((Object)State.UNKNOWN_ARROW) ? ITimeEventStyleStrings.linkType() : ITimeEventStyleStrings.stateType();
            ImmutableMap styleMap = ImmutableMap.of((Object)ITimeEventStyleStrings.fillStyle(), (Object)ITimeEventStyleStrings.solidColorFillStyle(), (Object)ITimeEventStyleStrings.fillColor(), (Object)new RGBAColor(stateColor.red, stateColor.green, stateColor.blue).toInt(), (Object)ITimeEventStyleStrings.label(), (Object)String.valueOf(state.toString()), (Object)ITimeEventStyleStrings.heightFactor(), (Object)Float.valueOf(heightFactor), (Object)ITimeEventStyleStrings.itemTypeProperty(), (Object)stateType);
            CriticalPathPresentationProvider.STATE_TABLE[i] = new StateItem((Map)styleMap);
            ++i;
        }
        NETWORK_ARROW_INDEX = networkArrowIndex;
        UNKNOWN_ARROW_INDEX = unknownNetworkIndex;
    }

    public String getStateTypeName() {
        return Messages.getMessage(Messages.CriticalFlowView_stateTypeName);
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public int getStateTableIndex(@Nullable ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            int value = ((TimeEvent)event).getValue();
            if (event instanceof ILinkEvent) {
                return this.getStateTable()[value].getStateString().equals(State.NETWORK.toString()) ? NETWORK_ARROW_INDEX : UNKNOWN_ARROW_INDEX;
            }
            return value;
        }
        return -2;
    }

    private static State getMatchingState(int status) {
        switch (status) {
            case 0: {
                return State.RUNNING;
            }
            case 1: {
                return State.INTERRUPTED;
            }
            case 2: {
                return State.PREEMPTED;
            }
            case 3: {
                return State.TIMER;
            }
            case 4: {
                return State.BLOCK_DEVICE;
            }
            case 5: {
                return State.USER_INPUT;
            }
            case 6: {
                return State.NETWORK;
            }
            case 7: {
                return State.IPI;
            }
        }
        return State.UNKNOWN;
    }

    public String getEventName(@Nullable ITimeEvent event) {
        TimeEvent ev;
        if (event instanceof TimeEvent && (ev = (TimeEvent)event).hasValue()) {
            return NonNullUtils.nullToEmptyString((Object)((Object)CriticalPathPresentationProvider.getMatchingState(ev.getValue())));
        }
        return Messages.getMessage(Messages.CriticalFlowView_multipleStates);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        ITimeGraphEntry entry;
        LinkedHashMap<String, String> eventHoverToolTipInfo = super.getEventHoverToolTipInfo(event, hoverTime);
        if (eventHoverToolTipInfo == null) {
            eventHoverToolTipInfo = new LinkedHashMap<String, String>();
        }
        if ((entry = event.getEntry()) instanceof TimeGraphEntry) {
            SelectionTimeQueryFilter filter;
            long id = ((TimeGraphEntry)entry).getModel().getId();
            ITimeGraphDataProvider provider = BaseDataProviderTimeGraphView.getProvider((TimeGraphEntry)((TimeGraphEntry)entry));
            @NonNull @NonNull @NonNull TmfModelResponse tooltipResponse = provider.fetchTooltip(filter = new SelectionTimeQueryFilter(Collections.singletonList(hoverTime), Collections.singleton(id)), null);
            @NonNull @NonNull Map tooltipModel = (Map)tooltipResponse.getModel();
            if (tooltipModel != null) {
                eventHoverToolTipInfo.putAll(tooltipModel);
            }
        }
        return eventHoverToolTipInfo;
    }

    public static enum State {
        RUNNING(new RGB(51, 153, 0)),
        INTERRUPTED(new RGB(255, 220, 0)),
        PREEMPTED(new RGB(200, 100, 0)),
        TIMER(new RGB(51, 102, 153)),
        BLOCK_DEVICE(new RGB(102, 0, 204)),
        USER_INPUT(new RGB(90, 1, 1)),
        NETWORK(new RGB(255, 155, 255)),
        IPI(new RGB(102, 102, 204)),
        UNKNOWN(new RGB(64, 59, 51)),
        NETWORK_ARROW(new RGB(255, 155, 255)),
        UNKNOWN_ARROW(new RGB(64, 59, 51));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

