/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.latency;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.AbstractSegmentStoreAnalysisEventBasedModule;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.SystemCall;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SystemCallLatencyAnalysis
extends AbstractSegmentStoreAnalysisEventBasedModule {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.latency.syscall";
    private static final Collection<ISegmentAspect> BASE_ASPECTS = ImmutableList.of((Object)SyscallNameAspect.INSTANCE);

    public String getId() {
        return ID;
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new IllegalStateException();
        }
        IAnalysisModule module = trace.getAnalysisModule("org.eclipse.tracecompass.analysis.os.linux.kernel.tid");
        if (module == null) {
            return Collections.EMPTY_SET;
        }
        return ImmutableSet.of((Object)module);
    }

    public Iterable<ISegmentAspect> getSegmentAspects() {
        return BASE_ASPECTS;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SegmentStoreFactory.SegmentStoreType getSegmentStoreType() {
        return SegmentStoreFactory.SegmentStoreType.OnDisk;
    }

    protected AbstractSegmentStoreAnalysisEventBasedModule.AbstractSegmentStoreAnalysisRequest createAnalysisRequest(ISegmentStore<ISegment> syscalls, IProgressMonitor monitor) {
        return new SyscallLatencyAnalysisRequest(syscalls, monitor);
    }

    protected @NonNull IHTIntervalReader<ISegment> getSegmentReader() {
        return SystemCall.READER;
    }

    @Deprecated
    protected Object[] readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        return (Object[])NonNullUtils.checkNotNull((Object)((Object[])ois.readObject()));
    }

    private class SyscallLatencyAnalysisRequest
    extends AbstractSegmentStoreAnalysisEventBasedModule.AbstractSegmentStoreAnalysisRequest {
        private final Map<Integer, SystemCall.InitialInfo> fOngoingSystemCalls;
        private @Nullable IKernelAnalysisEventLayout fLayout;
        private final IProgressMonitor fMonitor;

        public SyscallLatencyAnalysisRequest(ISegmentStore<ISegment> syscalls, IProgressMonitor monitor) {
            super((AbstractSegmentStoreAnalysisEventBasedModule)SystemCallLatencyAnalysis.this, syscalls);
            this.fOngoingSystemCalls = new HashMap<Integer, SystemCall.InitialInfo>();
            this.fMonitor = monitor;
        }

        public void handleData(ITmfEvent event) {
            String eventName;
            super.handleData(event);
            IKernelAnalysisEventLayout layout = this.fLayout;
            if (layout == null) {
                IKernelTrace trace = (IKernelTrace)event.getTrace();
                this.fLayout = layout = trace.getKernelEventLayout();
            }
            if ((eventName = event.getName()).startsWith(layout.eventSyscallEntryPrefix()) || eventName.startsWith(layout.eventCompatSyscallEntryPrefix())) {
                Integer tid;
                try {
                    tid = KernelTidAspect.INSTANCE.resolve(event, true, this.fMonitor);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (tid == null) {
                    return;
                }
                long startTime = event.getTimestamp().toNanos();
                String syscallName = eventName.substring(layout.eventSyscallEntryPrefix().length());
                SystemCall.InitialInfo newSysCall = new SystemCall.InitialInfo(startTime, syscallName.intern());
                this.fOngoingSystemCalls.put(tid, newSysCall);
            } else if (eventName.startsWith(layout.eventSyscallExitPrefix())) {
                Integer tid;
                try {
                    tid = KernelTidAspect.INSTANCE.resolve(event, true, this.fMonitor);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (tid == null) {
                    return;
                }
                SystemCall.InitialInfo info = this.fOngoingSystemCalls.remove(tid);
                if (info == null) {
                    return;
                }
                long endTime = event.getTimestamp().toNanos();
                SystemCall syscall = new SystemCall(info, endTime);
                this.getSegmentStore().add((Object)syscall);
            }
        }

        public void handleCompleted() {
            this.fOngoingSystemCalls.clear();
            super.handleCompleted();
        }

        public void handleCancel() {
            this.fMonitor.setCanceled(true);
            super.handleCancel();
        }
    }

    private static final class SyscallNameAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new SyscallNameAspect();

        private SyscallNameAspect() {
        }

        public String getHelpText() {
            return (String)NonNullUtils.checkNotNull((Object)Messages.SegmentAspectHelpText_SystemCall);
        }

        public String getName() {
            return (String)NonNullUtils.checkNotNull((Object)Messages.SegmentAspectName_SystemCall);
        }

        public @Nullable Comparator<?> getComparator() {
            return null;
        }

        public @Nullable String resolve(ISegment segment) {
            if (segment instanceof SystemCall) {
                return ((SystemCall)segment).getName();
            }
            return "";
        }
    }
}

