/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.statesystem;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.views.statesystem.Messages;
import org.eclipse.tracecompass.tmf.ui.views.statesystem.StateSystemEvent;
import org.eclipse.tracecompass.tmf.ui.views.statesystem.StateSystemPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.PlatformUI;

public class TmfStateSystemExplorer
extends AbstractTimeGraphView {
    private static final String HT_EXTENSION = ".ht";
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.ssvisualizer";
    private static final Image FILTER_IMAGE = Activator.getDefault().getImageFromPath(String.valueOf(File.separator) + "icons" + File.separator + "elcl16" + File.separator + "filter_items.gif");
    private static final Image COLLAPSE_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_COLLAPSEALL");
    private static final Image EXPAND_IMAGE = Activator.getDefault().getImageFromPath(String.valueOf(File.separator) + "icons" + File.separator + "elcl16" + File.separator + "expandall.gif");
    private static final String[] COLUMN_NAMES = new String[]{Messages.TreeNodeColumnLabel, Messages.QuarkColumnLabel, Messages.ValueColumnLabel};
    private static final Comparator<ITimeGraphEntry> NAME_COMPARATOR = (a, b) -> {
        if (a instanceof TraceEntry && b instanceof TraceEntry) {
            ITmfTrace ta = ((TraceEntry)a).fEntryTrace;
            ITmfTrace tb = ((TraceEntry)b).fEntryTrace;
            if (ta instanceof TmfExperiment && !(tb instanceof TmfExperiment)) {
                return -1;
            }
            if (!(ta instanceof TmfExperiment) && tb instanceof TmfExperiment) {
                return 1;
            }
        }
        try {
            return Long.compare(Long.parseLong(a.getName()), Long.parseLong(b.getName()));
        }
        catch (NumberFormatException numberFormatException) {
            return a.getName().compareTo(b.getName());
        }
    };
    private static final Comparator<ITimeGraphEntry> QUARK_COMPARATOR = (a, b) -> {
        if (a instanceof AttributeEntry && b instanceof AttributeEntry) {
            return Integer.compare(((AttributeEntry)a).getQuark(), ((AttributeEntry)b).getQuark());
        }
        return 0;
    };
    private static final Comparator<ITimeGraphEntry>[] COLUMN_COMPARATORS;
    private static final int NAME_COLUMN_INDEX = 0;
    private static final int ITERATION_WAIT = 500;
    private static final int DEFAULT_AUTOEXPAND = 2;
    private final Set<ITmfAnalysisModuleWithStateSystems> fStartedAnalysis = ConcurrentHashMap.newKeySet();

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(NAME_COMPARATOR).add(QUARK_COMPARATOR);
        ImmutableList l = builder.build();
        COLUMN_COMPARATORS = l.toArray(new Comparator[l.size()]);
    }

    public TmfStateSystemExplorer() {
        super(ID, new StateSystemPresentationProvider());
        this.setTreeColumns(COLUMN_NAMES, COLUMN_COMPARATORS, 0);
        this.setTreeLabelProvider(new StateSystemTreeLabelProvider());
        this.setAutoExpandLevel(2);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.appendToGroup("additions", (IAction)new CollapseAction(Messages.CollapseButton));
        manager.appendToGroup("additions", (IAction)new ExpandAction(Messages.ExpandButton));
        manager.appendToGroup("additions", (IAction)new FilterAction(Messages.FilterButton));
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getResetScaleAction());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getPreviousEventAction());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getNextEventAction());
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getTimeGraphViewer().addTimeListener(event -> this.synchingToTime(event.getBeginTime()));
        this.getTimeGraphViewer().getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                boolean expandedState;
                TimeGraphControl control;
                ITimeGraphEntry selection = TmfStateSystemExplorer.this.getTimeGraphViewer().getSelection();
                if (selection instanceof ModuleEntry && selection.getChildren().isEmpty()) {
                    ITmfAnalysisModuleWithStateSystems module = ((ModuleEntry)selection).fModule;
                    module.schedule();
                }
                control.setExpandedState(selection, !(expandedState = (control = TmfStateSystemExplorer.this.getTimeGraphViewer().getTimeGraphControl()).getExpandedState(selection)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void buildEntryList(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, @NonNull IProgressMonitor monitor) {
        long start;
        Set<ITmfAnalysisModuleWithStateSystems> set = this.fStartedAnalysis;
        synchronized (set) {
            if (monitor.isCanceled()) {
                return;
            }
        }
        long end = start = trace.getStartTime().toNanos();
        TraceEntry traceEntry = new TraceEntry(trace);
        this.addToEntryList(parentTrace, Collections.singletonList(traceEntry));
        @NonNull Iterable modules = Iterables.filter((Iterable)trace.getAnalysisModules(), ITmfAnalysisModuleWithStateSystems.class);
        for (ITmfAnalysisModuleWithStateSystems m : modules) {
            if (monitor.isCanceled()) {
                return;
            }
            this.waitForInitialization(trace, m);
        }
        boolean complete = false;
        while (!complete && !monitor.isCanceled()) {
            complete = true;
            for (ITmfAnalysisModuleWithStateSystems module : modules) {
                if (monitor.isCanceled()) {
                    return;
                }
                ModuleEntry moduleEntry = TmfStateSystemExplorer.getOrCreateModuleEntry(traceEntry, module);
                for (ITmfStateSystem ss : module.getStateSystems()) {
                    complete &= ss.waitUntilBuilt(0L);
                    end = Long.max(end, ss.getCurrentEndTime());
                    TmfStateSystemExplorer.getOrCreateStateSystemEntry(moduleEntry, ss);
                }
            }
            traceEntry.updateEndTime(end);
            long resolution = Long.max(1L, (end - start) / (long)this.getDisplayWidth());
            this.zoomEntries(Utils.flatten(traceEntry), start, end, resolution, monitor);
            long selectionStart = TmfTraceManager.getInstance().getTraceContext(trace).getSelectionRange().getStartTime().toNanos();
            TmfStateSystemExplorer.updateFullstates(selectionStart, Collections.singletonList(traceEntry));
            if (monitor.isCanceled()) {
                return;
            }
            if (parentTrace == this.getTrace()) {
                TmfStateSystemExplorer tmfStateSystemExplorer = this;
                synchronized (tmfStateSystemExplorer) {
                    this.setStartTime(Long.min(this.getStartTime(), start));
                    this.setEndTime(Long.max(this.getEndTime(), end));
                }
                this.refresh();
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (complete) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError("Failed to wait", e);
            }
        }
    }

    private void waitForInitialization(@NonNull ITmfTrace trace, ITmfAnalysisModuleWithStateSystems module) {
        if (module.isAutomatic() || this.fStartedAnalysis.remove(module)) {
            module.waitForInitialization();
            return;
        }
        String dir = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        boolean exists = Paths.get(dir, String.valueOf(module.getId()) + HT_EXTENSION).toFile().exists();
        if (exists) {
            module.schedule();
            module.waitForInitialization();
        }
    }

    private static ModuleEntry getOrCreateModuleEntry(TraceEntry traceEntry, ITmfAnalysisModuleWithStateSystems module) {
        ModuleEntry moduleEntry = null;
        for (ModuleEntry entry : Iterables.filter(traceEntry.getChildren(), ModuleEntry.class)) {
            if (!entry.getName().equals(module.getName())) continue;
            moduleEntry = entry;
            break;
        }
        if (moduleEntry == null) {
            moduleEntry = new ModuleEntry(module, traceEntry.getStartTime());
            traceEntry.addChild(moduleEntry);
        }
        return moduleEntry;
    }

    private static StateSystemEntry getOrCreateStateSystemEntry(ModuleEntry moduleEntry, ITmfStateSystem ss) {
        StateSystemEntry ssEntry = null;
        long currentEndTime = ss.getCurrentEndTime();
        for (StateSystemEntry entry : Iterables.filter(moduleEntry.getChildren(), StateSystemEntry.class)) {
            if (entry.getStateSystem() != ss) continue;
            ssEntry = entry;
            ssEntry.updateEndTime(currentEndTime);
            break;
        }
        if (ssEntry == null) {
            ssEntry = new StateSystemEntry(ss);
            moduleEntry.addChild(ssEntry);
        }
        moduleEntry.updateEndTime(currentEndTime);
        for (Integer q : ssEntry.fSs.getSubAttributes(-1, false)) {
            TmfStateSystemExplorer.getOrCreateAttributes(ssEntry, ssEntry.fSs, q, currentEndTime);
        }
        return ssEntry;
    }

    private static TimeGraphEntry getOrCreateAttributes(TimeGraphEntry parent, ITmfStateSystem ss, int quark, long end) {
        long start = ss.getStartTime();
        String name = ss.getAttributeName(quark);
        TimeGraphEntry entry = null;
        for (TimeGraphEntry e : parent.getChildren()) {
            if (!name.equals(e.getName())) continue;
            entry = e;
            entry.updateEndTime(end);
            break;
        }
        if (entry == null) {
            entry = new AttributeEntry(name, start, end, quark);
            parent.addChild(entry);
        }
        for (Integer child : ss.getSubAttributes(quark, false)) {
            TmfStateSystemExplorer.getOrCreateAttributes(entry, ss, child, end);
        }
        return entry;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Table<ITmfStateSystem, Integer, TimeGraphEntry> filterGroupEntries(Iterable<TimeGraphEntry> visible) {
        HashBasedTable quarksToEntries = HashBasedTable.create();
        for (AttributeEntry entry : Iterables.filter(visible, AttributeEntry.class)) {
            ITmfStateSystem ss = TmfStateSystemExplorer.getStateSystem(entry);
            if (ss == null) continue;
            quarksToEntries.put((Object)ss, (Object)entry.getQuark(), (Object)entry);
        }
        return quarksToEntries;
    }

    private static List<ITimeEvent> createTimeEvents(TimeGraphEntry tge, SortedSet<ITmfStateInterval> intervals) {
        ArrayList<ITimeEvent> events = new ArrayList<ITimeEvent>(intervals.size());
        ITimeEvent prev = null;
        for (ITmfStateInterval interval : intervals) {
            long prevEnd;
            StateSystemEvent event = new StateSystemEvent(tge, interval);
            if (prev != null && (prevEnd = prev.getTime() + prev.getDuration()) < event.getTime()) {
                events.add(new TimeEvent(tge, prevEnd, event.getTime() - prevEnd));
            }
            prev = event;
            events.add(event);
        }
        return events;
    }

    @Override
    protected void synchingToTime(long time) {
        List<@NonNull TimeGraphEntry> traceEntries = this.getEntryList(this.getTrace());
        if (traceEntries == null) {
            return;
        }
        TmfStateSystemExplorer.updateFullstates(time, traceEntries);
        this.refresh();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void updateFullstates(long time, List<@NonNull TimeGraphEntry> traceEntries) {
        Iterable moduleEntries = Iterables.concat((Iterable)Iterables.transform(traceEntries, TimeGraphEntry::getChildren));
        Iterable stateSystemEntries = Iterables.concat((Iterable)Iterables.transform((Iterable)moduleEntries, TimeGraphEntry::getChildren));
        for (StateSystemEntry stateSystemEntry : Iterables.filter((Iterable)stateSystemEntries, StateSystemEntry.class)) {
            ITmfStateSystem ss = stateSystemEntry.getStateSystem();
            if (ss.getStartTime() <= time && time <= ss.getCurrentEndTime()) {
                try {
                    @NonNull List full = ss.queryFullState(time);
                    stateSystemEntry.setFullStates(full);
                }
                catch (StateSystemDisposedException e) {
                    stateSystemEntry.setFullStates(null);
                }
                continue;
            }
            stateSystemEntry.setFullStates(null);
        }
    }

    static ITmfStateSystem getStateSystem(TimeGraphEntry entry) {
        TimeGraphEntry parent = entry;
        while (parent != null) {
            if (!((parent = parent.getParent()) instanceof StateSystemEntry)) continue;
            return ((StateSystemEntry)parent).getStateSystem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void handleAnalysisStarted(TmfStartAnalysisSignal signal) {
        IAnalysisModule module = signal.getAnalysisModule();
        if (module instanceof ITmfAnalysisModuleWithStateSystems && !module.isAutomatic()) {
            if (Iterables.contains(TmfStateSystemExplorer.allModules(this.getTrace()), (Object)module)) {
                Set<ITmfAnalysisModuleWithStateSystems> set = this.fStartedAnalysis;
                synchronized (set) {
                    this.fStartedAnalysis.add((ITmfAnalysisModuleWithStateSystems)module);
                    this.rebuild();
                }
            } else {
                for (ITmfTrace trace : TmfTraceManager.getInstance().getOpenedTraces()) {
                    if (!Iterables.contains(TmfStateSystemExplorer.allModules(trace), (Object)module)) continue;
                    Set<ITmfAnalysisModuleWithStateSystems> set = this.fStartedAnalysis;
                    synchronized (set) {
                        this.fStartedAnalysis.add((ITmfAnalysisModuleWithStateSystems)module);
                        this.resetView(trace);
                        break;
                    }
                }
            }
        }
    }

    @Override
    protected @NonNull Iterable<ITmfTrace> getTracesToBuild(@Nullable ITmfTrace trace) {
        return TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)trace);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Iterable<ITmfAnalysisModuleWithStateSystems> allModules(ITmfTrace trace) {
        @NonNull Collection traces = TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)trace);
        Iterable allModules = Iterables.concat((Iterable)Iterables.transform((Iterable)traces, ITmfTrace::getAnalysisModules));
        return Iterables.filter((Iterable)allModules, ITmfAnalysisModuleWithStateSystems.class);
    }

    @Override
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        super.traceClosed(signal);
        for (ITmfAnalysisModuleWithStateSystems module : TmfStateSystemExplorer.allModules(signal.getTrace())) {
            this.fStartedAnalysis.remove(module);
        }
    }

    private static /* synthetic */ void lambda$3(TimeGraphEntry timeGraphEntry, List list, TimeGraphEntry.Sampling sampling) {
        timeGraphEntry.setZoomedEventList(list);
        timeGraphEntry.setSampling(sampling);
    }

    static class AttributeEntry
    extends TimeGraphEntry {
        private final int fQuark;

        public AttributeEntry(String name, long start, long end, int quark) {
            super(name, start, end);
            this.fQuark = quark;
        }

        public int getQuark() {
            return this.fQuark;
        }
    }

    private class CollapseAction
    extends Action {
        public CollapseAction(String text) {
            super(text, 1);
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)COLLAPSE_IMAGE));
            this.setToolTipText(Messages.CollapseButton);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void run() {
            TmfStateSystemExplorer.this.setAutoExpandLevel(2);
            @NonNull List traceEntries = TmfStateSystemExplorer.this.getEntryList(TmfStateSystemExplorer.this.getTrace());
            if (traceEntries == null) {
                return;
            }
            TimeGraphControl control = TmfStateSystemExplorer.this.getTimeGraphViewer().getTimeGraphControl();
            for (TimeGraphEntry traceEntry : traceEntries) {
                for (TimeGraphEntry moduleEntry : traceEntry.getChildren()) {
                    for (TimeGraphEntry stateSystemEntry : moduleEntry.getChildren()) {
                        Utils.flatten(stateSystemEntry).forEach(attribute -> control.setExpandedState((ITimeGraphEntry)attribute, false));
                    }
                }
            }
            TmfStateSystemExplorer.this.redraw();
        }
    }

    private class ExpandAction
    extends Action {
        public ExpandAction(String text) {
            super(text, 1);
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)EXPAND_IMAGE));
            this.setToolTipText(Messages.ExpandButton);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void run() {
            TmfStateSystemExplorer.this.setAutoExpandLevel(-1);
            @NonNull List traceEntries = TmfStateSystemExplorer.this.getEntryList(TmfStateSystemExplorer.this.getTrace());
            if (traceEntries == null) {
                return;
            }
            TimeGraphControl control = TmfStateSystemExplorer.this.getTimeGraphViewer().getTimeGraphControl();
            Iterables.concat((Iterable)Iterables.transform((Iterable)traceEntries, Utils::flatten)).forEach(e -> control.setExpandedState((ITimeGraphEntry)e, true));
            TmfStateSystemExplorer.this.redraw();
        }
    }

    private class FilterAction
    extends Action {
        private final @NonNull ViewerFilter fStateChangeListener;

        public FilterAction(String text) {
            super(text, 2);
            this.fStateChangeListener = new ViewerFilter(){

                /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof AttributeEntry) {
                        AttributeEntry tge = (AttributeEntry)element;
                        @NonNull Iterable attributeEntries = Iterables.filter(Utils.flatten(tge), AttributeEntry.class);
                        return Iterables.any((Iterable)attributeEntries, this::isStateChange);
                    }
                    return true;
                }

                private boolean isStateChange(@NonNull AttributeEntry attribute) {
                    List<ITmfStateInterval> fullState = StateSystemEntry.getFullStates(attribute);
                    long selectionBegin = TmfStateSystemExplorer.this.getTimeGraphViewer().getSelectionBegin();
                    return fullState != null && fullState.get(attribute.fQuark).getStartTime() == selectionBegin;
                }
            };
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)FILTER_IMAGE));
            this.setToolTipText(Messages.FilterButton);
        }

        public void run() {
            if (this.isChecked()) {
                TmfStateSystemExplorer.this.getTimeGraphViewer().addFilter(this.fStateChangeListener);
            } else {
                TmfStateSystemExplorer.this.getTimeGraphViewer().removeFilter(this.fStateChangeListener);
            }
        }
    }

    static class ModuleEntry
    extends TimeGraphEntry {
        private final ITmfAnalysisModuleWithStateSystems fModule;

        public ModuleEntry(ITmfAnalysisModuleWithStateSystems module, long startTime) {
            super(module.getName(), startTime, startTime);
            this.fModule = module;
            this.addEvent(new TimeEvent(this, startTime, 0L));
        }

        @Override
        public void updateEndTime(long endTime) {
            super.updateEndTime(endTime);
            this.addEvent(new TimeEvent(this, this.getStartTime(), endTime - this.getStartTime()));
        }

        public ITmfAnalysisModuleWithStateSystems getModule() {
            return this.fModule;
        }
    }

    static class StateSystemEntry
    extends TimeGraphEntry {
        private final ITmfStateSystem fSs;
        private List<ITmfStateInterval> fFullStates = null;

        public StateSystemEntry(ITmfStateSystem ss) {
            super(ss.getSSID(), ss.getStartTime(), ss.getCurrentEndTime());
            this.fSs = ss;
            this.addEvent(new TimeEvent(this, ss.getStartTime(), ss.getCurrentEndTime() - ss.getStartTime()));
        }

        @Override
        public void updateEndTime(long endTime) {
            super.updateEndTime(endTime);
            this.addEvent(new TimeEvent(this, this.getStartTime(), endTime - this.getStartTime()));
        }

        public ITmfStateSystem getStateSystem() {
            return this.fSs;
        }

        public void setFullStates(List<ITmfStateInterval> fullStates) {
            this.fFullStates = fullStates;
        }

        static List<ITmfStateInterval> getFullStates(TimeGraphEntry entry) {
            TimeGraphEntry parent = entry;
            while (parent != null) {
                if (parent instanceof StateSystemEntry) {
                    return ((StateSystemEntry)parent).fFullStates;
                }
                parent = parent.getParent();
            }
            return null;
        }
    }

    private static class StateSystemTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private StateSystemTreeLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TimeGraphEntry) {
                List<ITmfStateInterval> fullState;
                TimeGraphEntry entry = (TimeGraphEntry)element;
                if (columnIndex == 0) {
                    return entry.getName();
                }
                if (columnIndex == 1 && entry instanceof AttributeEntry) {
                    return Integer.toString(((AttributeEntry)entry).getQuark());
                }
                if (columnIndex == 2 && entry instanceof AttributeEntry && (fullState = StateSystemEntry.getFullStates(entry)) != null) {
                    ITmfStateInterval interval = fullState.get(((AttributeEntry)entry).getQuark());
                    return String.valueOf(interval.getValue());
                }
            }
            return "";
        }
    }

    static class TraceEntry
    extends TimeGraphEntry {
        private final ITmfTrace fEntryTrace;

        public TraceEntry(ITmfTrace trace) {
            super(trace.getName(), trace.getStartTime().toNanos(), trace.getStartTime().toNanos());
            this.fEntryTrace = trace;
        }

        @Override
        public boolean hasTimeEvents() {
            return false;
        }
    }
}

