/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class BaseDataProviderTimeGraphView
extends AbstractTimeGraphView {
    protected static final long BUILD_UPDATE_TIMEOUT = 500L;
    private final String fProviderId;

    public BaseDataProviderTimeGraphView(String id, TimeGraphPresentationProvider pres, String providerId) {
        super(id, pres);
        this.fProviderId = providerId;
    }

    protected String getProviderId() {
        return this.fProviderId;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void buildEntryList(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, @NonNull IProgressMonitor monitor) {
        @NonNull ITimeGraphDataProvider dataProvider = (ITimeGraphDataProvider)DataProviderManager.getInstance().getDataProvider(trace, this.getProviderId(), ITimeGraphDataProvider.class);
        if (dataProvider == null) {
            return;
        }
        boolean complete = false;
        HashMap<TimeGraphEntryModel, TimeGraphEntry> modelToEntryMap = new HashMap<TimeGraphEntryModel, TimeGraphEntry>();
        HashMap<Long, TimeGraphEntry> parentLookupMap = new HashMap<Long, TimeGraphEntry>();
        while (!complete && !monitor.isCanceled()) {
            TmfModelResponse response = dataProvider.fetchTree(new TimeQueryFilter(0L, Long.MAX_VALUE, 2), monitor);
            if (response.getStatus() == ITmfResponse.Status.FAILED) {
                Activator.getDefault().logError(String.valueOf(this.getClass().getSimpleName()) + " Data Provider failed: " + response.getStatusMessage());
                return;
            }
            if (response.getStatus() == ITmfResponse.Status.CANCELLED) {
                return;
            }
            complete = response.getStatus() == ITmfResponse.Status.COMPLETED;
            List model = (List)response.getModel();
            if (model != null) {
                for (TimeGraphEntryModel entry : model) {
                    TimeGraphEntry uiEntry = (TimeGraphEntry)modelToEntryMap.get(entry);
                    if (entry.getParentId() != -1L) {
                        if (uiEntry == null) {
                            uiEntry = new TimeGraphEntry(entry);
                            modelToEntryMap.put(entry, uiEntry);
                            parentLookupMap.put(entry.getId(), uiEntry);
                            TimeGraphEntry parent = (TimeGraphEntry)parentLookupMap.get(entry.getParentId());
                            if (parent == null) continue;
                            parent.addChild(uiEntry);
                            continue;
                        }
                        uiEntry.updateModel(entry);
                        continue;
                    }
                    this.setStartTime(Long.min(this.getStartTime(), entry.getStartTime()));
                    this.setEndTime(Long.max(this.getEndTime(), entry.getEndTime() + 1L));
                    if (uiEntry != null) {
                        uiEntry.updateModel(entry);
                        continue;
                    }
                    uiEntry = new TraceEntry(entry, trace, (ITimeGraphDataProvider<? extends TimeGraphEntryModel>)dataProvider);
                    modelToEntryMap.put(entry, uiEntry);
                    parentLookupMap.put(entry.getId(), uiEntry);
                    this.addToEntryList(parentTrace, Collections.singletonList(uiEntry));
                }
                long start = this.getStartTime();
                long end = this.getEndTime();
                long resolution = Long.max(1L, (end - start) / (long)this.getDisplayWidth());
                this.zoomEntries(modelToEntryMap.values(), start, end, resolution, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (parentTrace.equals(this.getTrace())) {
                this.synchingToTime(this.getTimeGraphViewer().getSelectionBegin());
                this.refresh();
            }
            monitor.worked(1);
            if (complete || monitor.isCanceled()) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError("Failed to wait for data provider", e);
            }
        }
    }

    public static @NonNull ITmfTrace getTrace(TimeGraphEntry entry) {
        return BaseDataProviderTimeGraphView.getTraceEntry(entry).getTrace();
    }

    public static ITimeGraphDataProvider<? extends TimeGraphEntryModel> getProvider(TimeGraphEntry entry) {
        return BaseDataProviderTimeGraphView.getTraceEntry(entry).getProvider();
    }

    private static TraceEntry getTraceEntry(TimeGraphEntry entry) {
        ITimeGraphEntry parent = entry;
        while (parent != null) {
            if (parent instanceof TraceEntry) {
                return (TraceEntry)parent;
            }
            parent = parent.getParent();
        }
        throw new IllegalStateException(entry + " should have a TraceEntry parent");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        if (resolution < 0L) {
            return;
        }
        long start = Long.min(zoomStartTime, zoomEndTime);
        long end = Long.max(zoomStartTime, zoomEndTime);
        @NonNull List times = StateSystemUtils.getTimes((long)start, (long)end, (long)resolution);
        TimeGraphEntry.Sampling sampling = new TimeGraphEntry.Sampling(start, end, resolution);
        Map<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Multimap<Long, TimeGraphEntry>> groupedEntries = BaseDataProviderTimeGraphView.filterGroupEntries(entries, zoomStartTime, zoomEndTime);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)(String.valueOf(this.getClass().getSimpleName()) + "#zoomEntries"), (int)groupedEntries.size());
        for (Map.Entry<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Multimap<Long, TimeGraphEntry>> entry : groupedEntries.entrySet()) {
            Multimap<Long, TimeGraphEntry> map;
            SelectionTimeQueryFilter filter;
            ITimeGraphDataProvider<? extends TimeGraphEntryModel> dataProvider = entry.getKey();
            TmfModelResponse response = dataProvider.fetchRowModel(filter = new SelectionTimeQueryFilter(times, (Collection)(map = entry.getValue()).keySet()), monitor);
            List model = (List)response.getModel();
            if (model != null) {
                this.zoomEntries(map, model, response.getStatus() == ITmfResponse.Status.COMPLETED, sampling);
            }
            subMonitor.worked(1);
        }
    }

    private static Map<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Multimap<Long, TimeGraphEntry>> filterGroupEntries(Iterable<TimeGraphEntry> visible, long zoomStartTime, long zoomEndTime) {
        HashMap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Multimap<Long, TimeGraphEntry>> quarksToEntries = new HashMap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Multimap<Long, TimeGraphEntry>>();
        for (TimeGraphEntry entry : visible) {
            ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider;
            if (zoomStartTime > entry.getEndTime() || zoomEndTime < entry.getStartTime() || !entry.hasTimeEvents() || (provider = BaseDataProviderTimeGraphView.getProvider(entry)) == null) continue;
            Multimap multimap = quarksToEntries.computeIfAbsent(provider, p -> HashMultimap.create());
            multimap.put((Object)entry.getModel().getId(), (Object)entry);
        }
        return quarksToEntries;
    }

    private void zoomEntries(Multimap<Long, TimeGraphEntry> map, List<ITimeGraphRowModel> model, boolean completed, TimeGraphEntry.Sampling sampling) {
        boolean isZoomThread = Thread.currentThread() instanceof AbstractTimeGraphView.ZoomThread;
        for (ITimeGraphRowModel rowModel : model) {
            Collection resourceEntries = map.get((Object)rowModel.getEntryID());
            for (TimeGraphEntry resourceEntry : resourceEntries) {
                List<ITimeEvent> events = this.createTimeEvents(resourceEntry, rowModel.getStates());
                if (isZoomThread) {
                    this.applyResults(() -> {
                        resourceEntry.setZoomedEventList(events);
                        if (completed) {
                            resourceEntry.setSampling(sampling);
                        }
                    });
                    continue;
                }
                resourceEntry.setEventList(events);
            }
        }
    }

    protected List<ITimeEvent> createTimeEvents(TimeGraphEntry entry, List<ITimeGraphState> values) {
        ArrayList<ITimeEvent> events = new ArrayList<ITimeEvent>(values.size());
        ITimeEvent prev = null;
        for (ITimeGraphState state : values) {
            long prevEnd;
            TimeEvent event = this.createTimeEvent(entry, state);
            if (prev != null && (prevEnd = prev.getTime() + prev.getDuration()) < event.getTime()) {
                events.add(new TimeEvent(entry, prevEnd, event.getTime() - prevEnd));
            }
            prev = event;
            events.add(event);
        }
        return events;
    }

    protected TimeEvent createTimeEvent(TimeGraphEntry entry, ITimeGraphState state) {
        if (state.getValue() == Integer.MIN_VALUE) {
            return new NullTimeEvent(entry, state.getStartTime(), state.getDuration());
        }
        String label = state.getLabel();
        if (label != null) {
            return new NamedTimeEvent(entry, state.getStartTime(), state.getDuration(), (int)state.getValue(), label);
        }
        return new TimeEvent(entry, state.getStartTime(), state.getDuration(), (int)state.getValue());
    }

    protected static class TraceEntry
    extends TimeGraphEntry {
        private final @NonNull ITmfTrace fTrace;
        private final @NonNull ITimeGraphDataProvider<? extends TimeGraphEntryModel> fProvider;

        public TraceEntry(TimeGraphEntryModel model, @NonNull ITmfTrace trace, @NonNull ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider) {
            super(model);
            this.fTrace = trace;
            this.fProvider = provider;
        }

        @Override
        public boolean hasTimeEvents() {
            return false;
        }

        public @NonNull ITmfTrace getTrace() {
            return this.fTrace;
        }

        public @NonNull ITimeGraphDataProvider<? extends TimeGraphEntryModel> getProvider() {
            return this.fProvider;
        }
    }
}

