/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsExecutionGraphProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsSystemModel;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.BaseHandler;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.Messages;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.EventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class TraceEventHandlerStatedump
extends BaseHandler {
    public TraceEventHandlerStatedump(OsExecutionGraphProvider provider, int priority) {
        super(provider, priority);
    }

    @Override
    public void handleEvent(ITmfEvent event) {
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        OsSystemModel system = this.getProvider().getSystem();
        String eventName = event.getName();
        if (!eventName.equals(eventLayout.eventStatedumpProcessState())) {
            return;
        }
        Integer tid = EventField.getInt(event, eventLayout.fieldTid());
        String name = EventField.getOrDefault(event, eventLayout.fieldName(), NonNullUtils.nullToEmptyString((Object)Messages.TraceEventHandlerSched_UnknownThreadName));
        Integer status = EventField.getInt(event, eventLayout.fieldStatus());
        String host = event.getTrace().getHostId();
        long ts = event.getTimestamp().getValue();
        HostThread ht = new HostThread(host, tid);
        OsWorker task = system.findWorker(ht);
        if (task == null) {
            task = new OsWorker(ht, name, ts);
            system.addWorker(task);
        } else {
            task.setName(name);
        }
        task.setStatus(ProcessStatus.getStatusFromStatedump((long)status.intValue()));
    }
}

