/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.html;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.ui.internal.intro.impl.html.HTMLUtil;

public class HTMLElement {
    private String elementName;
    private Map<String, String> elementAttributes;
    private Vector<Object> elementContent;

    public HTMLElement(String name) {
        this.elementName = name;
        this.elementAttributes = new HashMap<String, String>();
        this.elementContent = new Vector();
    }

    public HTMLElement(String name, Map<String, String> attributes, Vector<Object> content) {
        this.elementName = name;
        this.elementAttributes = attributes;
        this.elementContent = content;
    }

    public void addAttribute(String attributeName, String attributeValue) {
        if (attributeName != null && attributeValue != null) {
            this.getElementAttributes().put(attributeName, attributeValue);
        }
    }

    public void addContent(Object content) {
        this.getElementContent().add(content);
    }

    public Map<String, String> getElementAttributes() {
        if (this.elementAttributes == null) {
            this.elementAttributes = new HashMap<String, String>();
        }
        return this.elementAttributes;
    }

    public void setElementAttributes(Map<String, String> elementAttributes) {
        this.elementAttributes = elementAttributes;
    }

    public Vector<Object> getElementContent() {
        if (this.elementContent == null) {
            this.elementContent = new Vector();
        }
        return this.elementContent;
    }

    public void setElementContent(Vector<Object> elementContent) {
        this.elementContent = elementContent;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String toString() {
        StringBuffer element = new StringBuffer();
        element.append(HTMLUtil.createHTMLStartTag(this.getElementName(), this.getElementAttributes(), false));
        for (Object content : this.getElementContent()) {
            element.append(content);
        }
        element.append(HTMLUtil.createHTMLEndTag(this.getElementName(), false));
        return element.toString();
    }
}

