/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.viewers.ILegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.swtchart.LineStyle;

public class XYChartLegendImageProvider
implements ILegendImageProvider {
    private static final int OVAL_LEGEND_SIZE = 3;
    private static final @NonNull String DOT_SHAPE_OVAL = "oval";
    private final TmfCommonXAxisChartViewer fChartViewer;

    public XYChartLegendImageProvider(TmfCommonXAxisChartViewer chartViewer) {
        this.fChartViewer = chartViewer;
    }

    @Override
    public Image getLegendImage(int imageHeight, int imageWidth, @NonNull String name) {
        IYAppearance appearance = this.fChartViewer.getSeriesAppearance(name);
        RGBAColor rgb = appearance.getColor();
        Color lineColor = new Color((Device)Display.getDefault(), (int)rgb.getRed(), (int)rgb.getGreen(), (int)rgb.getBlue());
        Color background = Display.getDefault().getSystemColor(1);
        PaletteData palette = new PaletteData(new RGB[]{background.getRGB(), lineColor.getRGB()});
        ImageData imageData = new ImageData(imageWidth, imageHeight, 8, palette);
        imageData.transparentPixel = 0;
        Image image = new Image((Device)Display.getDefault(), imageData);
        GC gc = new GC((Drawable)image);
        gc.setBackground(background);
        gc.fillRectangle(0, 0, imageWidth, imageHeight);
        gc.setForeground(lineColor);
        gc.setLineWidth(appearance.getWidth());
        LineStyle lineStyle = LineStyle.valueOf((String)appearance.getStyle());
        if (lineStyle != LineStyle.NONE) {
            gc.setLineStyle(LineStyle.valueOf((String)appearance.getStyle()).ordinal());
            gc.drawLine(0, imageHeight / 2, imageWidth, imageHeight / 2);
        } else {
            XYChartLegendImageProvider.drawStyledDot(gc, lineColor, imageWidth, imageHeight, DOT_SHAPE_OVAL);
        }
        gc.dispose();
        lineColor.dispose();
        return image;
    }

    /*
     * Unable to fully structure code
     */
    private static void drawStyledDot(GC gc, Color lineColor, int imageWidth, int imageHeight, String shape) {
        gc.setBackground(lineColor);
        var5_5 = shape;
        tmp = -1;
        switch (var5_5.hashCode()) {
            case 3423314: {
                if (!var5_5.equals("oval")) break;
                tmp = 1;
                break;
            }
        }
        ** switch (tmp)
lbl11:
        // 2 sources

        gc.fillOval(imageWidth / 2 - 3, imageHeight / 2 - 3, 6, 6);
    }
}

