/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.TreeMultimap;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.SoftIrqLabelProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class ResourcesStatusDataProvider
extends AbstractTimeGraphDataProvider<KernelAnalysisModule, ResourcesEntryModel> {
    public static final @NonNull String ID = "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ResourcesStatusDataProvider";
    private static final String WILDCARD = "*";
    private final Function<@NonNull String, @NonNull String> fSyscallTrim;
    private final HashMap<Integer, ResourcesEntryModel.Type> fEntryModelTypes = new HashMap();
    private static final Comparator<ITmfStateInterval> CACHE_COMPARATOR = (a, b) -> {
        if (a.getEndTime() < b.getStartTime()) {
            return -1;
        }
        if (a.getStartTime() > b.getEndTime()) {
            return 1;
        }
        return 0;
    };
    private final TreeMultimap<Integer, ITmfStateInterval> fExecNamesCache = TreeMultimap.create(Integer::compare, CACHE_COMPARATOR);

    protected ResourcesStatusDataProvider(@NonNull ITmfTrace trace, @NonNull KernelAnalysisModule module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
        if (trace instanceof IKernelTrace) {
            IKernelAnalysisEventLayout layout = ((IKernelTrace)trace).getKernelEventLayout();
            int beginIndex = layout.eventSyscallEntryPrefix().length();
            this.fSyscallTrim = sysCall -> sysCall.substring(beginIndex);
        } else {
            this.fSyscallTrim = Function.identity();
        }
    }

    protected @NonNull List<@NonNull ResourcesEntryModel> getTree(@NonNull ITmfStateSystem ss, @NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        long start = ss.getStartTime();
        long end = ss.getCurrentEndTime();
        ArrayList<@NonNull ResourcesEntryModel> builder = new ArrayList<ResourcesEntryModel>();
        long traceId = this.getId(-1);
        ResourcesEntryModel resourcesEntryModel = new ResourcesEntryModel(traceId, -1L, this.getTrace().getName(), start, end, -1, ResourcesEntryModel.Type.TRACE);
        builder.add(resourcesEntryModel);
        for (Integer cpuQuark : ss.getQuarks(new String[]{"CPUs", WILDCARD})) {
            @NonNull String cpuName = ss.getAttributeName(cpuQuark.intValue());
            int cpu = Integer.parseInt(cpuName);
            Integer currentThreadQuark = ss.optQuarkRelative(cpuQuark.intValue(), new String[]{"Current_thread"});
            if (currentThreadQuark != -2) {
                ResourcesEntryModel currentThreadEntry = new ResourcesEntryModel(this.getId(currentThreadQuark), traceId, ResourcesStatusDataProvider.computeEntryName(ResourcesEntryModel.Type.CURRENT_THREAD, cpu), start, end, cpu, ResourcesEntryModel.Type.CURRENT_THREAD);
                builder.add(currentThreadEntry);
                this.fEntryModelTypes.put(currentThreadQuark, ResourcesEntryModel.Type.CURRENT_THREAD);
            }
            ResourcesEntryModel cpuEntry = new ResourcesEntryModel(this.getId(cpuQuark), traceId, ResourcesStatusDataProvider.computeEntryName(ResourcesEntryModel.Type.CPU, cpu), start, end, cpu, ResourcesEntryModel.Type.CPU);
            builder.add(cpuEntry);
            this.fEntryModelTypes.put(cpuQuark, ResourcesEntryModel.Type.CPU);
            List irqQuarks = ss.getQuarks(cpuQuark.intValue(), new String[]{"IRQs", WILDCARD});
            this.createInterrupt(ss, start, end, cpuEntry, irqQuarks, ResourcesEntryModel.Type.IRQ, builder);
            List softIrqQuarks = ss.getQuarks(cpuQuark.intValue(), new String[]{"Soft_IRQs", WILDCARD});
            this.createInterrupt(ss, start, end, cpuEntry, softIrqQuarks, ResourcesEntryModel.Type.SOFT_IRQ, builder);
        }
        return ImmutableList.copyOf(builder);
    }

    private void createInterrupt(ITmfStateSystem ssq, long startTime, long endTime, ResourcesEntryModel cpuEntry, List<Integer> irqQuarks, ResourcesEntryModel.Type type, List<ResourcesEntryModel> builder) {
        for (Integer irqQuark : irqQuarks) {
            String resourceName = ssq.getAttributeName(irqQuark.intValue());
            int resourceId = Integer.parseInt(resourceName);
            long irqId = this.getId(irqQuark);
            builder.add(new ResourcesEntryModel(irqId, cpuEntry.getId(), ResourcesStatusDataProvider.computeEntryName(type, resourceId), startTime, endTime, resourceId, type));
            this.fEntryModelTypes.put(irqQuark, type);
            String aggregateIrqtype = type == ResourcesEntryModel.Type.IRQ ? "IRQs" : "Soft_IRQs";
            int aggregateQuark = ssq.optQuarkAbsolute(new String[]{aggregateIrqtype, resourceName});
            if (aggregateQuark == -2) continue;
            long aggregateId = this.getId(aggregateQuark);
            if (!Iterables.any(builder, entry -> entry.getId() == aggregateId)) {
                builder.add(new ResourcesEntryModel(aggregateId, cpuEntry.getParentId(), ResourcesStatusDataProvider.computeEntryName(type, resourceId), startTime, endTime, resourceId, type));
            }
            builder.add(new ResourcesEntryModel(irqId, aggregateId, ResourcesStatusDataProvider.computeEntryName(ResourcesEntryModel.Type.CPU, cpuEntry.getResourceId()), startTime, endTime, cpuEntry.getResourceId(), type));
            this.fEntryModelTypes.put(aggregateQuark, type);
        }
    }

    private static @NonNull String computeEntryName(ResourcesEntryModel.Type type, int id) {
        String cpuEntryName;
        if (type == ResourcesEntryModel.Type.SOFT_IRQ) {
            return String.valueOf(type.toString()) + ' ' + id + ' ' + SoftIrqLabelProvider.getSoftIrq(id);
        }
        if (type == ResourcesEntryModel.Type.CURRENT_THREAD) {
            String threadEntryName = NLS.bind((String)Messages.ThreadEntry, (Object)id);
            if (threadEntryName != null) {
                return threadEntryName;
            }
        } else if (type == ResourcesEntryModel.Type.CPU && (cpuEntryName = NLS.bind((String)Messages.CpuEntry, (Object)id)) != null) {
            return cpuEntryName;
        }
        return String.valueOf(type.toString()) + ' ' + id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<ITimeGraphRowModel> getRowModel(ITmfStateSystem ss, SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        @NonNull @NonNull BiMap entries = this.getSelectedEntries(filter);
        Collection times = ResourcesStatusDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        Set<@NonNull Integer> quarks = ResourcesStatusDataProvider.addThreadStatus(ss, entries.values());
        for (ITmfStateInterval interval : ss.query2D(quarks, times)) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        ArrayList<ITimeGraphRowModel> rows = new ArrayList<ITimeGraphRowModel>();
        for (Map.Entry entry : entries.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            ArrayList<Object> eventList = new ArrayList<Object>();
            for (ITmfStateInterval interval : intervals.get((Object)((Integer)entry.getValue()))) {
                long startTime = interval.getStartTime();
                long duration = interval.getEndTime() - startTime + 1L;
                Object status = interval.getValue();
                ResourcesEntryModel.Type type = this.fEntryModelTypes.get(interval.getAttribute());
                if (status instanceof Integer) {
                    int s = (Integer)status;
                    int currentThreadQuark = ss.optQuarkRelative(interval.getAttribute(), new String[]{"Current_thread"});
                    if (type == ResourcesEntryModel.Type.CPU && s == 4) {
                        eventList.add(this.getSyscall(ss, interval, intervals.get((Object)currentThreadQuark)));
                        continue;
                    }
                    if (type == ResourcesEntryModel.Type.CPU && s == 2) {
                        eventList.addAll(ResourcesStatusDataProvider.getCurrentThreads(ss, interval, intervals.get((Object)currentThreadQuark)));
                        continue;
                    }
                    if (type == ResourcesEntryModel.Type.CURRENT_THREAD && s != 0) {
                        String execName = null;
                        TreeMultimap<Integer, ITmfStateInterval> treeMultimap = this.fExecNamesCache;
                        synchronized (treeMultimap) {
                            if (this.fExecNamesCache.containsEntry(status, (Object)interval)) {
                                NavigableSet intervalSet = this.fExecNamesCache.get((Object)s);
                                ITmfStateInterval execNameInterval = intervalSet.ceiling(interval);
                                if (execNameInterval != null && CACHE_COMPARATOR.compare(execNameInterval, interval) == 0) {
                                    execName = (String)execNameInterval.getValue();
                                }
                            } else {
                                int quark = ss.optQuarkAbsolute(new String[]{"Threads", Integer.toString(s), "Exec_name"});
                                if (quark != -2) {
                                    ITmfStateInterval namedInterval = ss.querySingleState(interval.getEndTime(), quark);
                                    this.fExecNamesCache.put((Object)s, (Object)namedInterval);
                                    execName = (String)namedInterval.getValue();
                                }
                            }
                        }
                        eventList.add(new TimeGraphState(startTime, duration, (long)s, execName != null ? String.valueOf(execName) + ' ' + '(' + String.valueOf(s) + ')' : String.valueOf(s)));
                        continue;
                    }
                    eventList.add(new TimeGraphState(startTime, duration, (long)s));
                    continue;
                }
                eventList.add(new TimeGraphState(startTime, duration, Integer.MIN_VALUE));
            }
            rows.add((ITimeGraphRowModel)new TimeGraphRowModel(((Long)entry.getKey()).longValue(), eventList));
        }
        Iterator iterator = this.fExecNamesCache;
        synchronized (iterator) {
            this.fExecNamesCache.clear();
        }
        return rows;
    }

    private static @NonNull Set<@NonNull Integer> addThreadStatus(@NonNull ITmfStateSystem ss, @NonNull Collection<@NonNull Integer> values) {
        HashSet<@NonNull Integer> set = new HashSet<Integer>(values);
        for (Integer quark : values) {
            int threadStatus;
            int parentAttributeQuark = ss.getParentAttributeQuark(quark.intValue());
            if (!ss.getAttributeName(parentAttributeQuark).equals("CPUs") || (threadStatus = ss.optQuarkRelative(quark.intValue(), new String[]{"Current_thread"})) == -2) continue;
            set.add(threadStatus);
        }
        return set;
    }

    private static List<TimeGraphState> getCurrentThreads(@NonNull ITmfStateSystem ss, ITmfStateInterval userModeInterval, @NonNull NavigableSet<ITmfStateInterval> currentThreadIntervals) throws StateSystemDisposedException {
        ArrayList<TimeGraphState> list = new ArrayList<TimeGraphState>();
        for (ITmfStateInterval currentThread : currentThreadIntervals) {
            Object currentThreadName;
            int execNameQuark;
            if (currentThread.getStartTime() > userModeInterval.getEndTime() || currentThread.getEndTime() < userModeInterval.getStartTime()) continue;
            long start = Long.max(userModeInterval.getStartTime(), currentThread.getStartTime());
            long end = Long.min(userModeInterval.getEndTime(), currentThread.getEndTime());
            long duration = end - start + 1L;
            Object tid = currentThread.getValue();
            if (tid instanceof Integer && (execNameQuark = ss.optQuarkAbsolute(new String[]{"Threads", String.valueOf(tid), "Exec_name"})) != -2 && (currentThreadName = ss.querySingleState(currentThread.getEndTime(), execNameQuark).getValue()) instanceof String) {
                list.add(new TimeGraphState(start, duration, 2L, (String)currentThreadName));
                continue;
            }
            list.add(new TimeGraphState(start, duration, 2L));
        }
        return list;
    }

    private ITimeGraphState getSyscall(@NonNull ITmfStateSystem ss, ITmfStateInterval interval, @NonNull NavigableSet<ITmfStateInterval> currentThreadIntervals) throws StateSystemDisposedException {
        ITmfStateInterval nameInterval;
        Object syscallName;
        int currentThreadId;
        int quark;
        Object value;
        long startTime = interval.getStartTime();
        long duration = interval.getEndTime() - startTime + 1L;
        int status = 4;
        ITmfStateInterval tidInterval = currentThreadIntervals.floor(interval);
        if (tidInterval != null && (value = tidInterval.getValue()) instanceof Integer && (quark = ss.optQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId = ((Integer)value).intValue()), "System_call"})) != -2 && (syscallName = (nameInterval = ss.querySingleState(startTime, quark)).getValue()) instanceof String) {
            String label = this.fSyscallTrim.apply((String)syscallName);
            return new TimeGraphState(startTime, duration, (long)status, label);
        }
        return new TimeGraphState(startTime, duration, (long)status);
    }

    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull String getId() {
        return ID;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public TmfModelResponse<Map<String, String>> fetchTooltip(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        ITmfStateSystem ss = ((KernelAnalysisModule)this.getAnalysisModule()).getStateSystem();
        @NonNull Set quarks = this.getSelectedQuarks(filter);
        long start = filter.getStart();
        if (ss == null || quarks.size() != 1 || !((KernelAnalysisModule)this.getAnalysisModule()).isQueryable(start)) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        int quark = (Integer)quarks.iterator().next();
        String attributeName = ss.getAttributeName(quark);
        Integer cpuNumber = Ints.tryParse((String)attributeName);
        String parent = ss.getAttributeName(ss.getParentAttributeQuark(quark));
        if (!(parent.equals("CPUs") && cpuNumber != null || attributeName.equals("Current_thread"))) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        try {
            LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>(1);
            List full = ss.queryFullState(start);
            Object object = ((ITmfStateInterval)full.get(quark)).getValue();
            if (object instanceof Integer) {
                int status = (Integer)object;
                if (status == 16) {
                    ResourcesStatusDataProvider.putIrq(ss, attributeName, retMap, full, "IRQs");
                } else if (status == 8) {
                    ResourcesStatusDataProvider.putIrq(ss, attributeName, retMap, full, "Soft_IRQs");
                } else if (status == 2 || status == 4) {
                    ResourcesStatusDataProvider.putCpuTooltip(ss, attributeName, retMap, full, status);
                } else if (attributeName.equals("Current_thread")) {
                    ResourcesStatusDataProvider.putCurrentThreadTooltip(ss, retMap, full, status);
                }
            }
            return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
    }

    private static void putIrq(ITmfStateSystem ss, String attributeName, Map<String, String> retMap, List<ITmfStateInterval> full, String irqs) {
        Iterator iterator = ss.getQuarks(new String[]{"CPUs", attributeName, irqs, WILDCARD}).iterator();
        while (iterator.hasNext()) {
            int irqQuark = (Integer)iterator.next();
            ITmfStateInterval interval = full.get(irqQuark);
            if (interval.getValue() == null) continue;
            String irq = ss.getAttributeName(irqQuark);
            retMap.put(irqs, irq);
            return;
        }
    }

    private static void putCpuTooltip(ITmfStateSystem ss, String attributeName, Map<String, String> retMap, List<ITmfStateInterval> full, int status) {
        int currentThreadQuark = ss.optQuarkAbsolute(new String[]{"CPUs", attributeName, "Current_thread"});
        if (currentThreadQuark == -2) {
            return;
        }
        Object currentThreadObject = full.get(currentThreadQuark).getValue();
        if (currentThreadObject instanceof Number) {
            Object syscall;
            Object processName;
            String currentThread = currentThreadObject.toString();
            retMap.put("Current_thread", currentThread);
            int execNameQuark = ss.optQuarkAbsolute(new String[]{"Threads", currentThread, "Exec_name"});
            if (execNameQuark != -2 && (processName = full.get(execNameQuark).getValue()) instanceof String) {
                retMap.put("Exec_name", (String)processName);
            }
            int syscallQuark = ss.optQuarkAbsolute(new String[]{"Threads", currentThread, "System_call"});
            if (status == 4 && syscallQuark != -2 && (syscall = full.get(syscallQuark).getValue()) instanceof String) {
                retMap.put("System_call", (String)syscall);
            }
        }
    }

    private static void putCurrentThreadTooltip(ITmfStateSystem ss, Map<String, String> retMap, List<ITmfStateInterval> full, int tid) {
        Object processName;
        String currentThread = String.valueOf(tid);
        retMap.put("Current_thread", currentThread);
        int execNameQuark = ss.optQuarkAbsolute(new String[]{"Threads", currentThread, "Exec_name"});
        if (execNameQuark != -2 && (processName = full.get(execNameQuark).getValue()) instanceof String) {
            retMap.put("Exec_name", (String)processName);
        }
    }

    protected boolean isCacheable() {
        return true;
    }
}

