/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.swtchart;

import com.google.common.collect.Iterators;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartData;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartModel;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartSeries;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDataChartDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.INumericalResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.signal.ChartSelectionUpdateSignal;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.ui.chart.IChartViewer;
import org.eclipse.tracecompass.internal.tmf.chart.core.aggregator.IConsumerAggregator;
import org.eclipse.tracecompass.internal.tmf.chart.core.consumer.IDataConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.XYChartConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.XYSeriesConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRangeMap;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.DescriptorsInformation;
import org.eclipse.tracecompass.internal.tmf.chart.ui.format.ChartDecimalUnitFormat;
import org.eclipse.tracecompass.internal.tmf.chart.ui.format.ChartTimeStampFormat;
import org.eclipse.tracecompass.internal.tmf.chart.ui.swtchart.SwtChartPoint;
import org.eclipse.tracecompass.internal.tmf.chart.ui.swtchart.SwtChartSelection;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.ui.PlatformUI;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisTick;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.ITitle;

public abstract class SwtXYChartViewer
extends TmfViewer
implements IChartViewer {
    protected static final char ELLIPSIS = '\u2026';
    private static final String DAYS_FORMAT = "dd HH:mm";
    private static final String HOURS_FORMAT = "HH:mm";
    private static final String MINUTES_FORMAT = "mm:ss";
    private static final String SECONDS_FORMAT = "ss";
    private static final String MILLISECONDS_FORMAT = "ss.SSS";
    private static final int CLOSE_BUTTON_SIZE = 25;
    private static final int CLOSE_BUTTON_MARGIN = 5;
    private final Button fCloseButton;
    private final Chart fChart;
    private final ChartData fData;
    private final ChartModel fModel;
    private final DescriptorsInformation fXInformation;
    private final DescriptorsInformation fYInformation;
    private @Nullable XYChartConsumer fChartConsumer;
    private final Map<ChartSeries, ISeries> fSeriesMap;
    private final Map<ISeries, Object[]> fObjectMap;
    private String fXTitle;
    private String fYTitle;
    private final SwtChartSelection fSelectedPoints = new SwtChartSelection();

    public SwtXYChartViewer(Composite parent, ChartData data, ChartModel model) {
        this.fParent = parent;
        this.fData = data;
        this.fModel = model;
        this.fSeriesMap = new HashMap<ChartSeries, ISeries>(data.getChartSeries().size());
        this.fObjectMap = new HashMap<ISeries, Object[]>(data.getChartSeries().size());
        this.fXInformation = DescriptorsInformation.create(this.getXDescriptors());
        this.fYInformation = DescriptorsInformation.create(this.getYDescriptors());
        this.validateChartData();
        this.fChart = new Chart(parent, 0);
        this.fXTitle = SwtXYChartViewer.generateTitle(this.getXDescriptors(), this.getChart().getAxisSet().getXAxis(0));
        this.fYTitle = SwtXYChartViewer.generateTitle(this.getYDescriptors(), this.getChart().getAxisSet().getYAxis(0));
        this.fChart.getTitle().setForeground(Display.getDefault().getSystemColor(2));
        this.fChart.getAxisSet().getXAxis(0).getTitle().setForeground(Display.getDefault().getSystemColor(2));
        this.fChart.getAxisSet().getYAxis(0).getTitle().setForeground(Display.getDefault().getSystemColor(2));
        this.fChart.getAxisSet().getXAxis(0).getTick().setForeground(Display.getDefault().getSystemColor(2));
        this.fChart.getAxisSet().getYAxis(0).getTick().setForeground(Display.getDefault().getSystemColor(2));
        this.fChart.getAxisSet().getXAxis(0).getTick().setTickLabelAngle(90);
        if (this.getData().getChartSeries().size() > 1) {
            this.fChart.getLegend().setPosition(1024);
        } else {
            this.fChart.getLegend().setVisible(false);
        }
        this.refreshDisplayTitles();
        Image close = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE");
        this.fCloseButton = new Button((Composite)this.fChart, 8);
        this.fCloseButton.setSize(25, 25);
        this.fCloseButton.setLocation(this.fChart.getSize().x - this.fCloseButton.getSize().x - 5, 5);
        this.fCloseButton.setImage(close);
        this.fCloseButton.addSelectionListener((SelectionListener)new CloseButtonEvent());
        MouseEnterEvent mouseEnter = new MouseEnterEvent();
        MouseExitEvent mouseExit = new MouseExitEvent();
        this.fChart.getDisplay().addFilter(6, (Listener)mouseEnter);
        this.fChart.getDisplay().addFilter(7, (Listener)mouseExit);
        this.fChart.addDisposeListener(event -> {
            this.fChart.getDisplay().removeFilter(6, mouseEnter);
            this.fChart.getDisplay().removeFilter(7, mouseExit);
        });
        this.fChart.addControlListener((ControlListener)new ResizeEvent());
    }

    protected final void populate() {
        XYChartConsumer chartConsumer;
        this.fChartConsumer = chartConsumer = this.createChartConsumer();
        this.fData.getDataProvider().getSource().forEach(o -> chartConsumer.accept(o));
        chartConsumer.finish();
        this.createChartSeries();
        this.configureSeries(this.fObjectMap);
        this.getChart().getAxisSet().adjustRange();
        this.configureAxes();
        Arrays.stream(this.getChart().getAxisSet().getXAxes()).forEach(a -> a.enableLogScale(this.getModel().isXLogscale()));
        Arrays.stream(this.getChart().getAxisSet().getYAxes()).forEach(a -> a.enableLogScale(this.getModel().isYLogscale()));
        IAxis[] iAxisArray = this.getChart().getAxisSet().getYAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis yAxis = iAxisArray[n2];
            yAxis.getTick().setTickLabelAngle(1);
            ++n2;
        }
        this.fXTitle = SwtXYChartViewer.generateTitle(this.getXDescriptors(), this.getChart().getAxisSet().getXAxis(0));
        this.fYTitle = SwtXYChartViewer.generateTitle(this.getYDescriptors(), this.getChart().getAxisSet().getYAxis(0));
        this.refreshDisplayTitles();
        this.refreshDisplayLabels();
    }

    private final void createChartSeries() {
        ISeriesSet set = (ISeriesSet)NonNullUtils.checkNotNull((Object)this.getChart().getSeriesSet());
        Iterator colors = Iterators.cycle((Iterable)COLORS);
        this.getData().getChartSeries().forEach(series -> {
            ISeries swtSeries = this.createSwtSeries((ChartSeries)series, set, (Color)colors.next());
            this.fSeriesMap.put((ChartSeries)series, swtSeries);
        });
    }

    private final XYChartConsumer createChartConsumer() {
        ArrayList<XYSeriesConsumer> series = new ArrayList<XYSeriesConsumer>();
        this.getData().getChartSeries().forEach(s -> {
            IDataConsumer xConsumer = this.getXConsumer((ChartSeries)s);
            IDataConsumer yConsumer = this.getYConsumer((ChartSeries)s);
            series.add(new XYSeriesConsumer((ChartSeries)s, xConsumer, yConsumer));
        });
        IConsumerAggregator xAggregator = this.getXAggregator();
        IConsumerAggregator yAggregator = this.getYAggregator();
        return new XYChartConsumer(series, xAggregator, yAggregator);
    }

    @Override
    public void dispose() {
        if (!this.fChart.isDisposed()) {
            this.fChart.dispose();
        }
        this.fParent.layout();
        super.dispose();
    }

    public @Nullable Control getControl() {
        return this.fChart.getParent();
    }

    public void refresh() {
        Display.getDefault().asyncExec(() -> {
            if (!this.fChart.isDisposed()) {
                this.fChart.redraw();
            }
        });
    }

    protected abstract IDataConsumer getXConsumer(ChartSeries var1);

    protected abstract IDataConsumer getYConsumer(ChartSeries var1);

    protected abstract @Nullable IConsumerAggregator getXAggregator();

    protected abstract @Nullable IConsumerAggregator getYAggregator();

    protected abstract ISeries createSwtSeries(ChartSeries var1, ISeriesSet var2, Color var3);

    protected abstract void configureSeries(Map<ISeries, Object[]> var1);

    protected abstract void configureAxes();

    protected abstract void refreshDisplayLabels();

    @TmfSignalHandler
    public void updateSelection(ChartSelectionUpdateSignal signal) {
        Object source = signal.getSource();
        if (this.equals(source) || !this.getData().getDataProvider().equals(signal.getDataProvider())) {
            return;
        }
        Set set = signal.getSelectedObject();
        this.setSelection(set);
        this.refresh();
    }

    protected void setSelection(Set<@NonNull Object> set) {
        this.fSelectedPoints.clear();
        for (ISeries series : this.getObjectMap().keySet()) {
            Object[] objects = (Object[])NonNullUtils.checkNotNull((Object)this.getObjectMap().get(series));
            int i = 0;
            while (i < objects.length) {
                if (set.contains(objects[i])) {
                    this.fSelectedPoints.add(new SwtChartPoint(series, i));
                }
                ++i;
            }
        }
    }

    protected void validateChartData() {
        if (!this.getXDescriptorsInfo().areNumerical() && this.getModel().isXLogscale()) {
            throw new IllegalArgumentException("Cannot have logarithmic scale on discontinuous data.");
        }
        if (!this.getYDescriptorsInfo().areNumerical() && this.getModel().isYLogscale()) {
            throw new IllegalArgumentException("Cannot have logarithmic scale on discontinuous data.");
        }
    }

    protected String getTitle() {
        return this.getModel().getTitle();
    }

    private static String generateTitle(Collection<IDataChartDescriptor<?, ?>> descriptors, @Nullable IAxis axis) {
        Format format;
        if (descriptors.isEmpty()) {
            return "";
        }
        IDataChartDescriptor<?, ?> descriptor = descriptors.iterator().next();
        long nbDiffDescriptorName = descriptors.stream().map(d -> d.getName()).distinct().count();
        long nbDiffDescriptorUnits = descriptors.stream().map(d -> d.getUnit()).distinct().count();
        String title = "Value";
        if (nbDiffDescriptorName == 1L) {
            title = descriptor.getName();
        }
        String units = null;
        if (nbDiffDescriptorUnits == 1L) {
            units = descriptor.getUnit();
        }
        if (units != null) {
            title = String.valueOf(title) + ' ' + '(' + units + ')';
        }
        if (axis != null && (format = axis.getTick().getFormat()) instanceof ChartTimeStampFormat) {
            title = String.valueOf(title) + ' ' + '(' + ((ChartTimeStampFormat)format).getPattern() + ')';
        }
        return title;
    }

    @Deprecated
    private static int getAverageCharWidth(GC gc) {
        return gc.getFontMetrics().getAverageCharWidth();
    }

    private void refreshDisplayTitle(ITitle title, String canonicalTitle, int maxPixelLength) {
        if (title.isVisible()) {
            String newTitle = canonicalTitle;
            Font font = title.getFont();
            GC gc = new GC((Drawable)this.fParent);
            gc.setFont(font);
            Point pixels = gc.stringExtent(canonicalTitle);
            if (pixels.x > maxPixelLength) {
                int minimum;
                int charwidth = SwtXYChartViewer.getAverageCharWidth(gc);
                int strLen = maxPixelLength / charwidth - (minimum = 3);
                newTitle = strLen > minimum ? String.valueOf(canonicalTitle.substring(0, strLen)) + '\u2026' : String.valueOf('\u2026');
            }
            title.setText(newTitle);
            gc.dispose();
        }
    }

    private void refreshDisplayTitles() {
        Rectangle chartRect = this.fChart.getClientArea();
        Rectangle plotRect = this.fChart.getPlotArea().getClientArea();
        ITitle chartTitle = (ITitle)NonNullUtils.checkNotNull((Object)this.fChart.getTitle());
        this.refreshDisplayTitle(chartTitle, this.getTitle(), chartRect.width);
        ITitle xTitle = (ITitle)NonNullUtils.checkNotNull((Object)this.fChart.getAxisSet().getXAxis(0).getTitle());
        this.refreshDisplayTitle(xTitle, this.fXTitle, plotRect.width);
        ITitle yTitle = (ITitle)NonNullUtils.checkNotNull((Object)this.fChart.getAxisSet().getYAxis(0).getTitle());
        this.refreshDisplayTitle(yTitle, this.fYTitle, plotRect.height);
    }

    protected static ChartRangeMap clampInputDataRange(ChartRangeMap map) {
        map.getInputDataRange().clamp();
        return map;
    }

    protected static void updateTickMark(Map<String, Integer> map, IAxisTick tick, int availableLenghtPixel) {
        int nbLabels = Math.max(1, map.size());
        int stepSizePixel = availableLenghtPixel / nbLabels;
        if (16.0 > (double)stepSizePixel) {
            stepSizePixel = 16;
        }
        tick.setTickMarkStepHint(stepSizePixel);
    }

    protected static Format getContinuousAxisFormatter(ChartRangeMap map, DescriptorsInformation info) {
        BigDecimal min;
        BigDecimal max;
        long duration;
        Object formatter = info.areTimestamp() ? ((duration = (max = map.getInputDataRange().getMinimum()).subtract(min = map.getInputDataRange().getMaximum()).longValue()) > TimeUnit.DAYS.toNanos(1L) ? new ChartTimeStampFormat(DAYS_FORMAT, map) : (duration > TimeUnit.HOURS.toNanos(1L) ? new ChartTimeStampFormat(HOURS_FORMAT, map) : (duration > TimeUnit.MINUTES.toNanos(1L) ? new ChartTimeStampFormat(MINUTES_FORMAT, map) : (duration > TimeUnit.SECONDS.toNanos(1L) ? new ChartTimeStampFormat(SECONDS_FORMAT, map) : new ChartTimeStampFormat(MILLISECONDS_FORMAT, map))))) : (info.areDuration() ? new ChartDecimalUnitFormat(map) : new ChartDecimalUnitFormat(map));
        return formatter;
    }

    protected Chart getChart() {
        return this.fChart;
    }

    protected ChartData getData() {
        return this.fData;
    }

    protected ChartModel getModel() {
        return this.fModel;
    }

    protected DescriptorsInformation getXDescriptorsInfo() {
        return this.fXInformation;
    }

    protected DescriptorsInformation getYDescriptorsInfo() {
        return this.fYInformation;
    }

    protected XYChartConsumer getChartConsumer() {
        return (XYChartConsumer)NonNullUtils.checkNotNull((Object)this.fChartConsumer);
    }

    protected Map<ChartSeries, ISeries> getSeriesMap() {
        return this.fSeriesMap;
    }

    protected Map<ISeries, Object[]> getObjectMap() {
        return this.fObjectMap;
    }

    protected SwtChartSelection getSelection() {
        return this.fSelectedPoints;
    }

    protected Collection<IDataChartDescriptor<?, ?>> getXDescriptors() {
        return (Collection)NonNullUtils.checkNotNull((Object)((List)this.getData().getChartSeries().stream().map(series -> series.getX()).collect((Collector)NonNullUtils.checkNotNull(Collectors.toList()))));
    }

    protected Collection<IDataChartDescriptor<?, ?>> getYDescriptors() {
        return (Collection)NonNullUtils.checkNotNull((Object)((List)this.getData().getChartSeries().stream().map(series -> series.getY()).collect((Collector)NonNullUtils.checkNotNull(Collectors.toList()))));
    }

    private class CloseButtonEvent
    implements SelectionListener {
        private CloseButtonEvent() {
        }

        public void widgetSelected(@Nullable SelectionEvent e) {
            SwtXYChartViewer.this.dispose();
        }

        public void widgetDefaultSelected(@Nullable SelectionEvent e) {
        }
    }

    protected class LogarithmicPredicate
    implements Predicate<Number> {
        private INumericalResolver<?, Number> fResolver;

        protected LogarithmicPredicate(INumericalResolver<?, Number> resolver) {
            this.fResolver = resolver;
        }

        @Override
        public boolean test(@Nullable Number t) {
            if (t == null) {
                return false;
            }
            return this.fResolver.getComparator().compare(t, this.fResolver.getZeroValue()) > 0;
        }
    }

    private class MouseEnterEvent
    implements Listener {
        private MouseEnterEvent() {
        }

        public void handleEvent(@Nullable Event event) {
            if (event == null) {
                return;
            }
            Control control = (Control)event.widget;
            Point display = control.toDisplay(event.x, event.y);
            Point location = SwtXYChartViewer.this.getChart().getParent().toControl(display);
            boolean inside = SwtXYChartViewer.this.getChart().getBounds().contains(location);
            boolean shell = control.getShell().equals(SwtXYChartViewer.this.getChart().getShell());
            SwtXYChartViewer.this.fCloseButton.setVisible(inside && shell);
        }
    }

    private class MouseExitEvent
    implements Listener {
        private MouseExitEvent() {
        }

        public void handleEvent(@Nullable Event event) {
            SwtXYChartViewer.this.fCloseButton.setVisible(false);
        }
    }

    private class ResizeEvent
    implements ControlListener {
        private ResizeEvent() {
        }

        public void controlMoved(@Nullable ControlEvent e) {
        }

        public void controlResized(@Nullable ControlEvent e) {
            SwtXYChartViewer.this.refreshDisplayTitles();
            SwtXYChartViewer.this.refreshDisplayLabels();
            SwtXYChartViewer.this.fCloseButton.setLocation(((SwtXYChartViewer)SwtXYChartViewer.this).fChart.getSize().x - ((SwtXYChartViewer)SwtXYChartViewer.this).fCloseButton.getSize().x - 5, 5);
        }
    }
}

