/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class SoftIrqExitHandler
extends KernelEventHandler {
    public SoftIrqExitHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        Integer cpu = KernelEventHandlerUtils.getCpu(event);
        if (cpu == null) {
            return;
        }
        Integer softIrqId = ((Long)event.getContent().getField(new String[]{this.getLayout().fieldVec()}).getValue()).intValue();
        int currentThreadNode = KernelEventHandlerUtils.getCurrentThreadNode(cpu, ss);
        int quark = ss.getQuarkRelativeAndAdd(KernelEventHandlerUtils.getNodeSoftIRQs(cpu, ss), new String[]{softIrqId.toString()});
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        boolean softIrqRaised = SoftIrqExitHandler.isSoftIrqRaised(ss.queryOngoingState(quark));
        ss.modifyAttribute(timestamp, (ITmfStateValue)(softIrqRaised ? StateValues.SOFT_IRQ_RAISED_VALUE : TmfStateValue.nullValue()), quark);
        int aggregateQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Soft_IRQs", softIrqId.toString()});
        ITmfStateValue aggregateValue = KernelEventHandlerUtils.getAggregate(ss, "Soft_IRQs", softIrqId);
        ss.modifyAttribute(timestamp, aggregateValue, aggregateQuark);
        KernelEventHandlerUtils.updateCpuStatus(timestamp, cpu, ss);
        List softIrqs = ss.getSubAttributes(ss.getParentAttributeQuark(quark), false);
        for (Integer softIrq : softIrqs) {
            if (ss.queryOngoingState(softIrq.intValue()).isNull()) continue;
            return;
        }
        KernelEventHandlerUtils.setProcessToRunning(timestamp, currentThreadNode, ss);
    }

    private static boolean isSoftIrqRaised(@Nullable ITmfStateValue state) {
        return state != null && !state.isNull() && (state.unboxInt() & 1) == 1;
    }
}

