/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore;

import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.Activator;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.SeriesModel;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SegmentStoreScatterDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfTreeXYDataProvider<TmfTreeDataModel> {
    public static final String ID = "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.scatter.dataprovider";
    private static final Map<ISegmentStoreProvider, SegmentStoreScatterDataProvider> PROVIDER_MAP = new WeakHashMap<ISegmentStoreProvider, SegmentStoreScatterDataProvider>();
    private static final String DEFAULT_CATEGORY = "default";
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private final ISegmentStoreProvider fProvider;
    private final String fId;
    private final BiMap<Long, String> fIdToType = HashBiMap.create();
    private final long fTraceId = ENTRY_ID.getAndIncrement();

    @Deprecated
    public static synchronized @Nullable SegmentStoreScatterDataProvider create(ITmfTrace trace, @Nullable ISegmentStoreProvider provider) {
        if (provider == null) {
            return null;
        }
        return PROVIDER_MAP.computeIfAbsent(provider, p -> {
            if (p instanceof IAnalysisModule) {
                ((IAnalysisModule)p).schedule();
            }
            return new SegmentStoreScatterDataProvider(trace, (ISegmentStoreProvider)p, "");
        });
    }

    public static @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> create(ITmfTrace trace, String secondaryId) {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ISegmentStoreProvider.class);
        Iterable filteredModules = Iterables.filter((Iterable)modules, m -> ((IAnalysisModule)m).getId().equals(secondaryId));
        Iterator iterator = filteredModules.iterator();
        if (iterator.hasNext()) {
            ISegmentStoreProvider module = (ISegmentStoreProvider)iterator.next();
            if (iterator.hasNext()) {
                return null;
            }
            ((IAnalysisModule)module).schedule();
            return new SegmentStoreScatterDataProvider(trace, module, secondaryId);
        }
        return null;
    }

    private SegmentStoreScatterDataProvider(ITmfTrace trace, ISegmentStoreProvider provider, String secondaryId) {
        super(trace);
        this.fProvider = provider;
        this.fId = "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.scatter.dataprovider:" + secondaryId;
    }

    public TmfModelResponse<List<TmfTreeDataModel>> fetchTree(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        ISegmentStoreProvider provider = this.fProvider;
        ISegmentStore<ISegment> segStore = provider.getSegmentStore();
        if (segStore == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        long start = filter.getStart();
        long end = filter.getEnd();
        Predicate startInRangePredication = s -> s.getStart() >= start;
        Iterable intersectingElements = Iterables.filter((Iterable)segStore.getIntersectingElements(start, end), (Predicate)startInRangePredication);
        HashSet<String> segmentTypes = new HashSet<String>();
        IAnalysisModule module = provider instanceof IAnalysisModule ? (IAnalysisModule)provider : null;
        boolean complete = module == null ? true : module.isQueryable(filter.getEnd());
        for (INamedSegment segment : Iterables.filter((Iterable)intersectingElements, INamedSegment.class)) {
            if (monitor != null && monitor.isCanceled()) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            segmentTypes.add(segment.getName());
        }
        ImmutableList.Builder nodes = new ImmutableList.Builder();
        nodes.add((Object)new TmfTreeDataModel(this.fTraceId, -1L, String.valueOf(this.getTrace().getName())));
        for (String seriesName : segmentTypes) {
            long seriesId = this.getUniqueId(seriesName);
            nodes.add((Object)new TmfTreeDataModel(seriesId, this.fTraceId, seriesName));
        }
        return new TmfModelResponse((Object)nodes.build(), complete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING, complete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING);
    }

    public TmfModelResponse<ITmfXyModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        ISegmentStoreProvider provider = this.fProvider;
        if (provider instanceof IAnalysisModule && !((IAnalysisModule)provider).waitForCompletion()) {
            return TmfXyResponseFactory.createFailedResponse((String)CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        ISegmentStore<ISegment> segStore = provider.getSegmentStore();
        if (segStore == null) {
            return TmfXyResponseFactory.createFailedResponse((String)Messages.SegmentStoreDataProvider_SegmentNotAvailable);
        }
        long start = filter.getStart();
        long end = filter.getEnd();
        String prefix = String.valueOf(this.getTrace().getName()) + '/';
        Map<String, Series> types = this.initTypes(prefix, filter);
        if (types.isEmpty()) {
            return TmfXyResponseFactory.create((String)Objects.requireNonNull(Messages.SegmentStoreScatterGraphViewer_title), Collections.emptyMap(), (boolean)true);
        }
        CheckSegmentType predicate = new CheckSegmentType(prefix, types.keySet());
        long pixelSize = Math.max(1L, (end - start) / (long)filter.getTimesRequested().length);
        Iterable intersectingElements = Iterables.filter((Iterable)segStore.getIntersectingElements(start, end, SegmentComparators.INTERVAL_START_COMPARATOR), (Predicate)predicate);
        Iterable<ISegment> displayData = SegmentStoreScatterDataProvider.compactList(start, intersectingElements, pixelSize);
        IAnalysisModule module = this.fProvider instanceof IAnalysisModule ? (IAnalysisModule)this.fProvider : null;
        boolean complete = module == null ? true : module.isQueryable(filter.getEnd());
        for (ISegment segment : displayData) {
            if (monitor != null && monitor.isCanceled()) {
                return TmfXyResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
            }
            String name = String.valueOf(prefix) + SegmentStoreScatterDataProvider.getSegmentName(segment);
            Series thisSeries = types.get(name);
            if (thisSeries == null) {
                Activator.getInstance().logError("Series " + thisSeries + " should exist");
                continue;
            }
            thisSeries.addPoint(segment.getStart(), segment.getLength());
        }
        HashMap model = new HashMap();
        types.entrySet().forEach(entry -> {
            SeriesModel seriesModel = model.put((String)entry.getKey(), new SeriesModel((String)entry.getKey(), ((Series)entry.getValue()).getXValues(), ((Series)entry.getValue()).getYValues()));
        });
        return TmfXyResponseFactory.create((String)Objects.requireNonNull(Messages.SegmentStoreScatterGraphViewer_title), model, (boolean)complete);
    }

    private static String getSegmentName(ISegment segment) {
        return segment instanceof INamedSegment ? ((INamedSegment)segment).getName() : DEFAULT_CATEGORY;
    }

    private Map<String, Series> initTypes(String prefix, TimeQueryFilter filter) {
        if (!(filter instanceof SelectionTimeQueryFilter)) {
            return Collections.emptyMap();
        }
        HashMap<String, Series> segmentTypes = new HashMap<String, Series>();
        for (Long id : ((SelectionTimeQueryFilter)filter).getSelectedItems()) {
            String string = (String)this.fIdToType.get((Object)id);
            if (string == null) continue;
            segmentTypes.put(String.valueOf(prefix) + string, new Series());
        }
        return segmentTypes;
    }

    private long getUniqueId(String name) {
        return (Long)this.fIdToType.inverse().computeIfAbsent((Object)name, n -> ENTRY_ID.getAndIncrement());
    }

    private static Iterable<ISegment> compactList(long startTime, Iterable<@NonNull ISegment> iterableToCompact, long pixelSize) {
        return () -> new SegmentStoreIterator(startTime, iterableToCompact, pixelSize);
    }

    public String getId() {
        return this.fId;
    }

    private static class CheckSegmentType
    implements Predicate<ISegment> {
        private final Set<String> fSelectedTypes;
        private final String fPrefix;

        public CheckSegmentType(String prefix, Set<String> selectedTypes) {
            this.fSelectedTypes = selectedTypes;
            this.fPrefix = prefix;
        }

        public boolean apply(ISegment segment) {
            if (!(segment instanceof INamedSegment)) {
                return false;
            }
            return this.fSelectedTypes.contains(String.valueOf(this.fPrefix) + ((INamedSegment)segment).getName());
        }
    }

    private static class SegmentStoreIterator
    implements Iterator<ISegment> {
        private final Map<String, ISegment> fLasts = new HashMap<String, ISegment>();
        private @Nullable ISegment fNext = null;
        private final Iterator<@NonNull ISegment> fIterator;
        private final long fStartTime;
        private final long fPixelSize;

        public SegmentStoreIterator(long startTime, Iterable<@NonNull ISegment> iterableToCompact, long pixelSize) {
            this.fStartTime = startTime;
            this.fIterator = Objects.requireNonNull(iterableToCompact.iterator());
            this.fPixelSize = Math.max(1L, pixelSize);
        }

        @Override
        public @NonNull ISegment next() {
            if (this.hasNext()) {
                ISegment segment = Objects.requireNonNull(this.fNext);
                this.fLasts.put(SegmentStoreScatterDataProvider.getSegmentName(segment), segment);
                this.fNext = null;
                return segment;
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean hasNext() {
            if (this.fLasts.isEmpty() && this.fNext == null) {
                if (!this.fIterator.hasNext()) {
                    return false;
                }
                ISegment segment = this.fIterator.next();
                if (segment.getStart() >= this.fStartTime) {
                    this.fNext = segment;
                }
            }
            while (this.fNext == null && this.fIterator.hasNext()) {
                ISegment tmp = this.fIterator.next();
                ISegment last = this.fLasts.get(SegmentStoreScatterDataProvider.getSegmentName(tmp));
                if (tmp.getStart() < this.fStartTime || this.overlaps(last, tmp)) continue;
                this.fNext = tmp;
            }
            return this.fNext != null;
        }

        private boolean overlaps(@Nullable ISegment last, ISegment next) {
            if (last == null) {
                return false;
            }
            long timePerPix = this.fPixelSize;
            long start = last.getStart();
            long pixelStart = this.fStartTime;
            long pixelDuration = start - pixelStart;
            long startPixBoundL = pixelDuration / timePerPix * timePerPix + pixelStart;
            long startPixBoundR = startPixBoundL + timePerPix;
            long currentStart = next.getStart();
            if (currentStart >= startPixBoundL && currentStart <= startPixBoundR) {
                long length = last.getLength();
                long lengthNext = next.getLength();
                long lengthLow = length / timePerPix * timePerPix;
                long lengthHigh = lengthLow + timePerPix;
                return lengthNext >= lengthLow && lengthNext <= lengthHigh;
            }
            return false;
        }
    }

    private static class Series {
        private final List<Long> fXValues = new ArrayList<Long>();
        private final List<Double> fYValues = new ArrayList<Double>();

        private Series() {
        }

        public long[] getXValues() {
            return Longs.toArray(this.fXValues);
        }

        public double[] getYValues() {
            return Doubles.toArray(this.fYValues);
        }

        public void addPoint(long x, double y) {
            this.fXValues.add(x);
            this.fYValues.add(y);
        }
    }
}

