/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tracing.rcp.ui;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tracing.rcp.ui.TracingRcpPlugin;
import org.eclipse.tracecompass.internal.tracing.rcp.ui.messages.Messages;
import org.eclipse.ui.splash.BasicSplashHandler;

public class SplashHandler
extends BasicSplashHandler {
    private static final Point VERSION_LOCATION = new Point(10, 280);
    private static final Rectangle PROCESS_BAR_RECTANGLE = new Rectangle(10, 300, 480, 15);
    private static final RGB FOREGROUND_COLOR = new RGB(255, 255, 255);

    public void init(Shell splash) {
        super.init(splash);
        String progressString = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            progressString = product.getProperty("startupProgressRect");
        }
        Rectangle progressRect = StringConverter.asRectangle(progressString, (Rectangle)PROCESS_BAR_RECTANGLE);
        this.setProgressRect(progressRect);
        this.setForeground(FOREGROUND_COLOR);
        this.getContent().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(SplashHandler.this.getForeground());
                e.gc.drawText(NLS.bind((String)Messages.SplahScreen_VersionString, (Object)TracingRcpPlugin.getDefault().getBundle().getVersion().toString()), VERSION_LOCATION.x, VERSION_LOCATION.y, true);
            }
        });
    }
}

