/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfTimeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.XYChartLegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfFilteredXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.ITimeReset;
import org.eclipse.tracecompass.tmf.ui.views.ITmfAllowMultiple;
import org.eclipse.tracecompass.tmf.ui.views.ITmfPinnable;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.ManyEntriesSelectedDialogPreCheckedListener;
import org.eclipse.tracecompass.tmf.ui.views.ResetUtil;
import org.eclipse.tracecompass.tmf.ui.views.SaveImageUtil;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.TriStateFilteredCheckboxTree;

public abstract class TmfChartView
extends TmfView
implements ITmfTimeAligned,
ITimeReset,
ITmfPinnable,
ITmfAllowMultiple {
    private static final int[] DEFAULT_WEIGHTS = new int[]{1, 3};
    private TmfXYChartViewer fChartViewer;
    private Composite fXYViewerContainer;
    private TmfViewer fTmfViewer;
    private SashForm fSashForm;
    private Listener fSashDragListener;
    private String fOriginalTabLabel;
    private final Action fResetScaleAction = ResetUtil.createResetAction(this);

    public TmfChartView(String viewName) {
        super(viewName);
    }

    protected TmfXYChartViewer getChartViewer() {
        return this.fChartViewer;
    }

    protected TmfViewer getLeftChildViewer() {
        return this.fTmfViewer;
    }

    protected @NonNull TmfViewer createLeftChildViewer(Composite parent) {
        return new EmptyViewer(parent);
    }

    protected abstract TmfXYChartViewer createChartViewer(Composite var1);

    @Override
    public ITmfTrace getTrace() {
        TmfXYChartViewer chartViewer = this.getChartViewer();
        if (chartViewer != null) {
            return chartViewer.getTrace();
        }
        return null;
    }

    @Deprecated
    protected void setTrace(ITmfTrace trace) {
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fSashForm = new SashForm(parent, 0);
        this.fTmfViewer = this.createLeftChildViewer((Composite)this.fSashForm);
        this.fXYViewerContainer = new Composite((Composite)this.fSashForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fXYViewerContainer.setLayout((Layout)layout);
        this.fChartViewer = this.createChartViewer(this.fXYViewerContainer);
        this.fChartViewer.setSendTimeAlignSignals(true);
        this.fChartViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fChartViewer.getSwtChart().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                super.mouseDoubleClick(e);
                TmfChartView.this.resetStartFinishTime();
            }
        });
        this.fChartViewer.getControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TmfChartView.this.fSashDragListener == null) {
                    Control[] controlArray = TmfChartView.this.fSashForm.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof Sash) {
                            TmfChartView.this.fSashDragListener = event -> TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(TmfChartView.this.fSashForm, TmfChartView.this.getTimeViewAlignmentInfo()));
                            control.removePaintListener((PaintListener)this);
                            control.addListener(13, TmfChartView.this.fSashDragListener);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
        this.fSashForm.setWeights(DEFAULT_WEIGHTS);
        this.getViewSite().getActionBars().getToolBarManager().appendToGroup("additions", (IAction)this.fResetScaleAction);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            this.loadTrace();
        }
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fChartViewer.setStatusLineManager(statusLineManager);
        this.fOriginalTabLabel = this.getPartName();
        this.coupleSelectViewer();
    }

    @Override
    protected IAction createSaveAction() {
        return SaveImageUtil.createSaveAction(this.getName(), this::getChartViewer);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fChartViewer != null) {
            this.fChartViewer.dispose();
        }
        if (this.fTmfViewer != null) {
            this.fTmfViewer.dispose();
        }
    }

    public void setFocus() {
        this.fChartViewer.getControl().setFocus();
    }

    protected void loadTrace() {
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            TmfXYChartViewer chartViewer;
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            TmfViewer leftViewer = this.getLeftChildViewer();
            if (leftViewer instanceof TmfTimeViewer) {
                ((TmfTimeViewer)leftViewer).traceSelected(signal);
            }
            if ((chartViewer = this.getChartViewer()) != null) {
                chartViewer.traceSelected(signal);
            }
        }
    }

    @Override
    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fChartViewer == null) {
            return null;
        }
        return new TmfTimeViewAlignmentInfo(this.fChartViewer.getControl().getShell(), this.fSashForm.toDisplay(0, 0), this.getTimeAxisOffset());
    }

    private int getTimeAxisOffset() {
        return this.fSashForm.getChildren()[0].getSize().x + this.fSashForm.getSashWidth() + this.fChartViewer.getPointAreaOffset();
    }

    @Override
    public int getAvailableWidth(int requestedOffset) {
        if (this.fChartViewer == null) {
            return 0;
        }
        int pointAreaWidth = this.fChartViewer.getPointAreaWidth();
        int curTimeAxisOffset = this.getTimeAxisOffset();
        if (pointAreaWidth <= 0) {
            pointAreaWidth = this.fSashForm.getBounds().width - curTimeAxisOffset;
        }
        int endOffset = curTimeAxisOffset + pointAreaWidth;
        GridLayout layout = (GridLayout)this.fXYViewerContainer.getLayout();
        int endOffsetWithoutMargin = endOffset + layout.marginRight;
        int availableWidth = endOffsetWithoutMargin - requestedOffset;
        availableWidth = Math.min(this.fSashForm.getBounds().width, Math.max(0, availableWidth));
        return availableWidth;
    }

    @Override
    public void performAlign(int offset, int width) {
        int total = this.fSashForm.getBounds().width;
        int plotAreaOffset = this.fChartViewer.getPointAreaOffset();
        int width1 = Math.max(0, offset - plotAreaOffset - this.fSashForm.getSashWidth());
        int width2 = Math.max(0, total - width1 - this.fSashForm.getSashWidth());
        if (width1 >= 0 && width2 > 0 || width1 > 0 && width2 >= 0) {
            this.fSashForm.setWeights(new int[]{width1, width2});
            this.fSashForm.layout();
        }
        Composite composite = this.fXYViewerContainer;
        GridLayout layout = (GridLayout)composite.getLayout();
        int timeAxisWidth = this.getAvailableWidth(offset);
        int marginSize = timeAxisWidth - width;
        layout.marginRight = Math.max(0, marginSize);
        composite.layout();
    }

    @Override
    public void resetStartFinishTime(boolean notify) {
        TmfWindowRangeUpdatedSignal signal = new TmfWindowRangeUpdatedSignal((Object)this, TmfTimeRange.ETERNITY, this.getTrace());
        if (notify) {
            this.broadcast((TmfSignal)signal);
        } else {
            this.getChartViewer().windowRangeUpdated(signal);
        }
    }

    @Override
    public void setPinned(@Nullable ITmfTrace trace) {
        TmfXYChartViewer chartViewer;
        TmfViewer leftViewer = this.getLeftChildViewer();
        if (leftViewer instanceof ITmfPinnable) {
            ((ITmfPinnable)((Object)leftViewer)).setPinned(trace);
        }
        if ((chartViewer = this.getChartViewer()) != null) {
            chartViewer.setPinned(trace);
        }
        if (trace != null) {
            TmfSignalManager.addIgnoredInboundSignal((Object)this, TmfTraceOpenedSignal.class);
            TmfSignalManager.addIgnoredInboundSignal((Object)this, TmfTraceSelectedSignal.class);
            this.setPartName(String.format("%s <%s>", this.fOriginalTabLabel, TmfTraceManager.getInstance().getTraceUniqueName(trace)));
        } else {
            TmfSignalManager.removeIgnoredInboundSignal((Object)this, TmfTraceOpenedSignal.class);
            TmfSignalManager.removeIgnoredInboundSignal((Object)this, TmfTraceSelectedSignal.class);
            this.setPartName(this.fOriginalTabLabel);
        }
        if (this.fPinAction != null) {
            this.fPinAction.setPinnedTrace(trace);
        }
    }

    public boolean isDirty() {
        return this.fChartViewer.isDirty();
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        ITmfTrace trace = this.getTrace();
        if ((trace == null || signal.getTrace() == trace) && this.isPinned()) {
            this.setPinned(null);
        }
    }

    private void coupleSelectViewer() {
        TmfViewer tree = this.getLeftChildViewer();
        TmfXYChartViewer chart = this.getChartViewer();
        if (tree instanceof AbstractSelectTreeViewer && chart instanceof TmfFilteredXYChartViewer) {
            XYChartLegendImageProvider legendImageProvider = new XYChartLegendImageProvider((TmfCommonXAxisChartViewer)chart);
            AbstractSelectTreeViewer selectTree = (AbstractSelectTreeViewer)tree;
            selectTree.setTreeListener((TmfFilteredXYChartViewer)chart);
            selectTree.setLegendImageProvider(legendImageProvider);
            TriStateFilteredCheckboxTree checkboxTree = selectTree.getTriStateFilteredCheckboxTree();
            checkboxTree.setPreCheckStateListener(new ManyEntriesSelectedDialogPreCheckedListener(checkboxTree));
        }
    }

    private class EmptyViewer
    extends TmfViewer {
        private Composite fComposite;

        public EmptyViewer(Composite parent) {
            super(parent);
            this.fComposite = new Composite(parent, 0);
        }

        @Override
        public void refresh() {
        }

        @Override
        public Control getControl() {
            return this.fComposite;
        }
    }
}

