/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.XmlViewInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph.XmlPresentationProvider;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlDataProviderManager;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlTimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.TmfViewFactory;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.w3c.dom.Element;

public class XmlTimeGraphView
extends BaseDataProviderTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph";
    private static final String[] DEFAULT_COLUMN_NAMES = new String[]{Messages.XmlTimeGraphView_ColumnName, Messages.XmlTimeGraphView_ColumnId, Messages.XmlTimeGraphView_ColumnParentId};
    private static final String[] DEFAULT_FILTER_COLUMN_NAMES = new String[]{Messages.XmlTimeGraphView_ColumnName, Messages.XmlTimeGraphView_ColumnId};
    private static final int[] fWeight = new int[]{1, 2};
    private static final String EMPTY_STRING = "";
    private static final Comparator<XmlTimeGraphEntryModel> XML_ENTRY_COMPARATOR = Comparator.comparing(XmlTimeGraphEntryModel::getPath, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(TmfTreeDataModel::getName).thenComparingLong(TimeGraphEntryModel::getStartTime);
    private static final Comparator<ITimeGraphEntry> ENTRY_COMPARATOR = Comparator.comparing(x -> (XmlTimeGraphEntryModel)((TimeGraphEntry)x).getModel(), XML_ENTRY_COMPARATOR);
    private final @NonNull XmlViewInfo fViewInfo = new XmlViewInfo("org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph");
    private final Map<String, Integer> fStringValueMap = new HashMap<String, Integer>();

    public XmlTimeGraphView() {
        super(ID, (TimeGraphPresentationProvider)new XmlPresentationProvider(), "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlTimeGraphDataProvider");
        this.setWeight(fWeight);
        this.setTreeColumns(DEFAULT_COLUMN_NAMES);
        this.setTreeLabelProvider(new XmlTreeLabelProvider());
        this.setFilterColumns(DEFAULT_FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new XmlTreeLabelProvider());
        this.setEntryComparator(ENTRY_COMPARATOR);
        this.addPartPropertyListener(event -> {
            Object newValue = event.getNewValue();
            if (event.getProperty().equals("xmlOutputData") && newValue instanceof String) {
                String data = (String)newValue;
                this.fViewInfo.setViewData(data);
                this.rebuild();
            }
        });
    }

    public void createPartControl(Composite parent) {
        String name = this.getViewSite().getSecondaryId();
        if (name != null) {
            name = TmfViewFactory.getBaseSecId((String)name);
        }
        if (name != null) {
            this.fViewInfo.setName(name);
        }
        super.createPartControl(parent);
    }

    private void setViewTitle(String title) {
        Display.getDefault().asyncExec(() -> this.setPartName(title));
    }

    protected String getNextText() {
        return Messages.XmlTimeGraphView_NextText;
    }

    protected String getNextTooltip() {
        return Messages.XmlTimeGraphView_NextTooltip;
    }

    protected String getPrevText() {
        return Messages.XmlTimeGraphView_PreviousText;
    }

    protected String getPrevTooltip() {
        return Messages.XmlTimeGraphView_PreviousInterval;
    }

    protected XmlPresentationProvider getPresentationProvider() {
        return (XmlPresentationProvider)super.getPresentationProvider();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        String title;
        Element viewElement = this.fViewInfo.getViewElement("timeGraphView");
        if (viewElement == null) {
            return;
        }
        XmlPresentationProvider pres = this.getPresentationProvider();
        if (pres instanceof XmlPresentationProvider) {
            pres.loadNewStates(viewElement);
        }
        this.setViewTitle((title = this.fViewInfo.getViewTitle(viewElement)) != null ? title : Messages.XmlTimeGraphView_DefaultTitle);
        this.fStringValueMap.clear();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        boolean complete = false;
        @NonNull ITimeGraphDataProvider provider = XmlDataProviderManager.getInstance().getTimeGraphProvider(trace, viewElement);
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        while (!complete && !subMonitor.isCanceled()) {
            TmfModelResponse response = provider.fetchTree(new TimeQueryFilter(0L, Long.MAX_VALUE, 2), (IProgressMonitor)subMonitor);
            if (response.getStatus() == ITmfResponse.Status.FAILED) {
                Activator.logError("XML Time Graph Data Provider failed: " + response.getStatusMessage());
                return;
            }
            if (response.getStatus() == ITmfResponse.Status.CANCELLED) {
                return;
            }
            complete = response.getStatus() == ITmfResponse.Status.COMPLETED;
            List model = (List)response.getModel();
            if (model != null) {
                for (XmlTimeGraphEntryModel entry : model) {
                    TimeGraphEntry tgEntry = (TimeGraphEntry)map.get(entry.getId());
                    if (tgEntry != null) {
                        tgEntry.updateModel((TimeGraphEntryModel)entry);
                    }
                    if (entry.getParentId() != -1L && tgEntry == null) {
                        map.put(entry.getId(), new TimeGraphEntry((TimeGraphEntryModel)entry));
                        continue;
                    }
                    if (tgEntry == null) {
                        BaseDataProviderTimeGraphView.TraceEntry traceEntry = new BaseDataProviderTimeGraphView.TraceEntry((TimeGraphEntryModel)entry, trace, provider);
                        this.addToEntryList(parentTrace, Collections.singletonList(traceEntry));
                        map.put(entry.getId(), traceEntry);
                    }
                    this.setStartTime(Long.min(this.getStartTime(), entry.getStartTime()));
                    this.setEndTime(Long.max(this.getEndTime(), entry.getEndTime()));
                }
                for (TimeGraphEntry child : map.values()) {
                    TimeGraphEntry parent = (TimeGraphEntry)map.get(child.getModel().getParentId());
                    if (parent == null) continue;
                    parent.addChild(child);
                }
                long start = this.getStartTime();
                long end = this.getEndTime();
                long resolution = Long.max(1L, (end - start) / (long)this.getDisplayWidth());
                this.zoomEntries(map.values(), start, end, resolution, (IProgressMonitor)subMonitor);
            }
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            subMonitor.worked(1);
            if (complete) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Activator.logError("Failed to wait for data provider", e);
            }
        }
    }

    protected TimeEvent createTimeEvent(TimeGraphEntry entry, ITimeGraphState state) {
        String label = state.getLabel();
        if (state.getValue() == Integer.MIN_VALUE && label != null) {
            int status = this.getStringIndex(label);
            return new TimeEvent((ITimeGraphEntry)entry, state.getStartTime(), state.getDuration(), status);
        }
        int status = (int)state.getValue();
        XmlPresentationProvider pres = this.getPresentationProvider();
        if (label != null && !pres.hasIndex(status) && !label.equals(String.valueOf(-1))) {
            status = this.getStringIndex(label);
        }
        return new TimeEvent((ITimeGraphEntry)entry, state.getStartTime(), state.getDuration(), status);
    }

    private int getStringIndex(String state) {
        return this.fStringValueMap.computeIfAbsent(state, s -> this.getPresentationProvider().addState((String)s));
    }

    private static class XmlTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private XmlTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TimeGraphEntry) {
                TimeGraphEntry entry = (TimeGraphEntry)element;
                if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnName)) {
                    return entry.getName();
                }
                ITimeGraphEntryModel model = entry.getModel();
                if (model instanceof XmlTimeGraphEntryModel) {
                    XmlTimeGraphEntryModel xmlModel = (XmlTimeGraphEntryModel)model;
                    if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnId)) {
                        return xmlModel.getXmlId();
                    }
                    if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnParentId)) {
                        return xmlModel.getXmlParentId();
                    }
                }
            }
            return XmlTimeGraphView.EMPTY_STRING;
        }
    }
}

