/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.analysis.lami.ui.Activator;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.LamiTableViewer;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiReportViewTabPage;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartData;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartModel;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartType;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.ui.chart.IChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;

public final class LamiViewerControl {
    private final Action fToggleAction;
    private @Nullable TmfViewer fViewer;

    public LamiViewerControl(final Composite parent, final LamiReportViewTabPage page) {
        this.fToggleAction = new Action(){

            public void run() {
                TmfViewer viewer = LamiViewerControl.this.fViewer;
                if (viewer == null) {
                    LamiViewerControl.this.fViewer = (TmfViewer)LamiTableViewer.createLamiTable(parent, page);
                } else {
                    viewer.dispose();
                    LamiViewerControl.this.fViewer = null;
                }
                parent.layout();
            }
        };
        this.fToggleAction.setText(Messages.LamiReportView_ActivateTableAction_ButtonName);
        this.fToggleAction.setToolTipText(Messages.LamiReportView_ActivateTableAction_ButtonTooltip);
        this.fToggleAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/table.gif"));
    }

    public LamiViewerControl(final Composite parent, final ChartData data, final ChartModel model) {
        this.fToggleAction = new Action(){

            public void run() {
                TmfViewer viewer = LamiViewerControl.this.fViewer;
                if (viewer == null) {
                    LamiViewerControl.this.fViewer = (TmfViewer)IChartViewer.createChart((Composite)parent, (ChartData)data, (ChartModel)model);
                } else {
                    viewer.dispose();
                    LamiViewerControl.this.fViewer = null;
                }
                parent.layout();
            }
        };
        this.fToggleAction.setText(String.valueOf(Messages.LamiReportView_ToggleAction_ButtonNamePrefix) + ' ' + model.getTitle());
        this.fToggleAction.setToolTipText(Messages.LamiReportView_ToggleAction_ButtonTooltip);
        this.fToggleAction.setImageDescriptor(LamiViewerControl.getIconForGraphType(model.getChartType()));
    }

    public @Nullable TmfViewer getViewer() {
        return this.fViewer;
    }

    public Action getToggleAction() {
        return this.fToggleAction;
    }

    public void dispose() {
        if (this.fViewer != null) {
            this.fViewer.dispose();
        }
    }

    private static @Nullable ImageDescriptor getIconForGraphType(ChartType chartType) {
        switch (chartType) {
            case BAR_CHART: {
                return Activator.getDefault().getImageDescripterFromPath("icons/histogram.gif");
            }
        }
        return Activator.getDefault().getImageDescripterFromPath("icons/histogram.gif");
    }
}

