/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.AbstractTreeDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTimeGraphDataProvider<A extends TmfStateSystemAnalysisModule, M extends ITimeGraphEntryModel>
extends AbstractTreeDataProvider<A, M>
implements ITimeGraphDataProvider<M> {
    public AbstractTimeGraphDataProvider(ITmfTrace trace, A analysisModule) {
        super(trace, analysisModule);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final TmfModelResponse<List<ITimeGraphRowModel>> fetchRowModel(SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Object module = this.getAnalysisModule();
        if (!((TmfStateSystemAnalysisModule)module).waitForInitialization()) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        ITmfStateSystem ss = ((TmfStateSystemAnalysisModule)module).getStateSystem();
        if (ss == null) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        long currentEnd = ss.getCurrentEndTime();
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try {
                TmfModelResponse<Object> tmfModelResponse;
                TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "AbstractTimeGraphDataProvider#fetchRowModel", new Object[0]).setCategory(this.getClass().getSimpleName()).build();
                try {
                    List<ITimeGraphRowModel> models = this.getRowModel(ss, filter, monitor);
                    if (models == null) {
                        tmfModelResponse = new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                        return tmfModelResponse;
                    }
                    return new TmfModelResponse<List<ITimeGraphRowModel>>(models, complete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING, complete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (scope == null) return tmfModelResponse;
                    scope.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, String.valueOf(e.getMessage()));
        }
    }

    protected abstract @Nullable List<ITimeGraphRowModel> getRowModel(ITmfStateSystem var1, SelectionTimeQueryFilter var2, @Nullable IProgressMonitor var3) throws StateSystemDisposedException;
}

