/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.remote.core.proxy;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.tracecompass.internal.tmf.remote.core.shell.CommandShell;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandShell;

@NonNullByDefault
public class RemoteSystemProxy
implements IRemoteConnectionChangeListener {
    private final IRemoteConnection fHost;
    private boolean fExplicitConnect;

    public RemoteSystemProxy(IRemoteConnection host) {
        this.fHost = host;
        this.fHost.addConnectionChangeListener((IRemoteConnectionChangeListener)this);
    }

    public IRemoteConnection getRemoteConnection() {
        return this.fHost;
    }

    public void connect(IProgressMonitor monitor) throws ExecutionException {
        try {
            if (!this.fHost.isOpen()) {
                this.fHost.open(monitor);
                this.fExplicitConnect = true;
            }
        }
        catch (RemoteConnectionException e) {
            throw new ExecutionException("Cannot connect " + this.fHost.getName(), (Throwable)e);
        }
    }

    public void disconnect() {
        if (this.fExplicitConnect) {
            this.fHost.close();
            this.fExplicitConnect = false;
        }
    }

    public void dispose() {
        this.fHost.removeConnectionChangeListener((IRemoteConnectionChangeListener)this);
        this.disconnect();
    }

    public ICommandShell createCommandShell() {
        return new CommandShell(this.fHost);
    }

    public boolean isConnected() {
        return this.fHost.isOpen();
    }

    public void connectionChanged(@Nullable RemoteConnectionChangeEvent event) {
        int type;
        if (event != null && ((type = event.getType()) == 4 || type == 1)) {
            this.fExplicitConnect = false;
        }
    }
}

