/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.ZipResource;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipScanner
extends ArchiveScanner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillMapsFromArchive(Resource src, String encoding, Map<String, Resource> fileEntries, Map<String, Resource> matchFileEntries, Map<String, Resource> dirEntries, Map<String, Resource> matchDirEntries) {
        ZipEntry entry = null;
        ZipFile zf = null;
        File srcFile = null;
        FileProvider fp = src.as(FileProvider.class);
        if (fp == null) {
            throw new BuildException("Only file provider resources are supported");
        }
        srcFile = fp.getFile();
        try {
            try {
                zf = new ZipFile(srcFile, encoding);
            }
            catch (ZipException ex) {
                throw new BuildException("Problem reading " + srcFile, ex);
            }
            catch (IOException ex) {
                throw new BuildException("Problem opening " + srcFile, ex);
            }
            Enumeration<ZipEntry> e = zf.getEntries();
            while (e.hasMoreElements()) {
                entry = e.nextElement();
                ZipResource r = new ZipResource(srcFile, encoding, entry);
                String name = entry.getName();
                if (entry.isDirectory()) {
                    name = ZipScanner.trimSeparator(name);
                    dirEntries.put(name, r);
                    if (!this.match(name)) continue;
                    matchDirEntries.put(name, r);
                    continue;
                }
                fileEntries.put(name, r);
                if (!this.match(name)) continue;
                matchFileEntries.put(name, r);
            }
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly(zf);
    }
}

