/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveTraceFromExperimentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Shell shell = window.getShell();
        MessageDialog dialog = new MessageDialog(shell, Messages.RemoveDialog_Title, null, Messages.RemoveTraceFromExperimentHandler_Message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1){
            {
                this.setShellStyle(0x10000000);
            }
        };
        if (dialog.open() != 0) {
            return null;
        }
        final List list = ((IStructuredSelection)selection).toList();
        final int nbElements = list.size();
        TmfWorkspaceModifyOperation operation = new TmfWorkspaceModifyOperation(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)nbElements);
                for (Object element : list) {
                    SubMonitor elementSubMonitor = subMonitor.split(1);
                    if (element instanceof TmfTraceElement) {
                        TmfTraceElement trace = (TmfTraceElement)element;
                        if (!trace.getResource().exists()) continue;
                        subMonitor.setTaskName(String.valueOf(Messages.RemoveTraceFromExperimentHandler_TaskName) + " " + trace.getElementPath());
                        try {
                            trace.delete((IProgressMonitor)elementSubMonitor);
                        }
                        catch (CoreException e) {
                            Display.getDefault().asyncExec(() -> {
                                int n = ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, String.valueOf(Messages.RemoveTraceFromExperimentHandler_Error) + ' ' + trace.getName(), (Throwable)e));
                            });
                            Activator.getDefault().logError(String.valueOf(Messages.RemoveTraceFromExperimentHandler_Error) + trace.getName(), e);
                        }
                    }
                    subMonitor.setTaskName("");
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(e.toString(), e.getTargetException().toString());
            return null;
        }
        return null;
    }
}

