/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.swtchart.IAxis;
import org.swtchart.ISeries;

public class TmfClosestDataPointTooltipProvider
extends TmfBaseProvider
implements MouseTrackListener,
MouseMoveListener,
PaintListener {
    private static final int ALPHA = 128;
    private static final int HIGHLIGHT_RADIUS = 5;
    private int fHighlightX;
    private int fHighlightY;
    private boolean fIsHighlight;

    public TmfClosestDataPointTooltipProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.getChart().getPlotArea().addMouseTrackListener((MouseTrackListener)this);
        this.getChart().getPlotArea().addMouseMoveListener((MouseMoveListener)this);
        this.getChart().getPlotArea().addPaintListener((PaintListener)this);
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.getChart().getPlotArea().removeMouseTrackListener((MouseTrackListener)this);
            this.getChart().getPlotArea().removeMouseMoveListener((MouseMoveListener)this);
            this.getChart().getPlotArea().removePaintListener((PaintListener)this);
        }
    }

    @Override
    public void refresh() {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
        if (this.getChartViewer().getWindowDuration() != 0L && e != null) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            IAxis yAxis = this.getChart().getAxisSet().getYAxis(0);
            ISeries[] series = this.getChart().getSeriesSet().getSeries();
            double smallestDistance = Double.MAX_VALUE;
            Parameter param = null;
            int k = 0;
            while (k < series.length) {
                ISeries serie = series[k];
                double[] xS = serie.getXSeries();
                double[] yS = serie.getYSeries();
                if (xS != null && yS != null) {
                    int i = 0;
                    while (i < xS.length) {
                        int ys;
                        int xs = xAxis.getPixelCoordinate(xS[i]) - e.x;
                        double currentDistance = xs * xs + (ys = yAxis.getPixelCoordinate(yS[i]) - e.y) * ys;
                        if (currentDistance < smallestDistance && currentDistance < 25.0) {
                            smallestDistance = currentDistance;
                            this.fHighlightX = xs + e.x;
                            this.fHighlightY = ys + e.y;
                            if (param == null) {
                                param = new Parameter();
                            }
                            param.setSeriesIndex(k);
                            param.setDataIndex(i);
                        }
                        ++i;
                    }
                }
                ++k;
            }
            String tooltip = null;
            if (param != null && (tooltip = this.createToolTipText(param)) != null) {
                this.fIsHighlight = true;
                this.getChart().redraw();
            }
            this.getChart().getPlotArea().setToolTipText(tooltip);
        }
    }

    public void mouseMove(@Nullable MouseEvent e) {
        if (this.fIsHighlight) {
            this.fIsHighlight = false;
            this.getChart().redraw();
        }
    }

    public void paintControl(PaintEvent e) {
        if (this.fIsHighlight && e != null) {
            e.gc.setBackground(Display.getDefault().getSystemColor(3));
            e.gc.setAlpha(128);
            e.gc.fillOval(this.fHighlightX - 5, this.fHighlightY - 5, 10, 10);
        }
    }

    protected String createToolTipText(@NonNull Parameter param) {
        ISeries[] series = this.getChart().getSeriesSet().getSeries();
        int seriesIndex = param.getSeriesIndex();
        int dataIndex = param.getDataIndex();
        if (series != null && seriesIndex < series.length) {
            ISeries serie = series[seriesIndex];
            double[] xS = serie.getXSeries();
            double[] yS = serie.getYSeries();
            if (xS != null && yS != null && dataIndex < xS.length && dataIndex < yS.length) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("x=");
                buffer.append(TmfTimestamp.fromNanos((long)((long)xS[dataIndex] + this.getChartViewer().getTimeOffset())).toString());
                buffer.append('\n');
                buffer.append("y=");
                buffer.append((long)yS[dataIndex]);
                return buffer.toString();
            }
        }
        return null;
    }

    protected static class Parameter {
        private int seriesIndex;
        private int dataIndex;

        protected Parameter() {
        }

        public int getSeriesIndex() {
            return this.seriesIndex;
        }

        public void setSeriesIndex(int seriesIndex) {
            this.seriesIndex = seriesIndex;
        }

        public int getDataIndex() {
            return this.dataIndex;
        }

        public void setDataIndex(int dataIndex) {
            this.dataIndex = dataIndex;
        }
    }
}

