/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.FollowCpuAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.UnfollowCpuAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesPresentationProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesView
extends BaseDataProviderTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.views.resources";
    public static final @NonNull String RESOURCES_FOLLOW_CPU = "org.eclipse.tracecompass.analysis.os.linux.views.resources.FOLLOW_CPU";
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.ResourcesView_stateTypeName};
    private static final Comparator<ResourcesEntryModel> COMPARATOR = Comparator.comparing(resModel -> resModel.getType() == ResourcesEntryModel.Type.CURRENT_THREAD ? ResourcesEntryModel.Type.CPU : resModel.getType()).thenComparing(ResourcesEntryModel::getResourceId);

    public ResourcesView() {
        super(ID, (TimeGraphPresentationProvider)new ResourcesPresentationProvider(), "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ResourcesStatusDataProvider");
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new ResourcesFilterLabelProvider());
        this.setEntryComparator(new ResourcesEntryComparator());
        this.setAutoExpandLevel(1);
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
        TimeGraphEntry resourcesEntry;
        ITimeGraphEntryModel model;
        IStructuredSelection sSel;
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && (sSel = (IStructuredSelection)selection).getFirstElement() instanceof TimeGraphEntry && (model = (resourcesEntry = (TimeGraphEntry)sSel.getFirstElement()).getModel()) instanceof ResourcesEntryModel && ((ResourcesEntryModel)model).getType() == ResourcesEntryModel.Type.CPU) {
            int cpu;
            ResourcesEntryModel resourcesModel = (ResourcesEntryModel)model;
            ITmfTrace trace = ResourcesView.getTrace((TimeGraphEntry)resourcesEntry);
            TmfTraceContext ctx = TmfTraceManager.getInstance().getTraceContext(trace);
            Integer data = (Integer)ctx.getData(RESOURCES_FOLLOW_CPU);
            int n = cpu = data != null ? data : -1;
            if (cpu >= 0) {
                menuManager.add((IAction)new UnfollowCpuAction((TmfView)this, resourcesModel.getResourceId(), trace));
            } else {
                menuManager.add((IAction)new FollowCpuAction((TmfView)this, resourcesModel.getResourceId(), trace));
            }
        }
    }

    protected String getNextText() {
        return Messages.ResourcesView_nextResourceActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ResourcesView_nextResourceActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ResourcesView_previousResourceActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ResourcesView_previousResourceActionToolTipText;
    }

    @TmfSignalHandler
    public void listenToCpu(TmfCpuSelectedSignal signal) {
        int data = signal.getCore() >= 0 ? signal.getCore() : -1;
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        TmfTraceManager.getInstance().updateTraceContext(trace, builder -> builder.setData(RESOURCES_FOLLOW_CPU, (Object)data));
    }

    private static class ResourcesEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private ResourcesEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            if (o1 instanceof BaseDataProviderTimeGraphView.TraceEntry && o2 instanceof BaseDataProviderTimeGraphView.TraceEntry) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1 instanceof TimeGraphEntry && o2 instanceof TimeGraphEntry) {
                ITimeGraphEntryModel model1 = ((TimeGraphEntry)o1).getModel();
                ITimeGraphEntryModel model2 = ((TimeGraphEntry)o2).getModel();
                if (model1 instanceof ResourcesEntryModel && model2 instanceof ResourcesEntryModel) {
                    return COMPARATOR.compare((ResourcesEntryModel)model1, (ResourcesEntryModel)model2);
                }
            }
            return 0;
        }
    }

    private static class ResourcesFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private ResourcesFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof TimeGraphEntry) {
                return ((TimeGraphEntry)element).getName();
            }
            return "";
        }
    }
}

