/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.swtbot.tests.flamegraph;

import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.tracecompass.analysis.timing.core.tests.flamegraph.AggregationTreeTest;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.FlameGraphPresentationProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.FlameGraphView;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class FlameGraphTest
extends AggregationTreeTest {
    private static final String FLAMEGRAPH_ID = FlameGraphView.ID;
    private SWTWorkbenchBot fBot;
    private SWTBotView fView;
    private FlameGraphView fFg;
    private static final Logger fLogger = Logger.getRootLogger();
    private TimeGraphViewer fTimeGraphViewer;

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)bot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void afterClass() {
        fLogger.removeAllAppenders();
    }

    @Before
    public void before() {
        this.fBot = new SWTWorkbenchBot();
        SWTBotUtils.openView((String)FLAMEGRAPH_ID);
        SWTBotView view = this.fBot.viewById(FLAMEGRAPH_ID);
        Assert.assertNotNull((Object)view);
        this.fView = view;
        FlameGraphView flamegraph = (FlameGraphView)UIThreadRunnable.syncExec(() -> {
            IViewPart viewRef = this.fView.getViewReference().getView(true);
            return viewRef instanceof FlameGraphView ? (FlameGraphView)viewRef : null;
        });
        Assert.assertNotNull((Object)flamegraph);
        this.fTimeGraphViewer = flamegraph.getTimeGraphViewer();
        Assert.assertNotNull((Object)this.fTimeGraphViewer);
        SWTBotUtils.maximize((IWorkbenchPart)flamegraph);
        this.fFg = flamegraph;
    }

    private void loadFlameGraph() {
        UIThreadRunnable.syncExec(() -> this.fFg.buildFlameGraph((CallGraphAnalysis)this.getCga()));
        try {
            this.fFg.waitForUpdate();
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private ITimeGraphEntry selectRoot() {
        UIThreadRunnable.syncExec(() -> this.fTimeGraphViewer.selectNextItem());
        ITimeGraphEntry entry = this.fTimeGraphViewer.getSelection();
        Assert.assertNotNull((Object)entry);
        return entry;
    }

    private static ITimeEvent getFirstEvent(ITimeGraphEntry actualEntry) {
        Optional<@NonNull ITimeEvent> actualEventOpt = StreamSupport.stream(Spliterators.spliteratorUnknownSize(actualEntry.getTimeEventsIterator(), 256), false).filter(i -> i instanceof TimeEvent).filter(j -> !(j instanceof NullTimeEvent)).findFirst();
        Assert.assertTrue((boolean)actualEventOpt.isPresent());
        return actualEventOpt.get();
    }

    public void emptyStateSystemTest() {
        super.emptyStateSystemTest();
        this.loadFlameGraph();
        ITimeGraphEntry entry = this.fTimeGraphViewer.getSelection();
        Assert.assertNull((Object)entry);
    }

    public void cascadeTest() {
        super.cascadeTest();
        this.loadFlameGraph();
        ITimeGraphEntry entry = this.selectRoot();
        Assert.assertEquals((long)3L, (long)entry.getChildren().size());
        ITimeGraphEntry actualEntry = (ITimeGraphEntry)entry.getChildren().get(1);
        ITimeEvent actualEvent = FlameGraphTest.getFirstEvent(actualEntry);
        Assert.assertNotNull((Object)actualEvent);
        Assert.assertEquals((long)996L, (long)actualEvent.getDuration());
    }

    public void mergeFirstLevelCalleesTest() {
        super.mergeFirstLevelCalleesTest();
        this.loadFlameGraph();
        ITimeGraphEntry entry = this.selectRoot();
        Assert.assertEquals((long)3L, (long)entry.getChildren().size());
        ITimeGraphEntry actualEntry = (ITimeGraphEntry)entry.getChildren().get(1);
        ITimeEvent actualEvent = FlameGraphTest.getFirstEvent(actualEntry);
        Assert.assertNotNull((Object)actualEvent);
        Assert.assertEquals((long)80L, (long)actualEvent.getDuration());
    }

    public void multiFunctionRootsSecondTest() {
        super.multiFunctionRootsSecondTest();
        this.loadFlameGraph();
        ITimeGraphEntry entry = this.selectRoot();
        Assert.assertEquals((long)2L, (long)entry.getChildren().size());
        ITimeGraphEntry actualEntry = (ITimeGraphEntry)entry.getChildren().get(1);
        ITimeEvent actualEvent = FlameGraphTest.getFirstEvent(actualEntry);
        Assert.assertNotNull((Object)actualEvent);
        Assert.assertEquals((long)10L, (long)actualEvent.getDuration());
    }

    public void mergeSecondLevelCalleesTest() {
        super.mergeSecondLevelCalleesTest();
        this.loadFlameGraph();
        ITimeGraphEntry entry = this.selectRoot();
        Assert.assertEquals((long)4L, (long)entry.getChildren().size());
        ITimeGraphEntry actualEntry = (ITimeGraphEntry)entry.getChildren().get(1);
        ITimeEvent actualEvent = FlameGraphTest.getFirstEvent(actualEntry);
        Assert.assertNotNull((Object)actualEvent);
        Assert.assertEquals((long)90L, (long)actualEvent.getDuration());
    }

    public void multiFunctionRootsTest() {
        super.multiFunctionRootsTest();
        this.loadFlameGraph();
        ITimeGraphEntry entry = this.selectRoot();
        Assert.assertEquals((long)2L, (long)entry.getChildren().size());
        ITimeGraphEntry actualEntry = (ITimeGraphEntry)entry.getChildren().get(1);
        ITimeEvent actualEvent = FlameGraphTest.getFirstEvent(actualEntry);
        Assert.assertNotNull((Object)actualEvent);
        Assert.assertEquals((long)10L, (long)actualEvent.getDuration());
    }

    public void treeTest() {
        super.treeTest();
        this.loadFlameGraph();
        ITimeGraphEntry entry = this.selectRoot();
        Assert.assertEquals((long)3L, (long)entry.getChildren().size());
        ITimeGraphEntry actualEntry = (ITimeGraphEntry)entry.getChildren().get(1);
        ITimeEvent actualEvent = FlameGraphTest.getFirstEvent(actualEntry);
        Assert.assertNotNull((Object)actualEvent);
        Assert.assertEquals((long)80L, (long)actualEvent.getDuration());
        Map tooltip = new FlameGraphPresentationProvider().getEventHoverToolTipInfo(actualEvent);
        Assert.assertNull((Object)tooltip);
        tooltip = new FlameGraphPresentationProvider().getEventHoverToolTipInfo(actualEvent, 5L);
        Assert.assertTrue((boolean)tooltip.toString().contains("duration=80 ns"));
        Assert.assertTrue((boolean)tooltip.toString().contains("duration=40 ns"));
    }

    @Test
    public void tryMouseDoubleclickZoom() throws InterruptedException {
        super.treeTest();
        this.loadFlameGraph();
        SWTBotTimeGraph sbtg = new SWTBotTimeGraph(this.fView.bot());
        SWTBotTimeGraphEntry sbtge = sbtg.getEntry(new String[]{""});
        Assert.assertEquals((long)3L, (long)sbtge.getEntries().length);
        SWTBotTimeGraphEntry actualEntry = sbtge.getEntry("1");
        actualEntry.doubleClick(40L);
        this.fFg.waitForUpdate();
        Assert.assertEquals((Object)new TmfTimeRange(TmfTimestamp.fromNanos((long)0L), TmfTimestamp.fromNanos((long)80L)), (Object)new TmfTimeRange(TmfTimestamp.fromNanos((long)this.fTimeGraphViewer.getTime0()), TmfTimestamp.fromNanos((long)this.fTimeGraphViewer.getTime1())));
    }

    public void largeTest() {
        super.largeTest();
        this.loadFlameGraph();
        ITimeGraphEntry entry = this.selectRoot();
        Assert.assertEquals((long)1000L, (long)entry.getChildren().size());
        ITimeGraphEntry actualEntry = (ITimeGraphEntry)entry.getChildren().get(1);
        ITimeEvent actualEvent = FlameGraphTest.getFirstEvent(actualEntry);
        Assert.assertNotNull((Object)actualEvent);
        Assert.assertEquals((long)10L, (long)actualEvent.getDuration());
    }
}

