/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.format;

import java.text.Format;
import java.text.ParseException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.junit.Assert;
import org.junit.Test;

public class DecimalUnitFormatErrorTest {
    private static final @NonNull Format FORMATTER = new DecimalUnitFormat();

    @Test(expected=IllegalArgumentException.class)
    public void testFormatIllegalArgument() {
        FORMATTER.format("Toto");
    }

    @Test(expected=ParseException.class)
    public void testParseNotANumber() throws ParseException {
        FORMATTER.parseObject("Toto");
    }

    @Test
    public void testParseWithUnit() throws ParseException {
        FORMATTER.parseObject("1.2 s");
    }

    @Test
    public void testParsePrefixWithUnitAndPrefix() throws ParseException {
        Assert.assertEquals((Object)0.0012, (Object)FORMATTER.parseObject("1.2 ms"));
    }

    @Test
    public void testParseSpecialWithPrefix() throws ParseException {
        Assert.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)FORMATTER.parseObject("\u221e k"));
        Assert.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)FORMATTER.parseObject("-\u221e p"));
        Assert.assertEquals((Object)Double.NaN, (Object)FORMATTER.parseObject("\ufffdM"));
    }
}

