/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.integration.swtbot.tests.markers;

import java.io.File;
import java.util.List;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEclipseEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRootMenu;
import org.eclipse.tracecompass.lttng2.ust.core.tests.shared.LttngUstTestTraceUtils;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class MarkerSetSwtBotTest {
    private static final String XML_CONTENT = "<marker-sets>  <marker-set name=\"Set A\" id=\"set.a\">    <marker name=\"Marker A-1\" label=\"A-1 %d\" id=\"marker.a.1\" referenceid=\"ref.a.1\" color=\"blue\" period=\"10\" unit=\"ns\" range=\"0..4095\" offset=\"0\">    </marker>  </marker-set><marker-set name=\"Set B\" id=\"set.b\">    <marker name=\"Marker B-1\" label=\"B-1 %d\" id=\"marker.b.1\" referenceid=\"ref.b.1\" color=\"#010203\" period=\"1000\" unit=\"cycles\" range=\"1..\" offset=\"5\">    </marker>  </marker-set></marker-sets>";
    private static final String EDITOR_TITLE = "markers.xml";
    private static final String TRACE_PROJECT_NAME = "test_project";
    private static final String UST_ID = "org.eclipse.linuxtools.lttng2.ust.tracetype";
    private static SWTWorkbenchBot fBot;
    private static SWTBotView fViewBot;
    private static String[] MENU_ITEMS_NO_MARKERS_SET;
    private static String[] MENU_ITEMS_2_MARKERS_SET;
    private static long fStart;
    private static TmfTimeRange fFullRange;

    static {
        MENU_ITEMS_NO_MARKERS_SET = new String[]{"None", "Example", "", "Edit..."};
        MENU_ITEMS_2_MARKERS_SET = new String[]{"None", "Set A", "Set B", "Example", "", "Edit..."};
    }

    @BeforeClass
    public static void setUp() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 10000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"Welcome", (SWTWorkbenchBot)fBot);
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
        CtfTestTrace cygProfile = CtfTestTrace.CYG_PROFILE;
        LttngUstTrace trace = LttngUstTestTraceUtils.getTrace((CtfTestTrace)cygProfile);
        fStart = trace.getStartTime().toNanos();
        fFullRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)fStart), TmfTimestamp.fromNanos((long)(fStart + 100L)));
        File file = new File(trace.getPath());
        LttngUstTestTraceUtils.dispose((CtfTestTrace)cygProfile);
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)file.getAbsolutePath(), (String)UST_ID);
        SWTBotUtils.openView((String)"org.eclipse.linuxtools.tmf.ui.views.callstack");
        fViewBot = fBot.viewByTitle("Call Stack");
        WaitUtils.waitForJobs();
    }

    @Test
    public void testMenuNoMarkerSet() {
        SWTBotRootMenu viewMenu = fViewBot.viewMenu();
        List menuItems = viewMenu.menu(new String[]{"Marker Set"}).menuItems();
        Assert.assertArrayEquals((String)"menu items, no marker set", (Object[])MENU_ITEMS_NO_MARKERS_SET, (Object[])menuItems.toArray());
    }

    @Test
    public void testEditMarkerSet() {
        MarkerSetSwtBotTest.insertContent();
        SWTBotRootMenu viewMenu = fViewBot.viewMenu();
        List menuItems = viewMenu.menu(new String[]{"Marker Set"}).menuItems();
        Assert.assertArrayEquals((String)"menu items, two marker sets", (Object[])MENU_ITEMS_2_MARKERS_SET, (Object[])menuItems.toArray());
        Assert.assertTrue((String)"None is checked", (boolean)viewMenu.menu(new String[]{"Marker Set"}).menu(MENU_ITEMS_2_MARKERS_SET[0]).isChecked());
        viewMenu.menu(new String[]{"Marker Set", MENU_ITEMS_2_MARKERS_SET[1]}).click();
        Assert.assertTrue((String)"Set A is checked", (boolean)viewMenu.menu(new String[]{"Marker Set"}).menu(MENU_ITEMS_2_MARKERS_SET[1]).isChecked());
        viewMenu.menu(new String[]{"Marker Set", MENU_ITEMS_2_MARKERS_SET[2]}).click();
        Assert.assertTrue((String)"set B is checked", (boolean)viewMenu.menu(new String[]{"Marker Set"}).menu(MENU_ITEMS_2_MARKERS_SET[2]).isChecked());
        viewMenu.menu(new String[]{"Marker Set", MENU_ITEMS_2_MARKERS_SET[0]}).click();
        Assert.assertTrue((String)"None is checked", (boolean)viewMenu.menu(new String[]{"Marker Set"}).menu(MENU_ITEMS_2_MARKERS_SET[0]).isChecked());
        MarkerSetSwtBotTest.removeContent();
        menuItems = viewMenu.menu(new String[]{"Marker Set"}).menuItems();
        Assert.assertArrayEquals((String)"menu items, no marker set", (Object[])MENU_ITEMS_NO_MARKERS_SET, (Object[])menuItems.toArray());
    }

    @Test
    public void testNavigateBetweenMarkers() {
        AbstractTimeGraphView part = (AbstractTimeGraphView)fViewBot.getViewReference().getPart(false);
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, fFullRange));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)fFullRange));
        MarkerSetSwtBotTest.insertContent();
        fViewBot.setFocus();
        SWTBotRootMenu viewMenu = fViewBot.viewMenu();
        viewMenu.menu(new String[]{"Marker Set", "Set A"}).click();
        fBot.waitUntil(ConditionHelpers.timeGraphIsReadyCondition((AbstractTimeGraphView)part, (TmfTimeRange)new TmfTimeRange(TmfTimestamp.fromNanos((long)fStart), TmfTimestamp.fromNanos((long)fStart)), (ITmfTimestamp)TmfTimestamp.fromNanos((long)fStart)));
        fViewBot.toolbarButton("Next Marker").click();
        long period = 10L;
        long nextStart = fStart + (period - fStart % period);
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TmfTimestamp.fromNanos((long)nextStart), TmfTimestamp.fromNanos((long)(nextStart + period)))));
        viewMenu.menu(new String[]{"Show Markers", "Marker A-1"}).hide();
        fViewBot.toolbarButton("Previous Marker").click();
        fBot.waitUntil(ConditionHelpers.timeGraphIsReadyCondition((AbstractTimeGraphView)part, (TmfTimeRange)new TmfTimeRange(TmfTimestamp.fromNanos((long)fStart), TmfTimestamp.fromNanos((long)nextStart)), (ITmfTimestamp)TmfTimestamp.fromNanos((long)fStart)));
        MarkerSetSwtBotTest.removeContent();
    }

    private static void insertContent() {
        SWTBotRootMenu viewMenu = fViewBot.viewMenu();
        viewMenu.menu(new String[]{"Marker Set"}).menu("Edit...").click();
        fBot.waitUntil(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)EDITOR_TITLE));
        SWTBotEclipseEditor editor = fBot.editorByTitle(EDITOR_TITLE).toTextEditor();
        editor.setText(XML_CONTENT);
        editor.saveAndClose();
        WaitUtils.waitForJobs();
    }

    private static void removeContent() {
        SWTBotRootMenu viewMenu = fViewBot.viewMenu();
        viewMenu.menu(new String[]{"Marker Set"}).menu("Edit...").click();
        fBot.waitUntil(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)EDITOR_TITLE));
        SWTBotEclipseEditor editor = fBot.editorByTitle(EDITOR_TITLE).toTextEditor();
        editor.setText("<marker-sets></marker-sets>");
        editor.saveAndClose();
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void tearDown() {
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }
}

