/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.shared.utils;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.junit.Assert;

public final class StateSystemTestUtils {
    private StateSystemTestUtils() {
    }

    public static void testIntervalForAttributes(ITmfStateSystem ss, List<ITmfStateInterval> expected, String ... path) {
        try {
            int quark = ss.getQuarkAbsolute(path);
            List actual = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)quark, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
            int i = 0;
            while (i < expected.size()) {
                if (i >= actual.size()) {
                    Assert.fail((String)(String.valueOf(Arrays.deepToString(path)) + ": Missing interval " + i));
                }
                ITmfStateInterval act = (ITmfStateInterval)actual.get(i);
                ITmfStateInterval exp = expected.get(i);
                if (!StateSystemTestUtils.compareIntervalContent(exp, act)) {
                    Assert.fail((String)(String.valueOf(Arrays.deepToString(path)) + ":Interval at position " + i + ": expected: " + StateSystemTestUtils.displayInterval(exp) + " actual: " + StateSystemTestUtils.displayInterval(act)));
                }
                ++i;
            }
            Assert.assertEquals((String)(String.valueOf(Arrays.deepToString(path)) + ":Number of intervals"), (long)expected.size(), (long)actual.size());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)("Attribute " + Arrays.deepToString(path) + " does not exist"));
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)"State system was disposed");
        }
    }

    private static boolean compareIntervalContent(ITmfStateInterval expected, ITmfStateInterval actual) {
        Object expectedVal = expected.getValue();
        Object actualVal = actual.getValue();
        return expected.getStartTime() == actual.getStartTime() && expected.getEndTime() == actual.getEndTime() && Objects.equal((Object)expectedVal, (Object)actualVal);
    }

    private static String displayInterval(ITmfStateInterval interval) {
        return "[" + interval.getStartTime() + "," + interval.getEndTime() + "]:" + interval.getValue();
    }

    public static void testValuesAtTime(ITmfStateSystem ss, long t, Map<String[], ITmfStateValue> expected) {
        try {
            List intervals = ss.queryFullState(t);
            for (Map.Entry<String[], ITmfStateValue> entry : expected.entrySet()) {
                Object[] path = entry.getKey();
                try {
                    int quark = ss.getQuarkAbsolute(entry.getKey());
                    ITmfStateInterval interval = (ITmfStateInterval)intervals.get(quark);
                    Assert.assertEquals((String)(String.valueOf(Arrays.deepToString(path)) + " at time " + t), (Object)entry.getValue(), (Object)interval.getStateValue());
                }
                catch (AttributeNotFoundException e) {
                    Assert.fail((String)("Attribute " + Arrays.deepToString(path) + " does not exist at time " + t));
                }
            }
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)"State system was disposed");
        }
    }

    public static @NonNull String[] makeAttribute(String ... path) {
        return path;
    }
}

