/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileInputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public class InMemoryBackend
implements IStateHistoryBackend {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(InMemoryBackend.class);
    private final @NonNull String ssid;
    private final NavigableSet<@NonNull ITmfStateInterval> intervals;
    private final long startTime;
    private volatile long latestTime;

    public InMemoryBackend(@NonNull String ssid, long startTime) {
        this.ssid = ssid;
        this.startTime = startTime;
        this.latestTime = startTime;
        this.intervals = new TreeSet<ITmfStateInterval>(Comparator.comparing(ITmfStateInterval::getEndTime).thenComparing(ITmfStateInterval::getAttribute));
    }

    @Override
    public String getSSID() {
        return this.ssid;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.latestTime;
    }

    @Override
    @Deprecated
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        this.insertPastState(stateStartTime, stateEndTime, quark, value.unboxValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, Object value) throws TimeRangeException {
        if (stateStartTime > stateEndTime || stateStartTime < this.startTime) {
            throw new TimeRangeException(String.valueOf(this.ssid) + " Interval Start:" + stateStartTime + ", Interval End:" + stateEndTime + ", Backend Start:" + this.startTime);
        }
        TmfStateInterval interval = new TmfStateInterval(stateStartTime, stateEndTime, quark, value);
        NavigableSet<ITmfStateInterval> navigableSet = this.intervals;
        synchronized (navigableSet) {
            this.intervals.add(interval);
        }
        if (stateEndTime > this.latestTime) {
            this.latestTime = stateEndTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doQuery(List<ITmfStateInterval> currentStateInfo, long t) throws TimeRangeException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException(String.valueOf(this.ssid) + " Time:" + t + ", Start:" + this.startTime + ", End:" + this.latestTime);
        }
        NavigableSet<ITmfStateInterval> navigableSet = this.intervals;
        synchronized (navigableSet) {
            Iterator<ITmfStateInterval> iter = InMemoryBackend.searchforEndTime(this.intervals, 0, t).iterator();
            int modCount = 0;
            while (iter.hasNext() && modCount < currentStateInfo.size()) {
                ITmfStateInterval entry = iter.next();
                long entryStartTime = entry.getStartTime();
                if (entryStartTime > t) continue;
                currentStateInfo.set(entry.getAttribute(), entry);
                ++modCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException(String.valueOf(this.ssid) + " Time:" + t + ", Start:" + this.startTime + ", End:" + this.latestTime);
        }
        NavigableSet<ITmfStateInterval> navigableSet = this.intervals;
        synchronized (navigableSet) {
            Iterable<ITmfStateInterval> iter = InMemoryBackend.searchforEndTime(this.intervals, attributeQuark, t);
            for (ITmfStateInterval entry : iter) {
                boolean attributeMatches = entry.getAttribute() == attributeQuark;
                long entryStartTime = entry.getStartTime();
                if (!attributeMatches || entryStartTime > t) continue;
                return entry;
            }
        }
        return null;
    }

    private boolean checkValidTime(long t) {
        return t >= this.startTime && t <= this.latestTime;
    }

    @Override
    public void finishedBuilding(long endTime) throws TimeRangeException {
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return null;
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return null;
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return -1L;
    }

    @Override
    public void removeFiles() {
    }

    @Override
    public void dispose() {
    }

    private static Iterable<@NonNull ITmfStateInterval> searchforEndTime(NavigableSet<@NonNull ITmfStateInterval> tree, int quark, long time) {
        TmfStateInterval dummyInterval = new TmfStateInterval(-1L, time, quark, (Object)null);
        return tree.tailSet(dummyInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<@NonNull ITmfStateInterval> query2D(IntegerRangeCondition quarks, TimeRangeCondition times) throws TimeRangeException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINER, "InMemoryBackend:query2D", new Object[]{"ssid", this.getSSID(), "quarks", quarks, "times", times});){
            Iterable iterable;
            NavigableSet<ITmfStateInterval> navigableSet = this.intervals;
            synchronized (navigableSet) {
                iterable = Iterables.filter(InMemoryBackend.searchforEndTime(this.intervals, quarks.min(), times.min()), interval -> quarks.test(interval.getAttribute()) && times.intersects(interval.getStartTime(), interval.getEndTime()));
            }
            return iterable;
            {
                catch (Throwable throwable2) {
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }
}

