/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.perf.views;

import java.io.File;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.ui.IWorkbenchPart;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public abstract class ViewsResponseTest {
    private static final String PROJECT_NAME = "test";
    private final @NonNull SWTWorkbenchBot fBot = new SWTWorkbenchBot();

    protected abstract void prepareWorkspace();

    @Before
    public void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 60000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", bot);
        this.prepareWorkspace();
        WaitUtils.waitForJobs();
        SWTBotUtils.createProject(PROJECT_NAME);
    }

    @After
    public void cleanUp() {
        this.fBot.closeAllEditors();
        SWTBotUtils.deleteProject(PROJECT_NAME, this.fBot);
    }

    private void closeAllViews(Collection<String> viewIDs) {
        viewIDs.stream().forEach(id -> {
            SWTBotUtils.openView(id);
            SWTBotUtils.closeViewById(id, this.fBot);
        });
    }

    protected abstract void beforeRunningTest(ITmfTrace var1);

    protected void runTestWithTrace(String tracePath, String traceType, Collection<String> viewIDs) {
        SWTBotView view;
        this.closeAllViews(viewIDs);
        String traceName = tracePath.substring(tracePath.lastIndexOf(File.separator, tracePath.length() - 2) + 1, tracePath.length() - 1);
        SWTBotUtils.openTrace(PROJECT_NAME, tracePath, traceType);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        this.beforeRunningTest(trace);
        WaitUtils.waitForJobs();
        for (String viewID : viewIDs) {
            SWTBotUtils.openView(viewID);
            view = this.fBot.viewById(viewID);
            this.prepareView(view);
            this.navigateTrace(view);
            SWTBotUtils.closeViewById(viewID, this.fBot);
        }
        this.fBot.closeAllEditors();
        if (viewIDs.size() <= 1) {
            this.closeAllViews(viewIDs);
            return;
        }
        view = null;
        for (String viewID : viewIDs) {
            SWTBotUtils.openView(viewID);
            if (view != null) continue;
            view = this.fBot.viewById(viewID);
        }
        this.renameTrace(traceName, String.valueOf(traceName) + " full");
        this.navigateTrace(view);
        this.fBot.closeAllEditors();
        this.closeAllViews(viewIDs);
    }

    private void renameTrace(String oldName, String newName) {
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)this.fBot, SWTBotUtils.selectTracesFolder(this.fBot, PROJECT_NAME), oldName);
        traceItem.contextMenu().menu(new String[]{"Rename..."}).click();
        String RENAME_TRACE_DIALOG_TITLE = "Rename Trace";
        SWTBotShell shell = this.fBot.shell("Rename Trace").activate();
        SWTBotText text = shell.bot().textWithLabel("New Trace name:");
        text.setText(newName);
        shell.bot().button("OK").click();
        this.fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        this.fBot.waitWhile((ICondition)new ConditionHelpers.ActiveEventsEditor(this.fBot, null));
        SWTBotTreeItem copiedItem = SWTBotUtils.getTraceProjectItem((SWTBot)this.fBot, SWTBotUtils.selectTracesFolder(this.fBot, PROJECT_NAME), newName);
        copiedItem.contextMenu().menu(new String[]{"Open"}).click();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        WaitUtils.waitForJobs();
    }

    private void navigateTrace(SWTBotView view) {
        TmfTimeRange newWindowRange;
        TmfTimeRange originalWindowRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
        TmfTimeRange selectionRange = TmfTraceManager.getInstance().getCurrentTraceContext().getSelectionRange();
        IWorkbenchPart part = view.getViewReference().getPart(false);
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)activeTrace);
        Performance perf = Performance.getDefault();
        PerformanceMeter pmBuild = perf.createPerformanceMeter("UI responsiveness: " + activeTrace.getName() + "/" + view.getTitle());
        perf.tagAsSummary(pmBuild, String.valueOf(view.getTitle()) + " CPU", Dimension.CPU_TIME);
        TmfTimeRange fullRange = new TmfTimeRange(activeTrace.getStartTime(), activeTrace.getEndTime());
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, fullRange));
        pmBuild.start();
        this.waitViewReady(part, selectionRange, fullRange.getEndTime());
        pmBuild.stop();
        TmfTimeRange windowRange = fullRange;
        int i = 0;
        while (i < 10) {
            double delta = (double)(windowRange.getEndTime().getValue() - windowRange.getStartTime().getValue()) * 0.15;
            newWindowRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)((long)((double)windowRange.getStartTime().toNanos() + delta))), TmfTimestamp.fromNanos((long)((long)((double)windowRange.getEndTime().toNanos() - delta))));
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, newWindowRange));
            pmBuild.start();
            windowRange = newWindowRange;
            this.waitViewReady(part, selectionRange, newWindowRange.getEndTime());
            pmBuild.stop();
            ++i;
        }
        long scrollTime = (windowRange.getEndTime().toNanos() - windowRange.getStartTime().toNanos()) / 2L;
        windowRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)(fullRange.getEndTime().toNanos() - 2L * scrollTime)), fullRange.getEndTime());
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, windowRange));
        pmBuild.start();
        this.waitViewReady(part, selectionRange, windowRange.getEndTime());
        pmBuild.stop();
        int i2 = 0;
        while (i2 < 10) {
            newWindowRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)(windowRange.getStartTime().toNanos() - scrollTime)), TmfTimestamp.fromNanos((long)(windowRange.getEndTime().toNanos() - scrollTime)));
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, newWindowRange));
            pmBuild.start();
            windowRange = newWindowRange;
            this.waitViewReady(part, selectionRange, newWindowRange.getEndTime());
            pmBuild.stop();
            ++i2;
        }
        windowRange = new TmfTimeRange(fullRange.getStartTime(), TmfTimestamp.fromNanos((long)(fullRange.getStartTime().toNanos() + scrollTime)));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, windowRange));
        pmBuild.start();
        this.waitViewReady(part, selectionRange, windowRange.getEndTime());
        pmBuild.stop();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, fullRange));
        pmBuild.start();
        this.waitViewReady(part, selectionRange, fullRange.getEndTime());
        pmBuild.stop();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, originalWindowRange));
        pmBuild.start();
        this.waitViewReady(part, selectionRange, originalWindowRange.getEndTime());
        pmBuild.stop();
        pmBuild.commit();
    }

    private void waitViewReady(IWorkbenchPart part, @NonNull TmfTimeRange selectionRange, @NonNull ITmfTimestamp visibleTime) {
        if (part instanceof AbstractTimeGraphView) {
            this.fBot.waitUntil(ConditionHelpers.timeGraphIsReadyCondition((AbstractTimeGraphView)part, selectionRange, visibleTime));
        } else if (part instanceof TmfChartView) {
            TmfChartView tmfChartView = (TmfChartView)part;
            WaitUtils.waitUntil(cv -> !cv.isDirty(), (Object)tmfChartView, (String)"TmfChartView is dirty");
        }
    }

    public void prepareView(SWTBotView view) {
    }
}

