/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.ExportToTsvAction;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;

public abstract class AbstractSegmentsStatisticsView
extends TmfView {
    private final Action fExportAction = new ExportToTsvAction(){

        @Override
        protected void exportToTsv(@Nullable OutputStream stream) {
            AbstractSegmentsStatisticsView.this.exportToTsv(stream);
        }

        @Override
        protected @Nullable Shell getShell() {
            return AbstractSegmentsStatisticsView.this.getViewSite().getShell();
        }
    };
    private @Nullable AbstractTmfTreeViewer fStatsViewer = null;

    public AbstractSegmentsStatisticsView() {
        super("StatisticsView");
    }

    public void createPartControl(@Nullable Composite parent) {
        super.createPartControl(parent);
        AbstractTmfTreeViewer statsViewer = this.createSegmentStoreStatisticsViewer((Composite)NonNullUtils.checkNotNull((Object)parent));
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            statsViewer.loadTrace(trace);
        }
        this.fStatsViewer = statsViewer;
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.fExportAction);
    }

    public void setFocus() {
        AbstractTmfTreeViewer statsViewer = this.fStatsViewer;
        if (statsViewer != null) {
            statsViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        AbstractTmfTreeViewer statsViewer = this.fStatsViewer;
        if (statsViewer != null) {
            statsViewer.dispose();
        }
    }

    protected abstract AbstractTmfTreeViewer createSegmentStoreStatisticsViewer(Composite var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected void exportToTsv(@Nullable OutputStream stream) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            PrintWriter pw = new PrintWriter(stream);
            try {
                String valueOf;
                AbstractTmfTreeViewer statsViewer = this.fStatsViewer;
                if (statsViewer == null) {
                    return;
                }
                Tree tree = statsViewer.getTreeViewer().getTree();
                int size = tree.getItemCount();
                ArrayList<String> columns = new ArrayList<String>();
                int i = 0;
                while (!(i >= tree.getColumnCount() || (valueOf = String.valueOf(tree.getColumn(i).getText())).isEmpty() && i == tree.getColumnCount() - 1)) {
                    columns.add(valueOf);
                    ++i;
                }
                String join = Joiner.on((char)'\t').skipNulls().join(columns);
                pw.println(join);
                int i2 = 0;
                while (true) {
                    if (i2 >= size) {
                        return;
                    }
                    TreeItem item = tree.getItem(i2);
                    this.printItem(pw, columns, item);
                    ++i2;
                }
            }
            finally {
                if (pw == null) return;
                pw.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void printItem(PrintWriter pw, List<String> columns, @Nullable TreeItem item) {
        if (item == null) {
            return;
        }
        ArrayList<String> data = new ArrayList<String>();
        int col = 0;
        while (col < columns.size()) {
            data.add(String.valueOf(item.getText(col)));
            ++col;
        }
        pw.println(Joiner.on((char)'\t').join(data));
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.printItem(pw, columns, child);
            ++n2;
        }
    }
}

