/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.presentation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tracecompass.internal.tmf.core.presentation.YAppearance;
import org.eclipse.tracecompass.tmf.core.presentation.DefaultColorPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.IXYPresentationProvider;
import org.eclipse.tracecompass.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;

public class XYPresentationProvider
implements IXYPresentationProvider {
    private static final List<String> SUPPORTED_STYLES = ImmutableList.of((Object)"SOLID", (Object)"DASH", (Object)"DOT", (Object)"DASHDOT", (Object)"DASHDOTDOT");
    private static final List<String> SUPPORTED_TYPES = ImmutableList.of((Object)"area", (Object)"bar", (Object)"line", (Object)"scatter");
    private static final IPaletteProvider COLOR_PALETTE = DefaultColorPaletteProvider.INSTANCE;
    private final Map<String, IYAppearance> fYAppearances = new HashMap<String, IYAppearance>();

    @Override
    public synchronized IYAppearance getAppearance(String serieName, String seriesType, int width) {
        IYAppearance appearance = this.fYAppearances.get(serieName);
        if (appearance != null) {
            return appearance;
        }
        if (!SUPPORTED_TYPES.contains(seriesType)) {
            throw new UnsupportedOperationException("Series type: " + seriesType + " is not supported.");
        }
        appearance = this.createAppearance(serieName, seriesType, width);
        this.fYAppearances.put(serieName, appearance);
        return appearance;
    }

    @Override
    public void clear() {
        this.fYAppearances.clear();
    }

    private IYAppearance createAppearance(String seriesName, String seriesType, int width) {
        RGBAColor color = this.generateColor();
        String style = this.generateStyle(seriesType);
        return new YAppearance(seriesName, seriesType, style, color, width);
    }

    private RGBAColor generateColor() {
        Object colors = COLOR_PALETTE.get();
        return (RGBAColor)Iterables.get((Iterable)colors, (int)(this.fYAppearances.keySet().size() % colors.size()));
    }

    private String generateStyle(String type) {
        if (!"scatter".equals(type)) {
            int nbColor = COLOR_PALETTE.get().size();
            return (String)Iterables.get(SUPPORTED_STYLES, (int)(this.fYAppearances.keySet().size() / nbColor % SUPPORTED_STYLES.size()));
        }
        return "NONE";
    }
}

